﻿using System.ServiceModel;

using HIPS.ServiceContracts.Cda.Message;
using HIPS.ServiceContracts.Common.Fault;

namespace HIPS.ServiceContracts.Cda
{
    /// <summary>
    /// Web service interface for the CDA service. 
    /// Used by the P2P Module to package a CDA document for sending via SMD and unpackaging a CDA document received via SMD.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.CDA_V1)]
    public interface ICdaService
    {
        /// <summary>
        /// Package a CDA document.
        /// Used by the P2P module to package a CDA® document for sending via the SMD. 
        /// All validation is done as part of the P2P module before the CDA® Packaging is invoked.
        /// A successful response indicates the document has been sent to the SMD service successfully. 
        /// The SMD component will attempt to send the message and any errors are handled in this component.
        /// </summary>
        /// <param name="request">Request Message</param>
        /// <returns>Response Message</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        PackageCdaResponse PackageCdaDocument(PackageCdaRequest request);

        /// <summary>
        /// Unpackage a CDA document.
        /// Used by the P2P module to unpack a CDA® document that has been sent via the SMD Component. 
        /// The result is sent back as the Unpackage CDA® Document response. 
        /// </summary>
        /// <param name="request">Request Message</param>
        /// <returns>Response Message</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        UnpackageCdaResponse UnpackageCdaDocument(UnpackageCdaRequest request);

        /// <summary>
        /// Get the content from a provided CDA unpackaged document.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        GetCdaContentResponse GetCdaContent(GetCdaContentRequest request);
        
        /// <summary>
        /// Creates a CDA discharge summary document that wraps a PDF document body.
        /// This may be for the purpose of uploading the discharge summary to the
        /// PCEHR or for provider-to-provider (P2P) secure message delivery (SMD).
        /// This takes in the PDF document, required metadata, and any attachments
        /// and creates a CDA document.
        /// </summary>
        /// <param name="request">Request containing a PDF and required metadata for creating the CDA package.</param>
        /// <returns>Response containing details of the created document.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(PcehrServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        CreateDischargeSummaryLevel1AResponse CreateDischargeSummaryLevel1A(CreateDischargeSummaryLevel1ARequest request);
    }
}