﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Cda.Message
{
    /// <summary>
    /// Request message for the PackageCda service operation.
    /// </summary>
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.CDA_V1)]
    public class PackageCdaRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets the CDA document.
        /// </summary>
        [MessageBodyMember(Order = 1)]
        public CdaDocument Document;

        /// <summary>
        /// Gets or sets the package format.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        public CdaPackageFormat Format;

        /// <summary>
        /// Gets or sets the hospital code.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        public string HospitalCode { get; set; }

        /// <summary>
        /// Gets or sets the hospital code system.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        public string HospitalCodeSystem { get; set; }

        /// <summary>
        /// Gets or sets the SMD Invocation Identifier.
        /// </summary>
        [MessageBodyMember(Order = 5)]
        public string SmdInvocationIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the message sender.
        /// </summary>
        [MessageBodyMember(Order = 6)]
        public MessageAddressee Sender { get; set; }

        /// <summary>
        /// Gets or sets the message recipient.
        /// </summary>
        [MessageBodyMember(Order = 7)]
        public MessageAddressee Recipient { get; set; }

    }
}
