﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Message Addressee DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class MessageAddressee
    {
        /// <summary>
        /// Gets or sets the organisation.
        /// </summary>
        [DataMember(IsRequired = true)]
        public ProviderOrganisationIdentity Organisation { get; set; }

        /// <summary>
        /// Gets or sets the individual.
        /// </summary>
        [DataMember(IsRequired = false)]
        public ProviderIndividualIdentity Individual { get; set; }
    }
}
