﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.PatientIdentifier
{
    /// <summary>
    /// Abstract base class for identifying a patient.
    /// </summary>
    [KnownType(typeof(Mrn))]
    [KnownType(typeof(StatePatientId))]
    [KnownType(typeof(PatientMasterId))]
    [KnownType(typeof(ValidatedIhi))]
    [KnownType(typeof(RegisteredEnterprisePatient))]
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public abstract class PatientIdentifierBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the alternate organisation name. -- OPTIONAL
        /// As defined in "PCEHR R12 Implementation Guide", the accessing organisation
        /// may choose to disclose a different organisation name on the PCEHR Audit Log
        /// by populating the alternateOrganisationName in the PCEHR header.
        /// </summary>
        /// <value>
        /// The alternate organisation name.
        /// </value>
        [DataMember(IsRequired = false)]
        public string AlternateOrganisationName { get; set; }

        /// <summary>
        /// Gets or sets the hospital code. This code, qualified by the hospital code system,
        /// is used to determine:
        /// a) Which hospital allocated the MRN, if the Mrn subclass is used.
        /// b) Which hospital the episode occurred in, for consent, upload and remove calls.
        /// c) Which authorised employee is identified, if the user.Role is AuthorisedEmployee.
        /// d) Which health provider organisation (HPI-O) is making the calls to HI Service and PCEHR B2B Gateway.
        /// </summary>
        /// <value>
        /// A code identifying the hospital in which this patient received health care.
        /// </value>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 64)]
        public string HospitalCode { get; set; }

        /// <summary>
        /// Gets or sets the hospital code system.
        /// This is necessary because different systems may use different codes to identify the
        /// same hospital. For example, "NOA" or "NHS" for Noarlunga Health Service, where
        /// "NOA" is the LAB Facility Code and "NHS" is the PAS Facility Code.
        /// </summary>
        /// <value>
        /// A code identifying the system under which the hospital code was allocated.
        /// </value>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string HospitalCodeSystem { get; set; }

        #endregion Properties
    }
}