﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Provider Individual Identity DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class ProviderIndividualIdentity
    {
        /// <summary>
        /// Gets or sets the HPI-I or other identifier of the individual sending or receiving the message.
        /// </summary>
        [DataMember(IsRequired = true)]
        public ProviderIdentifier Identifier { get; set; }

        /// <summary>
        /// Gets or sets the name of the individual sending or receiving the message.
        /// </summary>
        [DataMember(IsRequired = true)]
        public IndividualName Name { get; set; }
    }
}
