﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{
    /// <summary>
    /// Abstract base class for all fault messages associated with service operations.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public abstract class FaultBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets a unique value that can be used to correlate the fault between the provider and the consumer.
        /// </summary>
        [DataMember]
        public virtual string FaultIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the description of the fault.
        /// </summary>
        [DataMember]
        public virtual string Message { get; set; }

        #endregion Properties
    }
}