﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{
    /// <summary>
    /// Represents an error returned by the PCEHR System.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class PcehrServiceFault : FaultBase
    {
        /// <summary>
        /// Gets or sets the PCEHR System response code.
        /// </summary>
        [DataMember]
        public string ResponseCode { get; set; }

        /// <summary>
        /// Gets or sets the PCEHR System response code description.
        /// </summary>
        [DataMember]
        public string ResponseCodeDescription { get; set; }

        /// <summary>
        /// Gets or sets the PCEHR System response code details.
        /// </summary>
        [DataMember]
        public string ResponseCodeDetails { get; set; }
    }
}