﻿using System.Collections.Generic;
using System.ServiceModel;

using HIPS.ServiceContracts.Common;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// Local Provider
    /// </summary>
    public class LocalProvider
    {
        /// <summary>
        /// An identifier provided by eHISC.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        public string LocalProviderCode { get; set; }

        /// <summary>
        /// Gets or sets the Family Name.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.NotNullValidator]
        public string FamilyName { get; set; }
        
        /// <summary>
        /// Gets or sets the Given Name.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the Title.
        /// </summary>
        [MessageBodyMember(Order = 5)]
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the Suffix.
        /// </summary>
        [MessageBodyMember(Order = 6)]
        public string Suffix { get; set; }

        /// <summary>
        /// Defines the activation state of the provider.
        /// </summary>
        [MessageBodyMember(Order = 7)]
        [EntLibVal.Validators.NotNullValidator]
        public bool Active { get; set; }

        /// <summary>
        /// The HPI-I of the local provider.
        /// </summary>
        [MessageBodyMember(Order = 8)]
        public string Hpii { get; set; }

        /// <summary>
        /// The current status of the providers HPI-I.
        /// </summary>
        [MessageBodyMember(Order = 9)]
        public HpiiStatus HpiiStatus { get; set; }

        /// <summary>
        /// A list of local provider identifiers.
        /// </summary>
        [MessageBodyMember(Order = 10)]
        public List<LocalProviderIdentifier> LocalProviderIdentifiers { get; set; }
    }
}
