﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// Local Provider Identifier.
    /// </summary>
    public class LocalProviderIdentifier
    {
        /// <summary>
        /// Gets or sets the Hospital Code.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 64)]
        public string HospitalCode { get; set; }
        
        /// <summary>
        /// Gets or sets the Hospital Code System.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string HospitalCodeSystem { get; set; }
        
        /// <summary>
        /// Gets or sets the Local Provider Code.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        [DataMember(IsRequired = true)]        
        [EntLibVal.Validators.StringLengthValidator(1, 256)]
        public string LocalProviderCode { get; set; }
        
        /// <summary>
        /// Gets or sets the Cis Provider Identifier.
        /// </summary>
        [MessageBodyMember(Order = 5)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.StringLengthValidator(1, 30)]
        public string CisProviderIdentifier { get; set; }
        
        /// <summary>
        /// Gets or sets the Pas Provider Identifier
        /// </summary>
        [MessageBodyMember(Order = 6)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.StringLengthValidator(1, 30)]
        public string PasProviderIdentifier { get; set; }
    }
}
