﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.Message
{
    /// <summary>
    /// Web service request message for the Add/Edit Local Provider operation.
    /// </summary>
    public class AddEditLocalProviderRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets Hospital Identifier.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        public HospitalIdentifier HospitalIdentifier { get; set; }
        
        /// <summary>
        /// Gets or sets Local Provider Code.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        public string LocalProviderCode { get; set; }

        /// <summary>
        /// Gets or sets Hpii.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets Title.
        /// </summary>
        [MessageBodyMember(Order = 5)]
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        [MessageBodyMember(Order = 6)]
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]        
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets Given Names.
        /// </summary>
        [MessageBodyMember(Order = 7)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets Suffix.
        /// </summary>
        [MessageBodyMember(Order = 8)]
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets Iam Provider Identifier.
        /// </summary>
        [MessageBodyMember(Order = 9)]
        public string IamProviderIdentifier { get; set; }
    }
}
