﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;
using HIPS.ServiceContracts.Hpii.DTO;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.Message
{
    /// <summary>
    /// Web service request message for the Add/Replace Local Provider Identifier operation.
    /// </summary>
    public class AddReplaceLocalProviderIdentifierRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets Local Provider Identifier.
        /// </summary>        
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        public LocalProviderIdentifier LocalProviderIdentifier { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the Local Provider Identifier will be replaced.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        public bool Replace { get; set; }
    }
}
