﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Pcehr.Message
{
    /// <summary>
    /// Web service request message for the Is PCEHR Advertised local operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PCEHR_V2)]
    public class IsPcehrAdvertisedLocalRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets an identifier of the patient and the current facility.
        /// (<see cref="Mrn">hospital MRN</see>,
        /// <see cref="StatePatientId">enterprise identifier</see>,
        /// <see cref="RegisteredEnterprisePatient">Registered Enterprise Patient</see>,
        /// <see cref="PatientMasterId">HIPS PatientMasterId</see> or
        /// <see cref="ValidatedIhi">Validated IHI</see>).
        /// </summary>
        [MessageBodyMember(Order = 1)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public PatientIdentifierBase PatientIdentifier { get; set; }
    }
}