﻿using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the HPI-I service.
    /// Contains methods for searching and validating of healthcare provider individuals using the Healthcare Identifier Service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "HpiiService")]
    public interface IHpiiService
    {
        /// <summary>
        /// Retrieves the results of a batch of HPI-I queries from the HI Service.
        /// </summary>
        /// <param name="hpiiBatchAsyncRetrieveRequest">The batch retrieval request.</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>Batch retrieval response</returns>
        [OperationContract]
        HpiiBatchAsyncRetrieveResponse HpiiBatchRetrieve(HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest, UserDetails user);

        /// <summary>
        /// Submits a batch of HPI-I queries to the HI Service.
        /// </summary>
        /// <param name="hpiiBatchAsyncSubmitRequest">The HPI-I batch asynchronous submit request.</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>Batch submission response</returns>
        [OperationContract]
        HpiiBatchAsyncSubmitResponse HpiiBatchSubmit(HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest, UserDetails user);

        /// <summary>
        /// Performs an HPII Demographic query against the HPII Service.
        /// </summary>
        /// <param name="hpiiDemographicQuery">The HPII demographic query.</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>Found HPII information</returns>
        [OperationContract]
        HpiiQueryResponse HpiiDemographicSearch(HpiiDemographicQuery hpiiDemographicQuery, UserDetails user);

        /// <summary>
        /// Performs an HPII Validation query against the HPII Service.
        /// </summary>
        /// <param name="hpiiIdentifierQuery">The HPII identifier query.</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>Validated HPII information</returns>
        [OperationContract]
        HpiiQueryResponse HpiiValidation(HpiiIdentifierQuery hpiiIdentifierQuery, UserDetails user);
    }
}