﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void ChangeHistoryButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            ChangeHistoryMessagesTextBox.Visible = false;
            ChangeHistoryMessagesTextBox.Text = "";
            var client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                ChangeHistoryViewResponse<PatientIdentifierBase> changeHistoryViewResponse;

                changeHistoryViewResponse = client.GetChangeHistoryView(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), ChangeHistoryDocumentUniqueIdTextBox.Text);
                ChangeHistoryGridView.DataSource = changeHistoryViewResponse.DocumentList;

                StringBuilder message = new StringBuilder();
                message.AppendLine("Status:" + changeHistoryViewResponse.HipsResponse.Status);

                if (changeHistoryViewResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + changeHistoryViewResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + changeHistoryViewResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + changeHistoryViewResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + changeHistoryViewResponse.HipsResponse.HipsErrorMessage);
                }
                ChangeHistoryMessagesTextBox.Text = message.ToString();
                ChangeHistoryMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, ChangeHistoryMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void ChangeHistoryPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            ChangeHistoryHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            ChangeHistoryMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            ChangeHistoryDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            ChangeHistoryHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            ChangeHistoryButton.Enabled = true;
        }
    }
}
