/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.HD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CX {
    private static final int CX_COMPONENT_COUNT = 5;
    private static final int ASSIGNING_AUTHORITY_INDEX = 3;
    private static final int IDENTIFIER_INDEX = 0;
    private static final int IDENTIFIER_TYPE_CODE_INDEX = 4;
    private final String identifier;
    private final HD assigningAuthority;
    private final String identifierTypeCode;

    private CX(Builder builder) {
        this.identifier = builder.identifier;
        this.assigningAuthority = builder.assigningAuthority;
        this.identifierTypeCode = builder.identifierTypeCode;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public HD getAssigningAuthority() {
        return this.assigningAuthority;
    }

    public String getIdentifierTypeCode() {
        return this.identifierTypeCode;
    }

    public static List<CX> parseMultiple(String value, String separator) {
        ArgumentUtils.checkNotNullNorBlank((String)value, (String)"value");
        ArgumentUtils.checkNotNullNorBlank((String)separator, (String)"separator");
        ArrayList<CX> cxs = new ArrayList<CX>();
        List<String> values = Arrays.asList(value.split(separator));
        for (String rawCx : values) {
            cxs.add(CX.parse(rawCx));
        }
        return cxs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier);
        sb.append("^");
        sb.append("^");
        sb.append("^");
        sb.append(this.assigningAuthority.toString());
        sb.append("^");
        sb.append(this.identifierTypeCode);
        return sb.toString().replaceAll(String.format("\\%s*$", "^"), "");
    }

    public static CX parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(parseValue.split("\\^")));
        while (values.size() < 5) {
            values.add("");
        }
        if (values.size() == 5) {
            return new Builder().identifier((String)values.get(0)).assigningAuthority(HD.parse((String)values.get(3))).identifierTypeCode((String)values.get(4)).build();
        }
        throw new IllegalArgumentException("Unable to parse CX - Invalid number of value components:\n\tActual: " + values.size() + "\n\tExpected: " + 5);
    }

    public static final class Builder {
        private String identifier = "";
        private HD assigningAuthority;
        private String identifierTypeCode = "";

        public Builder identifier(String value) {
            this.identifier = value;
            return this;
        }

        public Builder assigningAuthority(HD value) {
            this.assigningAuthority = value;
            return this;
        }

        public Builder identifierTypeCode(String value) {
            this.identifierTypeCode = value;
            return this;
        }

        public CX build() {
            return new CX(this);
        }
    }
}

