/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;

public enum DocumentTypeCodes {
    SHARED_HEALTH_SUMMARY("LOINC", "2.16.840.1.113883.6.1", "60591-5", "Patient Summary", "Shared Health Summary"),
    EREFERRAL("LOINC", "2.16.840.1.113883.6.1", "57133-1", "Referral Note", "e-Referral"),
    SPECIALIST_LETTER("LOINC", "2.16.840.1.113883.6.1", "51852-2", "Letter", "Specialist Letter"),
    DISCHARGE_SUMMARY("LOINC", "2.16.840.1.113883.6.1", "18842-5", "Discharge Summarization Note", "Discharge Summary"),
    EVENT_SUMMARY("LOINC", "2.16.840.1.113883.6.1", "34133-9", "Summarization of episode note", "Event Summary"),
    PHARMACEUTICAL_BENEFITS_REPORT("NCTIS", "1.2.36.1.2001.1001.101", "100.16650", "Pharmaceutical Benefits Report", "Pharmaceutical Benefits Report"),
    AUSTRALIAN_ORGAN_DONOR_REGISTER("NCTIS", "1.2.36.1.2001.1001.101", "100.16671", "Australian Organ Donor Register", "Australian Organ Donor Register"),
    AUSTRALIAN_CHILDHOOD_IMMUNISATION_REGISTER("NCTIS", "1.2.36.1.2001.1001.101", "100.16659", "Australian Childhood Immunisation Register", "Australian Childhood Immunisation Register"),
    MEDICARE_DVA_BENEFITS_REPORT("NCTIS", "1.2.36.1.2001.1001.101", "100.16644", "Medicare/DVA Benefits Report", "Medicare/DVA Benefits Report"),
    CONSUMER_ENTERED_NOTES("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16681", "Consumer Entered Notes Consumer", "Entered Notes"),
    CONSUMER_ENTERED_HEALTH_SUMMARY("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16685", "Consumer Entered Health Summary", "Consumer Entered Health Summary"),
    ADVANCED_CARE_DIRECTIVE_CUSTODIAN_RECORD("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16696", "Advanced Care Directive Custodian Record", "Advanced Care Directive Custodian Record"),
    PCEHR_PRESCRIPTION("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16764", "e-Prescription", "e-Prescription"),
    PCEHR_DISPENSE_RECORD("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16765", "Dispense Record", "Dispense Record");

    private String codingSystem;
    private String codingSystemOid;
    private String code;
    private String classCodeDisplayName;
    private String typeCodeDisplayName;

    private DocumentTypeCodes(String codingSystem, String codingSystemOid, String code, String classCodeDisplayName, String typeCodeDisplayName) {
        this.codingSystem = codingSystem;
        this.codingSystemOid = codingSystemOid;
        this.code = code;
        this.classCodeDisplayName = classCodeDisplayName;
        this.typeCodeDisplayName = typeCodeDisplayName;
    }

    public CodedValue getCodingSystem() {
        return new CodedValue(this.codingSystem, this.codingSystemOid, this.code, this.classCodeDisplayName);
    }

    private String getCode() {
        return this.code;
    }

    public static DocumentTypeCodes findByConceptCode(String conceptCode) {
        for (DocumentTypeCodes v : DocumentTypeCodes.values()) {
            if (!v.getCode().equals(conceptCode)) continue;
            return v;
        }
        return null;
    }

    public String getTypeCodeDisplayName() {
        return this.typeCodeDisplayName;
    }
}

