/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;

public final class FileUtils {
    private static final int BUFFER_SIZE = 16384;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file [" + file + "] does not exist.");
        }
        FileInputStream is = new FileInputStream(file);
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static <T> T loadXml(File file, Class<? extends T> clazz) throws JAXBException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file [" + file + "] does not exist.");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal(file);
    }

    public static byte[] getCdaDocument(byte[] packageContent) {
        Map<String, byte[]> files;
        try {
            files = FileUtils.extractZipEntries(packageContent);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read package content.", e);
        }
        for (Map.Entry<String, byte[]> file : files.entrySet()) {
            String filePath = file.getKey();
            Pattern pattern = Pattern.compile("[/\\\\]?[^/\\\\]+[/\\\\][^/\\\\]+[/\\\\]CDA_ROOT.XML", 2);
            if (!pattern.matcher(filePath).matches()) continue;
            return file.getValue();
        }
        throw new IllegalArgumentException("Failed to retrieve root document from package.");
    }

    private static byte[] readZipEntry(InputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        int count = zis.read(buffer);
        while (count != -1) {
            baos.write(buffer, 0, count);
            count = zis.read(buffer);
        }
        return baos.toByteArray();
    }

    public static Map<String, byte[]> extractZipEntries(byte[] packageContent) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(packageContent));
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                result.put(zipEntry.getName(), FileUtils.readZipEntry(zipInputStream));
            }
        }
        catch (IOException e) {
            throw new IOException("Unable to extract ZIP entries.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        return result;
    }
}

