/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.template;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import au.net.electronichealth.ns.tplt.svc.searchtemplate._1.SearchTemplatePortType;
import au.net.electronichealth.ns.tplt.svc.searchtemplate._1.SearchTemplateService;
import au.net.electronichealth.ns.tplt.svc.searchtemplate._1.StandardErrorMsg;
import au.net.electronichealth.ns.tplt.xsd.common.templatescoreelements._1.TemplateMetadataType;
import au.net.electronichealth.ns.tplt.xsd.interfaces.searchtemplate._1.SearchTemplate;
import au.net.electronichealth.ns.tplt.xsd.interfaces.searchtemplate._1.SearchTemplateResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public final class SearchTemplateClient
extends Client<SearchTemplatePortType> {
    public SearchTemplateClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(SearchTemplateService.class, SearchTemplatePortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public SearchTemplateClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(SearchTemplateService.class, SearchTemplatePortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public SearchTemplateResponse searchTemplate(PCEHRHeader commonHeader, String templateId, TemplateMetadataType templateMetadata) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        CommonHeaderValidator.validate(commonHeader, false);
        Holder responseHolder = new Holder();
        Holder signatureHolder = null;
        SearchTemplate params = new SearchTemplate();
        params.setTemplateID(templateId);
        params.setTemplateMetadata(templateMetadata);
        ((SearchTemplatePortType)this.getPort()).searchTemplate(params, responseHolder, DateUtils.generateTimestamp(), signatureHolder, commonHeader);
        return (SearchTemplateResponse)responseHolder.value;
    }
}

