/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.common.DOMUtil;
import au.gov.nehta.xsp.CertificateVerificationException;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.SignedContainerProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public final class SignedContainerProfileUtil {
    public static final CertificateVerifier NULL_CERTIFICATE_VERIFIER = new CertificateVerifier(){

        public void verify(X509Certificate certificate) throws CertificateVerificationException, XspException {
        }
    };
    private static final Logger LOG = Logger.getLogger(SignedContainerProfileUtil.class.getName());

    private SignedContainerProfileUtil() {
    }

    public static Document getSignedPayload(String sensitivePayload, X509Certificate siginingCert, PrivateKey siginingPrivateKey) throws XspException {
        ArgumentUtils.checkNotNullNorBlank((String)sensitivePayload, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull((Object)siginingCert, (String)"siginingCert");
        ArgumentUtils.checkNotNull((Object)siginingPrivateKey, (String)"siginingPrivateKey");
        ArrayList<X500PrivateCredential> certificateKeyPairs = new ArrayList<X500PrivateCredential>();
        certificateKeyPairs.add(new X500PrivateCredential(siginingCert, siginingPrivateKey));
        return SignedContainerProfileUtil.getSignedPayload(sensitivePayload, certificateKeyPairs);
    }

    public static Document getSignedPayload(String sensitivePayload, List<X500PrivateCredential> certificateKeyPairs) throws XspException {
        try {
            ArgumentUtils.checkNotNullNorBlank((String)sensitivePayload, (String)"sensitivePayload");
            ArgumentUtils.checkNotNull(certificateKeyPairs, (String)"certificateKeyPairs");
            if (certificateKeyPairs.size() > 0) {
                Document signedDocument = null;
                Document docToSign = DOMUtil.getDocumentFromXML(sensitivePayload);
                signedDocument = SignedContainerProfileUtil.getSignedContainerProfileService().create(docToSign, certificateKeyPairs);
                return signedDocument;
            }
        }
        catch (XspException e) {
            throw new XspException("Failed to sign the document.");
        }
        throw new XspException("Failed to sign the document.");
    }

    public static List<byte[]> getDigestValue(Document containerDoc) throws XspException {
        return SignedContainerProfileUtil.getSignedContainerProfileService().getDigestValues(containerDoc);
    }

    public static List<X509Certificate> getSigningCertificates(Document containerDoc) throws XspException {
        return SignedContainerProfileUtil.getSignedContainerProfileService().getSigningCertificates(containerDoc);
    }

    public static Document getDataFromSignedPayload(Document signedDocument) throws XspException {
        ArgumentUtils.checkNotNull((Object)signedDocument, (String)"signedDocument");
        Document sensitivePayload = null;
        try {
            sensitivePayload = SignedContainerProfileUtil.getSignedContainerProfileService().getData(signedDocument);
            ArgumentUtils.checkNotNull((Object)sensitivePayload, (String)"extractedDocument");
            return sensitivePayload;
        }
        catch (IllegalArgumentException ex) {
            throw new XspException((Throwable)ex);
        }
        catch (XspException xspException) {
            return sensitivePayload;
        }
    }

    public static boolean verifySignature(Document signedDocument, CertificateVerifier certificateVerifier) throws SignatureValidationException {
        boolean signatureVerified = false;
        ArgumentUtils.checkNotNull((Object)signedDocument, (String)"signedDocument");
        Object sensitivePayload = null;
        try {
            SignedContainerProfileUtil.getSignedContainerProfileService().check(signedDocument, certificateVerifier);
            signatureVerified = true;
        }
        catch (XspException e) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)e);
        }
        catch (CertificateVerificationException e) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)e);
        }
        return signatureVerified;
    }

    public static boolean verifySignature(Document signedDocument) throws SignatureValidationException {
        return SignedContainerProfileUtil.verifySignature(signedDocument, NULL_CERTIFICATE_VERIFIER);
    }

    private static SignedContainerProfileService getSignedContainerProfileService() throws XspException {
        return XspFactory.getInstance().getSignedContainerProfileService(XspVersion.V_2010);
    }
}

