/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.IOException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class XsdUtils {
    public static void validate(Node dataNode, Node schemaNode) throws SAXException, IOException {
        XsdUtils.validate(dataNode, schemaNode, null);
    }

    public static void validate(Node dataNode, Node schemaNode, LSResourceResolver xsdResourceResolver) throws SAXException, IOException {
        ArgumentUtils.checkNotNull(dataNode, "dataNode");
        ArgumentUtils.checkNotNull(schemaNode, "schemaNode");
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (xsdResourceResolver != null) {
            schemaFactory.setResourceResolver(xsdResourceResolver);
        }
        DOMSource xsdSource = new DOMSource(schemaNode);
        Schema schema = schemaFactory.newSchema(xsdSource);
        Validator validator = schema.newValidator();
        DOMSource dataSource = new DOMSource(dataNode);
        validator.validate(dataSource);
    }

    private XsdUtils() {
    }
}

