/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.handler;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.MTOMException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.HandlerUtils;
import java.io.InputStream;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.NodeList;

public class MTOMHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String DOCUMENT_ELEM = "Document";
    public static final String UPLOAD_REQUEST_ELEM = "ProvideAndRegisterDocumentSetRequest";
    public static final String INCLUDE_ELEM = "Include";
    public static final String XOP_INCLUDE = "cid:%s";
    private static final String CONTENT_ID_ATTR = "href";
    private static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";

    public final boolean handleMessage(SOAPMessageContext context) {
        if (HandlerUtils.isOutgoing(context).booleanValue() && HandlerUtils.isResponseType(context, XMLNamespaces.IHE.getNamespace(), UPLOAD_REQUEST_ELEM)) {
            try {
                SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
                SOAPBody body = envelope.getBody();
                UUID referenceId = UUID.randomUUID();
                String documentContent = HandlerUtils.extractElementContent(body, XMLNamespaces.IHE.getNamespace(), DOCUMENT_ELEM);
                InputStream is = IOUtils.toInputStream((String)documentContent);
                this.createDocumentAttachmentPart(context, is, referenceId);
                this.replaceDocumentContent(body, referenceId);
            }
            catch (SOAPException e) {
                throw new MTOMException("Unable to extract SOAP components", (Exception)((Object)e));
            }
        }
        return true;
    }

    private void replaceDocumentContent(SOAPBody body, UUID referenceId) {
        NodeList nodeList = body.getElementsByTagNameNS(XMLNamespaces.IHE.getNamespace(), DOCUMENT_ELEM);
        SOAPBodyElement documentElement = (SOAPBodyElement)HandlerUtils.getFirstElementFromNodeList(nodeList);
        documentElement.removeContents();
        try {
            documentElement.addChildElement(INCLUDE_ELEM, XMLNamespaces.XOP.getPrefix(), XMLNamespaces.XOP.getNamespace()).setAttribute(CONTENT_ID_ATTR, String.format(XOP_INCLUDE, referenceId.toString()));
        }
        catch (SOAPException e) {
            throw new MTOMException("Failed to add the new XOP include element to the SOAP body.", (Exception)((Object)e));
        }
    }

    private void createDocumentAttachmentPart(SOAPMessageContext context, InputStream is, UUID referenceId) {
        AttachmentPart attachment = context.getMessage().createAttachmentPart();
        try {
            attachment.setBase64Content(is, OCTET_STREAM_CONTENT_TYPE);
        }
        catch (SOAPException e) {
            throw new MTOMException("Failed to create a new attachment part", (Exception)((Object)e));
        }
        attachment.setContentId(referenceId.toString());
        context.getMessage().addAttachmentPart(attachment);
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public final Set<QName> getHeaders() {
        return null;
    }
}

