/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.documentexchange;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRepositoryPortType;
import ihe.iti.xds_b._2007.DocumentRepositoryService;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequest;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public final class GetDocumentClient
extends Client<DocumentRepositoryPortType> {
    public GetDocumentClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
        this.setMTOMEnabled();
    }

    public GetDocumentClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
        this.setMTOMEnabled();
    }

    public RetrieveDocumentSetResponse retrieveDocument(PCEHRHeader commonHeader, RetrieveDocumentSetRequest.DocumentRequest docRequest) {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)docRequest, (String)"'docRequest' must be specified.");
        Validate.notEmpty((String)docRequest.getDocumentUniqueId(), (String)"'docRequest.documentUniqueId' must be specified.");
        Validate.notEmpty((String)docRequest.getRepositoryUniqueId(), (String)"'docRequest.getRepositoryUniqueId' must be specified.");
        CommonHeaderValidator.validate(commonHeader, true);
        RetrieveDocumentSetRequest request = new RetrieveDocumentSetRequest();
        request.getDocumentRequests().add(docRequest);
        Holder signatureHolder = null;
        return ((DocumentRepositoryPortType)this.getPort()).documentRepositoryRetrieveDocumentSet(DateUtils.generateTimestamp(), signatureHolder, commonHeader, request);
    }
}

