/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.documentexchange;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.ConfidentialityCodes;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.SubmissionMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.FileUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.MetadataUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSMapper;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRegistryPortType;
import ihe.iti.xds_b._2007.DocumentRegistryService;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Holder;
import javax.xml.xpath.XPathExpressionException;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.lang.Validate;
import org.xml.sax.SAXException;

public final class UploadDocumentMetadataClient
extends Client<DocumentRegistryPortType> {
    public UploadDocumentMetadataClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRegistryService.class, DocumentRegistryPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public UploadDocumentMetadataClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRegistryService.class, DocumentRegistryPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public RegistryResponseType uploadDocumentMetadata(PCEHRHeader commonHeader, byte[] packageContent, String repositoryUniqueId, CodedValue healthcareFacilityTypeCode, CodedValue practiceSettingTypeCode, CodedValue formatCode) throws IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        Validate.notNull((Object)packageContent);
        Validate.notNull((Object)healthcareFacilityTypeCode);
        Validate.notNull((Object)practiceSettingTypeCode);
        byte[] document = FileUtils.getCdaDocument(packageContent);
        DocumentMetadata documentMetadata = MetadataUtils.toDocumentMetadata(commonHeader, document);
        documentMetadata.setHealthcareFacilityType(healthcareFacilityTypeCode);
        documentMetadata.setPracticeSetting(practiceSettingTypeCode);
        documentMetadata.setConfidentialityCode(ConfidentialityCodes.NA);
        documentMetadata.setEntryUuid("DOCUMENT_SYMBOLICID_01");
        documentMetadata.setRepositoryUniqueId(repositoryUniqueId);
        documentMetadata.setFormatCode(formatCode);
        documentMetadata.setDocumentHash(MetadataUtils.calculateSha1Hash(packageContent));
        documentMetadata.setDocumentSize(new BigInteger(String.valueOf(packageContent.length)));
        SubmissionMetadata submissionMetadata = new SubmissionMetadata();
        submissionMetadata.setSubmissionTime(new Date());
        submissionMetadata.setEntryUuid("SUBSET_SYMBOLICID_01");
        SubmitObjectsRequest request = XDSMapper.toSubmitObjectsRequest(commonHeader, submissionMetadata, documentMetadata, null);
        Holder signatureHolder = null;
        return ((DocumentRegistryPortType)this.getPort()).documentRegistryRegisterDocumentSetB(DateUtils.generateTimestamp(), signatureHolder, commonHeader, request);
    }
}

