/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.view;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentQueryParams;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentStatus;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSMapper;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRegistryPortType;
import ihe.iti.xds_b._2007.DocumentRegistryService;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import org.apache.commons.lang.Validate;

public final class GetDocumentListClient
extends Client<DocumentRegistryPortType> {
    public GetDocumentListClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRegistryService.class, DocumentRegistryPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public GetDocumentListClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRegistryService.class, DocumentRegistryPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public AdhocQueryResponse getDocumentList(PCEHRHeader commonHeader) {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        CommonHeaderValidator.validate(commonHeader, true);
        DocumentQueryParams queryParams = new DocumentQueryParams();
        queryParams.getStatuses().add(DocumentStatus.APPROVED);
        AdhocQueryRequest request = XDSMapper.toAdhocQueryRequest(commonHeader, "urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d", queryParams);
        Holder signatureHolder = null;
        return ((DocumentRegistryPortType)this.getPort()).documentRegistryRegistryStoredQuery(DateUtils.generateTimestamp(), signatureHolder, commonHeader, request);
    }

    public AdhocQueryResponse getDocumentList(PCEHRHeader commonHeader, DocumentQueryParams queryParams) {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)queryParams, (String)"'queryParams' must be specified");
        CommonHeaderValidator.validate(commonHeader, true);
        AdhocQueryRequest request = XDSMapper.toAdhocQueryRequest(commonHeader, "urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d", queryParams);
        Holder signatureHolder = null;
        return ((DocumentRegistryPortType)this.getPort()).documentRegistryRegistryStoredQuery(DateUtils.generateTimestamp(), signatureHolder, commonHeader, request);
    }
}

