/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public final class IOUtils {
    private static final int CHAR_BUFFER_SIZE = 1024;

    public static String read(File inputFile) throws IOException {
        ArgumentUtils.checkNotNull(inputFile, "inputFile");
        return IOUtils.read(new FileReader(inputFile));
    }

    public static String read(InputStream input) throws IOException {
        ArgumentUtils.checkNotNull(input, "input");
        return IOUtils.read(new InputStreamReader(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader) throws IOException {
        ArgumentUtils.checkNotNull(reader, "reader");
        try {
            StringWriter sw = new StringWriter();
            char[] buffer = new char[1024];
            int readIdx = reader.read(buffer, 0, buffer.length);
            while (readIdx >= 0) {
                sw.write(buffer, 0, readIdx);
                readIdx = reader.read(buffer, 0, buffer.length);
            }
            sw.flush();
            String string = sw.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void write(File outputFile, String contents) throws IOException {
        ArgumentUtils.checkNotNull(outputFile, "outputFile");
        ArgumentUtils.checkNotNullNorBlank(contents, "contents");
        IOUtils.write(new FileWriter(outputFile), contents);
    }

    public static void write(OutputStream output, String contents) throws IOException {
        ArgumentUtils.checkNotNull(output, "output");
        ArgumentUtils.checkNotNullNorBlank(contents, "contents");
        IOUtils.write(new OutputStreamWriter(output), contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Writer writer, String contents) throws IOException {
        ArgumentUtils.checkNotNull(writer, "writer");
        ArgumentUtils.checkNotNullNorBlank(contents, "contents");
        try {
            BufferedWriter bw = new BufferedWriter(writer);
            bw.append(contents);
            bw.flush();
        }
        finally {
            writer.close();
        }
    }

    private IOUtils() {
    }
}

