/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.handler;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.CertificateVerificationException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.SignatureValidationException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.SignatureVerificationException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.HandlerUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String TIMESTAMP = "timestamp";
    public static final String SIGNATURE_ELEM = "signature";
    public static final String GET_DOCUMENT_ELEM = "RetrieveDocumentSetResponse";
    public static final String DSIG_ELEM = "Signature";
    public static final String PCEHRH_HEADER_ELEM = "PCEHRHeader";
    private static final int DIGEST_VALUE_COUNT = 1;
    private static final String TS_PREFIX = "t_";
    private static final String BODY_PREFIX = "b_";
    private static final String HEADER_PREFIX = "h_";
    private static final String ID_ATTR = "xml:id";
    private final X509Certificate x509Certificate;
    private final PrivateKey privateKey;
    private final CertificateVerifier certificateVerifier;

    public SecurityHandler(X509Certificate x509Certificate, PrivateKey privateKey, CertificateVerifier certificateVerifier) {
        Validate.notNull((Object)x509Certificate, (String)"'x509Certificate' cannot be null.");
        Validate.notNull((Object)certificateVerifier, (String)"'certificateVerifier' cannot be null. Consider an empty implementation if verification is not required.");
        Validate.notNull((Object)privateKey, (String)"'privateKey' cannot be null.");
        this.x509Certificate = x509Certificate;
        this.privateKey = privateKey;
        this.certificateVerifier = certificateVerifier;
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        if (HandlerUtils.isOutgoing(context).booleanValue()) {
            this.signBodyAndSOAPHeaders(context);
        } else {
            try {
                this.checkResponse(context);
            }
            catch (CertificateVerificationException e) {
                throw new SignatureVerificationException("Certificate verification failed", e);
            }
        }
        return true;
    }

    private void checkResponse(SOAPMessageContext context) {
        Element sigElement = this.validateSignature(context);
        XmlSignatureProfileService xmlSignatureProfileService = null;
        try {
            xmlSignatureProfileService = XspFactory.getInstance().getXmlSignatureProfileService(XspVersion.V_2010);
        }
        catch (XspException e) {
            throw new SignatureValidationException("Unable to validate signature", (Exception)((Object)e));
        }
        try {
            xmlSignatureProfileService.check(sigElement, this.certificateVerifier);
        }
        catch (au.gov.nehta.xsp.SignatureValidationException e) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)e));
        }
        catch (au.gov.nehta.xsp.CertificateVerificationException e) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)e));
        }
        catch (XspException e) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)e));
        }
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext context) {
    }

    private void signBodyAndSOAPHeaders(SOAPMessageContext context) {
        Validate.notNull((Object)context, (String)"SOAPMessageContext cannot be null");
        try {
            SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
            SOAPHeader header = envelope.getHeader();
            SOAPBody body = envelope.getBody();
            this.extractAndSignSoapElements(header, (Element)body);
        }
        catch (SOAPException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (XspException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void extractAndSignSoapElements(SOAPHeader header, Element bodyElement) throws XspException {
        Validate.notNull((Object)header, (String)"Outgoing message SOAP header cannot be null.");
        Validate.notNull((Object)bodyElement, (String)"Outgoing message SOAP body cannot be null.");
        NodeList timestampNodeList = header.getElementsByTagNameNS(XMLNamespaces.COMMON.getNamespace(), TIMESTAMP);
        NodeList sigNodeList = header.getElementsByTagNameNS(XMLNamespaces.COMMON.getNamespace(), SIGNATURE_ELEM);
        NodeList headerNodeList = header.getElementsByTagNameNS(XMLNamespaces.COMMON.getNamespace(), PCEHRH_HEADER_ELEM);
        Element timestampElement = HandlerUtils.getFirstElementFromNodeList(timestampNodeList);
        Element sigElement = HandlerUtils.getFirstElementFromNodeList(sigNodeList);
        Element headerElement = HandlerUtils.getFirstElementFromNodeList(headerNodeList);
        this.addSignatureReferenceId(bodyElement, timestampElement, headerElement);
        this.signSoapElements(timestampElement, headerElement, bodyElement, sigElement);
    }

    private void signSoapElements(Element timestampElement, Element headerElement, Element bodyElement, Element sigElement) throws XspException {
        List<Element> elementsToSign = Arrays.asList(timestampElement, headerElement, bodyElement);
        List<X500PrivateCredential> certificateKeyPairs = Arrays.asList(new X500PrivateCredential(this.x509Certificate, this.privateKey));
        XmlSignatureProfileService xmlSignatureProfileService = XspFactory.getInstance().getXmlSignatureProfileService(XspVersion.V_2010);
        xmlSignatureProfileService.sign(sigElement, elementsToSign, certificateKeyPairs);
    }

    private Element validateSignature(SOAPMessageContext context) {
        Validate.notNull((Object)context, (String)"'context' cannot be null.");
        SOAPHeader header = null;
        try {
            header = context.getMessage().getSOAPHeader();
        }
        catch (SOAPException e) {
            throw new SignatureValidationException("Unable to extract SOAP header.", (Exception)((Object)e));
        }
        if (header == null) {
            throw new SignatureValidationException("Unable to extract SOAP header.");
        }
        NodeList sigNodeList = header.getElementsByTagNameNS(XMLNamespaces.DS.getNamespace(), DSIG_ELEM);
        Element sigElement = HandlerUtils.getFirstElementFromNodeList(sigNodeList);
        if (sigElement == null) {
            throw new CertificateVerificationException("Unable to extract signature fragment.");
        }
        return sigElement;
    }

    private void addSignatureReferenceId(Element bodyElement, Element timestampElement, Element headerElement) {
        Validate.notNull((Object)bodyElement, (String)"'bodyElement' cannot be null.");
        ArgumentUtils.checkNotNull((Object)timestampElement, (String)"'timestampElement' cannot be null.");
        ArgumentUtils.checkNotNull((Object)headerElement, (String)"'headerElement' cannot be null.");
        headerElement.setAttribute(ID_ATTR, HEADER_PREFIX + UUID.randomUUID().toString());
        bodyElement.setAttribute(ID_ATTR, BODY_PREFIX + UUID.randomUUID().toString());
        timestampElement.setAttribute(ID_ATTR, TS_PREFIX + UUID.randomUUID().toString());
    }
}

