/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;

public enum HealthcareFacilityTypeCodes {
    AGED_CARE_RESIDENTIAL_SERVICES("ANZSIC", "8601", "Aged Care Residential Services"),
    AMBULANCE_SERVICES("ANZSIC", "8591", "Ambulance Services"),
    CALL_CENTRE_OPERATION("ANZSIC", "7294", "Call Centre Operation"),
    CENTRAL_GOVERNMENT_HEALTHCARE_ADMINISTRATION("ANZSIC", "7511", "Central Government Healthcare Administration"),
    CHILD_CARE_SERVICES("ANZSIC", "8710", "Child Care Services"),
    CHIROPRACTIC_AND_OSTEOPATHIC_SERVICES("ANZSIC", "8534", "Chiropractic and Osteopathic Services"),
    COMPUTER_SYSTEM_DESIGN_AND_RELATED_SERVICES("ANZSIC", "7000", "Computer System Design and Related Services"),
    CORPORATE_HEAD_OFFICE_MANAGEMENT_SERVICES("ANZSIC", "6961", "Corporate Head Office Management Services"),
    DATA_PROCESSING_AND_WEB_HOSTING_SERVICES("ANZSIC", "5921", "Data Processing and Web Hosting Services"),
    DENTAL_SERVICES("ANZSIC", "8531", "Dental Services"),
    ELECTRONIC_INFORMATION_STORAGE_SERVICES("ANZSIC", "5922", "Electronic Information Storage Services"),
    GENERAL_HEALTH_ADMINISTRATION("ANZSIC", "7561", "General Health Administration"),
    GENERAL_PRACTICE("ANZSIC", "8511", "General Practice"),
    HEALTH_AND_FITNESS_CENTRES_AND_GYMNASIA_OPERATION("ANZSIC", "9111", "Health and Fitness Centres and Gymnasia Operation"),
    HEALTH_INSURANCE("ANZSIC", "6321", "Health Insurance"),
    HIGHER_EDUCATION("ANZSIC", "8102", "Higher Education"),
    HOSPITALS("ANZSIC", "8401", "Hospitals (except Psychiatric Hospitals)"),
    INTERNET_SERVICE_PROVIDERS_AND_WEB_SEARCH_PORTALS("ANZSIC", "5910", "Internet Service Providers and Web Search Portals"),
    LOCAL_GOVERNMENT_HEALTHCARE_ADMINISTRATION("ANZSIC", "7531", "Local Government Healthcare Administration"),
    MENTAL_HEALTH_HOSPITALS("ANZSIC", "8402", "Mental Health Hospitals"),
    OFFICE_ADMINISTRATIVE_SERVICES("ANZSIC", "7291", "Office Administrative Services"),
    OPTOMETRY_AND_OPTICAL_DISPENSING("ANZSIC", "8532", "Optometry and Optical Dispensing"),
    OTHER_ALLIED_HEALTH_SERVICES("ANZSIC", "8539", "Other Allied Health Services"),
    OTHER_HEALTHCARE_SERVICES_NEC("ANZSIC", "8599", "Other Healthcare Services nec"),
    OTHER_PROFESSIONAL_SCIENTIFIC_AND_TECHNICAL_SERVICES_NEC("ANZSIC", "6999", "Other Professional, Scientific and Technical Services n.e.c."),
    OTHER_RESIDENTIAL_CARE_SERVICES("ANZSIC", "8609", "Other Residential Care Services"),
    OTHER_SOCIAL_ASSISTANCE_SERVICES("ANZSIC", "8790", "Other Social Assistance Services"),
    PATHOLOGY_AND_DIAGNOSTIC_IMAGING_SERVICES("ANZSIC", "8520", "Pathology and Diagnostic Imaging Services"),
    PHYSIOTHERAPY_SERVICES("ANZSIC", "8533", "Physiotherapy Services"),
    PROVISION_AND_ADMINISTRATION_OF_PUBLIC_HEALTH_PROGRAM("ANZSIC", "7562", "Provision and administration of public health program"),
    RETAIL_PHARMACY("ANZSIC", "4271", "Retail Pharmacy"),
    SCIENTIFIC_RESEARCH_SERVICES("ANZSIC", "6910", "Scientific Research Services"),
    SPECIALIST_MEDICAL_SERVICES("ANZSIC", "8512", "Specialist Medical Services"),
    STATE_GOVERNMENT_HEALTHCARE_ADMINISTRATION("ANZSIC", "7521", "State Government Healthcare Administration"),
    TRANSPORT("ANZSIC", "4623", "Transport");

    private String codingSystem;
    private String conceptCode;
    private String conceptName;

    private HealthcareFacilityTypeCodes(String codingSystem, String conceptCode, String conceptName) {
        this.codingSystem = codingSystem;
        this.conceptCode = conceptCode;
        this.conceptName = conceptName;
    }

    public CodedValue getCodedValue() {
        return new CodedValue(this.codingSystem, this.conceptCode, this.conceptName);
    }

    private String getConceptCode() {
        return this.conceptCode;
    }

    public static HealthcareFacilityTypeCodes findByConceptCode(String conceptCode) {
        for (HealthcareFacilityTypeCodes v : HealthcareFacilityTypeCodes.values()) {
            if (!v.getConceptCode().equals(conceptCode)) continue;
            return v;
        }
        return null;
    }
}

