/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.documentexchange;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.svc.removedocument._1.RemoveDocumentPortType;
import au.net.electronichealth.ns.pcehr.svc.removedocument._1.RemoveDocumentService;
import au.net.electronichealth.ns.pcehr.svc.removedocument._1.StandardErrorMsg;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.removedocument._1.RemoveDocument;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.removedocument._1.RemoveDocumentResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public final class RemoveDocumentClient
extends Client<RemoveDocumentPortType> {
    public RemoveDocumentClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(RemoveDocumentService.class, RemoveDocumentPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public RemoveDocumentClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(RemoveDocumentService.class, RemoveDocumentPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public RemoveDocumentResponse removeDocument(PCEHRHeader commonHeader, String documentId, RemoveDocument.DocumentRemovalReason removalReason) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notEmpty((String)documentId, (String)"'documentId' must be specified.");
        Validate.notNull((Object)removalReason, (String)"'removalReason' must be specified.");
        CommonHeaderValidator.validate(commonHeader, true);
        RemoveDocument removeDocument = new RemoveDocument();
        removeDocument.setDocumentID(documentId);
        removeDocument.setReasonForRemoval(removalReason);
        Holder removeDocumentResponseHolder = new Holder();
        Holder signatureHolder = null;
        ((RemoveDocumentPortType)this.getPort()).removeDocument(removeDocument, removeDocumentResponseHolder, DateUtils.generateTimestamp(), signatureHolder, commonHeader);
        return (RemoveDocumentResponse)removeDocumentResponseHolder.value;
    }
}

