/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.documentexchange;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.ConfigurableMTOMHandler;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.ConfidentialityCodes;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.SubmissionMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.FileUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.MetadataUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSMapper;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRepositoryPortType;
import ihe.iti.xds_b._2007.DocumentRepositoryService;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequest;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Holder;
import javax.xml.xpath.XPathExpressionException;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.lang.Validate;
import org.xml.sax.SAXException;

public final class UploadDocumentClient
extends Client<DocumentRepositoryPortType> {
    public UploadDocumentClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled, new ConfigurableMTOMHandler("ProvideAndRegisterDocumentSetRequest", XMLNamespaces.IHE.getNamespace(), "Document"));
    }

    public UploadDocumentClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled, new ConfigurableMTOMHandler("ProvideAndRegisterDocumentSetRequest", XMLNamespaces.IHE.getNamespace(), "Document"));
    }

    public RegistryResponseType uploadDocument(PCEHRHeader commonHeader, byte[] packageContent, CodedValue healthcareFacilityType, CodedValue practiceSettingTypeCode, CodedValue formatCode) throws IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        return this.uploadDocument(commonHeader, packageContent, null, healthcareFacilityType, practiceSettingTypeCode, formatCode);
    }

    public RegistryResponseType uploadDocument(PCEHRHeader commonHeader, byte[] packageContent, String replacementId, CodedValue healthcareFacilityType, CodedValue practiceSettingTypeCode, CodedValue formatCode) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        return this.uploadDocument(commonHeader, packageContent, replacementId, null, healthcareFacilityType, practiceSettingTypeCode, formatCode);
    }

    public RegistryResponseType uploadDocument(PCEHRHeader commonHeader, byte[] packageContent, String replacementId, String repositoryUniqueId, CodedValue healthcareFacilityType, CodedValue practiceSettingTypeCode, CodedValue formatCode) throws IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        Validate.notNull((Object)packageContent, (String)"'packageContent' must be specified");
        Validate.notNull((Object)healthcareFacilityType, (String)"'healthcareFacilityType' must be specified");
        Validate.notNull((Object)practiceSettingTypeCode, (String)"'practiceSettingTypeCode' must be specified");
        Validate.notNull((Object)formatCode, (String)"'formatCode' must be specified");
        byte[] document = FileUtils.getCdaDocument(packageContent);
        DocumentMetadata documentMetadata = MetadataUtils.toDocumentMetadata(commonHeader, document);
        documentMetadata.setHealthcareFacilityType(healthcareFacilityType);
        documentMetadata.setPracticeSetting(practiceSettingTypeCode);
        documentMetadata.setConfidentialityCode(ConfidentialityCodes.NA);
        documentMetadata.setEntryUuid("DOCUMENT_SYMBOLICID_01");
        documentMetadata.setFormatCode(formatCode);
        if (repositoryUniqueId != null) {
            documentMetadata.setRepositoryUniqueId(repositoryUniqueId);
            documentMetadata.setDocumentHash(MetadataUtils.calculateSha1Hash(packageContent));
            documentMetadata.setDocumentSize(new BigInteger(String.valueOf(packageContent.length)));
        }
        SubmissionMetadata submissionMetadata = new SubmissionMetadata();
        submissionMetadata.setSubmissionTime(new Date());
        submissionMetadata.setEntryUuid("SUBSET_SYMBOLICID_01");
        SubmitObjectsRequest request = XDSMapper.toSubmitObjectsRequest(commonHeader, submissionMetadata, documentMetadata, replacementId);
        ProvideAndRegisterDocumentSetRequest.Document iheDocument = new ProvideAndRegisterDocumentSetRequest.Document();
        iheDocument.setId(documentMetadata.getEntryUuid());
        iheDocument.setValue(packageContent);
        ProvideAndRegisterDocumentSetRequest body = new ProvideAndRegisterDocumentSetRequest();
        body.setSubmitObjectsRequest(request);
        body.getDocuments().add(iheDocument);
        Holder signatureHolder = null;
        return ((DocumentRepositoryPortType)this.getPort()).documentRepositoryProvideAndRegisterDocumentSetB(DateUtils.generateTimestamp(), signatureHolder, commonHeader, body);
    }
}

