/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.recordaccess;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.b2b.svc.pcehrprofile._1.PCEHRProfilePortType;
import au.net.electronichealth.ns.pcehr.b2b.svc.pcehrprofile._1.PCEHRProfileService;
import au.net.electronichealth.ns.pcehr.b2b.svc.pcehrprofile._1.StandardErrorMsg;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.ResponseStatusType;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.pcehrprofile._1.GainPCEHRAccess;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.pcehrprofile._1.GainPCEHRAccessResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public class GainPCEHRAccessClient
extends Client<PCEHRProfilePortType> {
    public GainPCEHRAccessClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(PCEHRProfileService.class, PCEHRProfilePortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public GainPCEHRAccessClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(PCEHRProfileService.class, PCEHRProfilePortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public final GainPCEHRAccessResponse gainPCEHRAccess(GainPCEHRAccess.PCEHRRecord pcehrRecord, PCEHRHeader commonHeader) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)pcehrRecord);
        CommonHeaderValidator.validate(commonHeader, true);
        if (pcehrRecord.getAuthorisationDetails() != null && pcehrRecord.getAuthorisationDetails().getAccessType() == GainPCEHRAccess.PCEHRRecord.AuthorisationDetails.AccessType.ACCESS_CODE) {
            Validate.notEmpty((String)pcehrRecord.getAuthorisationDetails().getAccessCode(), (String)"'pcehrRecord.authorisationDetails.accessCode' must be specified.");
        }
        GainPCEHRAccessResponse response = new GainPCEHRAccessResponse();
        Holder responseHolder = new Holder();
        Holder individualHolder = new Holder();
        Holder signatureHolder = null;
        ((PCEHRProfilePortType)this.getPort()).gainPCEHRAccess(pcehrRecord, responseHolder, individualHolder, DateUtils.generateTimestamp(), signatureHolder, commonHeader);
        response.setIndividual((GainPCEHRAccessResponse.Individual)individualHolder.value);
        response.setResponseStatus((ResponseStatusType)responseHolder.value);
        return response;
    }
}

