/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.view;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateVerifier;
import au.net.electronichealth.ns.pcehr.svc.getauditview._1.GetAuditViewPortType;
import au.net.electronichealth.ns.pcehr.svc.getauditview._1.GetAuditViewService;
import au.net.electronichealth.ns.pcehr.svc.getauditview._1.StandardErrorMsg;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.getauditview._1.GetAuditView;
import au.net.electronichealth.ns.pcehr.xsd.interfaces.getauditview._1.GetAuditViewResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public final class GetAuditViewClient
extends Client<GetAuditViewPortType> {
    public GetAuditViewClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(GetAuditViewService.class, GetAuditViewPortType.class, sslSocketFactory, x509Certificate, privateKey, endpointAddress, setLoggingEnabled);
    }

    public GetAuditViewClient(SSLSocketFactory sslSocketFactory, X509Certificate x509Certificate, CertificateVerifier certificateVerifier, PrivateKey privateKey, String endpointAddress, boolean setLoggingEnabled) {
        super(GetAuditViewService.class, GetAuditViewPortType.class, sslSocketFactory, x509Certificate, certificateVerifier, privateKey, endpointAddress, setLoggingEnabled);
    }

    public GetAuditViewResponse getAuditView(PCEHRHeader commonHeader, Date dateFrom, Date dateTo) throws StandardErrorMsg {
        Validate.notNull((Object)commonHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)dateFrom, (String)"'dateFrom' must be specified.");
        Validate.notNull((Object)dateTo, (String)"'dateTo' must be specified.");
        CommonHeaderValidator.validate(commonHeader, true);
        Holder auditView = new Holder();
        Holder signatureHolder = null;
        GetAuditView params = new GetAuditView();
        params.setDateTo(DateUtils.getXMLGregorianCalendar(dateTo));
        params.setDateFrom(DateUtils.getXMLGregorianCalendar(dateFrom));
        ((GetAuditViewPortType)this.getPort()).getAuditView(params, auditView, DateUtils.generateTimestamp(), signatureHolder, commonHeader);
        return (GetAuditViewResponse)auditView.value;
    }
}

