/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.vendorlibrary.common.JAXBUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtil {
    private static final Logger LOG = Logger.getLogger(DOMUtil.class.getName());

    private DOMUtil() {
    }

    public static Element getDocumentElementFromXML(String xmlSource) {
        Document doc = DOMUtil.getDocumentFromXML(xmlSource);
        Element elem = null;
        if (doc != null) {
            elem = doc.getDocumentElement();
        }
        return elem;
    }

    public static Document getDocumentFromXML(String xmlSource) {
        try {
            DocumentBuilderFactory docBuilder = DocumentBuilderFactory.newInstance();
            docBuilder.setNamespaceAware(true);
            docBuilder.setIgnoringElementContentWhitespace(false);
            DocumentBuilder builder = docBuilder.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlSource)));
            if (doc != null) {
                return doc;
            }
        }
        catch (SAXException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static <T> Element getDocumentElementFromInstance(Class instanceClass, String qName, String className, T object) throws JAXBException {
        String xmlSource = JAXBUtil.marshaller(instanceClass, qName, className, object);
        ArgumentUtils.checkNotNull((Object)xmlSource, (String)"xmlSource");
        return DOMUtil.getDocumentElementFromXML(xmlSource);
    }

    public static <T> Document getDocumentFromInstance(Class instanceClass, String qName, String className, T object) throws JAXBException {
        String xmlSource = JAXBUtil.marshaller(instanceClass, qName, className, object);
        ArgumentUtils.checkNotNull((Object)xmlSource, (String)"xmlSource");
        return DOMUtil.getDocumentFromXML(xmlSource);
    }

    public static String serialiseToString(Document xmlDoc) throws TransformerException, IOException {
        return DomUtils.serialiseToString((Document)xmlDoc);
    }
}

