/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import java.util.Collection;

public final class ArgumentUtils {
    public static void checkNotNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null.");
        }
    }

    public static void checkNotNullNorEmpty(Collection collection, String name) {
        ArgumentUtils.checkNotNull(collection, name);
        if (collection.size() == 0) {
            throw new IllegalArgumentException(name + " must contain at least one item.");
        }
    }

    public static void checkNotNullNorBlank(String value, String name) {
        ArgumentUtils.checkNotNull(value, name);
        if (value.length() == 0 || value.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be a blank string.");
        }
    }

    public static void checkNullOrBlank(String value, String name) {
        if (value != null && value.trim().length() > 0) {
            throw new IllegalArgumentException("A value is not permitted for " + name + ".");
        }
    }

    public static void checkMaxLength(String value, int maxLen, String name) {
        if (value != null && value.length() > maxLen) {
            throw new IllegalArgumentException("The value for " + name + " exceeds the maximum permitted length of " + maxLen + " characters.");
        }
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isNullOrBlank(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    public static boolean isEqual(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value2 != null ? value1.equals(value2) : false;
    }

    private ArgumentUtils() {
    }
}

