<?xml version="1.0" encoding="UTF-8"?>
<!--
    Copyright 2012 NEHTA
   
    Production Disclaimer - 

    NEHTA (as Licensor) grants You a licence to this Product subject to 
    the terms of the Apache Licence (version 2.0), a copy of which is 
    available at http://www.apache.org/licenses/LICENSE-2.0, and the 
    following terms.
     
    This Product licensed under the Apache Licence and these terms may
    be used within production software systems. It nevertheless remains 
    your responsibility to test and validate the use of this product 
    within your software and the limitation of liability provisions in 
    clause 8 of the Apache Licence continue to apply.
    
    Despite clause 7 of the Apache Licence, if a condition or warranty 
    is implied by statute or law that cannot be excluded, then the 
    liability of a Contributor to the extent that it has contributed to 
    a breach of that condition or warranty is limited to one or more of 
    the following at its option: (a) in the case of goods, any one of 
    the following: the replacement of those goods or the re-supply of 
    equivalent goods; the repair of those goods; the payment of the 
    cost of replacing those or acquiring equivalent goods; or the 
    payment of the cost of having those goods repaired; and (b) in the 
    case of services: the supplying of those services again; or the 
    payment of the cost of having those services supplied again.
     
    A term which is given a meaning in the Apache Licence, has the same 
    meaning when used in these terms.
-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:cda="urn:hl7-org:v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:ext="http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0"
                exclude-result-prefixes="xsi cda ext">
    
    <!-- OUTPUT -->
    <!--================================================================================================================================================================================-->
    <xsl:output method="html" indent="yes" version="4.01" encoding="UTF-8"
                doctype-system="http://www.w3.org/TR/html4/strict.dtd"
                doctype-public="-//W3C//DTD HTML 4.01//EN"/>
    <!--================================================================================================================================================================================-->
    <!-- [END] OUTPUT -->




    <!-- CONSTANTS -->
    <!--================================================================================================================================================================================-->
    <!-- NEHTA CDA Rendering Specification Object Identifier -->
    <xsl:variable name="NEHTA_CDA_RENDERING_SPECIFICATION_OID">1.2.36.1.2001.1001.100.149</xsl:variable>
    
    <!-- Version of the NEHTA Generic CDA Stylesheet -->
    <xsl:variable name="NEHTA_GENERIC_CDA_STYLESHEET_VERSION">1.1.11</xsl:variable>
    
    <!-- Version note -->
    <xsl:variable name="VERSION_NOTE">HTML Generated by the NEHTA Generic CDA Stylesheet Version: <xsl:value-of select="$NEHTA_GENERIC_CDA_STYLESHEET_VERSION"/> </xsl:variable>

    <!-- Do note edit note -->
    <xsl:variable name="DO_NOT_EDIT_NOTE">Do NOT edit this HTML directly: it was generated via an XSLT transformation from a source CDA Release 2 XML document.</xsl:variable>

    <!-- CDA Rendering Specification Incompatibility Warning -->
    <xsl:variable name="CDA_RENDERING_SPECIFICATION_INCOMPATIBILITY_WARNING">This CDA Document requires a more recent version of the CDA rendering infrastructure than your system currently supports.</xsl:variable>

    <!-- <div> id attribute values-->
    <xsl:variable name="BANNER_DIV_ID">BANNER</xsl:variable>
    <xsl:variable name="LOGO_IMG_ID">LOGO</xsl:variable>
    <xsl:variable name="CONTENT_DIV_ID">CONTENT</xsl:variable>
    <xsl:variable name="DETAILS_DIV_ID">DETAILS</xsl:variable>
    
    <!-- Provider Identifier CSS Classes -->
    <xsl:variable name="PROVIDER_INDIVIDUAL_IDENTIFIER_CSS_CLASS">PROVIDER_INDIVIDUAL_IDENTIFIER</xsl:variable>
    <xsl:variable name="PROVIDER_ORGANISATION_IDENTIFIER_CSS_CLASS">PROVIDER_ORGANISATION_IDENTIFIER</xsl:variable>

    <!-- Version of the NEHTA CDA Rendering Specification supported by the stylesheet -->
    <xsl:variable name="NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_VERSION">1.0</xsl:variable>
    <xsl:variable name="NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_MAJOR_VERSION" select="substring-before($NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_VERSION, '.')"/>
    <xsl:variable name="NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_MINOR_VERSION" select="substring-after($NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_VERSION, '.')"/>

    <!-- NEHTA CDA Implementation Guide Object Identifiers -->
    <xsl:variable name="NEHTA_DISCHARGE_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.4</xsl:variable>
    <xsl:variable name="NEHTA_SHARED_HEALTH_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.120</xsl:variable>
    <xsl:variable name="NEHTA_E_REFERRAL_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.2</xsl:variable>
    <xsl:variable name="NEHTA_SPECIALIST_LETTER_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.132</xsl:variable>
    <xsl:variable name="NEHTA_EVENT_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.136</xsl:variable>
    <xsl:variable name="NEHTA_E_PRESCRIPTION_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.74</xsl:variable>
    <xsl:variable name="NEHTA_DISPENSE_RECORD_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.75</xsl:variable>
    <xsl:variable name="NEHTA_PRESCRIPTION_REQUEST_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.101</xsl:variable>
    <xsl:variable name="NEHTA_AUSTRALIAN_CHILDHOOD_IMMUNISATION_REGISTER_RECORD_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.144</xsl:variable>
    <xsl:variable name="NEHTA_AUSTRALIAN_ORGAN_DONOR_REGISTER_RECORD_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.147</xsl:variable>
    <xsl:variable name="NEHTA_DVA_BENEFITS_REPORT_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.140</xsl:variable>
    <xsl:variable name="NEHTA_ADVANCE_CARE_DIRECTIVE_CUSTODIAN_RECORD_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.156</xsl:variable>
    <xsl:variable name="NEHTA_PHARMACEUTICAL_BENEFITS_REPORT_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.142</xsl:variable>
    <xsl:variable name="NEHTA_CONSUMER_ENTERED_NOTES_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.151</xsl:variable>
    <xsl:variable name="NEHTA_CONSUMER_ENTERED_HEALTH_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID">1.2.36.1.2001.1001.101.100.1002.153</xsl:variable>

    <!-- Page widths -->
    <xsl:variable name="FULL_VIEWPORT_WIDTH">1024</xsl:variable>
    <xsl:variable name="TOP_MARGIN_WIDTH">4</xsl:variable>
    <xsl:variable name="LEFT_MARGIN_WIDTH">4</xsl:variable>
    <xsl:variable name="RIGHT_MARGIN_WIDTH">4</xsl:variable>
    <xsl:variable name="CONTENT_SCROLL_BAR_WIDTH">20</xsl:variable>
    <xsl:variable name="FULL_CONTENT_WIDTH">1000</xsl:variable>
    <xsl:variable name="HALF_CONTENT_WIDTH" select="$FULL_CONTENT_WIDTH div 2"/>
    <xsl:variable name="FIFTH_CONTENT_WIDTH" select="$FULL_CONTENT_WIDTH div 5"/>
    <xsl:variable name="QUARTER_CONTENT_WIDTH" select="$FULL_CONTENT_WIDTH div 4"/>
    <xsl:variable name="EIGHTH_CONTENT_WIDTH" select="$FULL_CONTENT_WIDTH div 8"/>
    <xsl:variable name="TENTH_CONTENT_WIDTH" select="$FULL_CONTENT_WIDTH div 10"/>
    <xsl:variable name="THREE_QUARTER_CONTENT_WIDTH" select="($FULL_CONTENT_WIDTH div 4) * 3"/>
    <xsl:variable name="PAGE_HEADER_ITEM_GAP">75</xsl:variable>
    <xsl:variable name="SUMMARY_DETAILS_LEFT_GAP">30</xsl:variable>
    
    <xsl:variable name="AKA_STRING">a.k.a. </xsl:variable>
    <xsl:variable name="SECTION_TITLE_NAVIGATION_SEPARATOR" select="' > '"/>
    
    <!-- Colours -->
    <xsl:variable name="GENERAL_TABLE_HEADER_CELL_BACKGROUND_COLOUR">#FFFFFF</xsl:variable>
    <xsl:variable name="GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR">#EEEEEE</xsl:variable>
    
    <!--================================================================================================================================================================================-->
    <!-- [END] CONSTANTS -->




    <!-- GLOBAL VARIABLES -->
    <!--================================================================================================================================================================================-->
    <xsl:variable name="cdaDocumentCdaRenderingSpecificationVersion" select="/cda:ClinicalDocument/cda:templateId[@root='1.2.36.1.2001.1001.100.149']/@extension"/>
    <xsl:variable name="cdaDocumentCdaRenderingSpecificationMajorVersionNumber" select="substring-before($cdaDocumentCdaRenderingSpecificationVersion, '.')"></xsl:variable>
    <xsl:variable name="cdaDocumentCdaRenderingSpecificationMinorVersionNumber" select="substring-after($cdaDocumentCdaRenderingSpecificationVersion, '.')"></xsl:variable>
    <xsl:variable name="isStylesheetCompatibleWithRequiredRenderingSpecificationVersion">
        <xsl:choose>
            <xsl:when test="string-length($cdaDocumentCdaRenderingSpecificationVersion) &gt; 0">
                <xsl:choose>
                    <xsl:when test="$cdaDocumentCdaRenderingSpecificationMajorVersionNumber &gt; $NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_MAJOR_VERSION">false</xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="$cdaDocumentCdaRenderingSpecificationMajorVersionNumber = $NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_MAJOR_VERSION">
                                <xsl:choose>
                                    <xsl:when test="$cdaDocumentCdaRenderingSpecificationMinorVersionNumber &gt; $NEHTA_GENERIC_CDA_STYLESHEET_SUPPORTED_CDA_RENDERING_SPECIFICATION_MINOR_VERSION">false</xsl:when>
                                    <xsl:otherwise>true</xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>true</xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>true</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
   
    <!-- Patient Details -->
    <xsl:variable name="patientIHI">
       <xsl:call-template name="trim">
           <xsl:with-param name="string">
               <xsl:call-template name="formatHI">
                   <xsl:with-param name="hiValue" select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:asEntityIdentifier/ext:id[@assigningAuthorityName='IHI']/@root"/>
                </xsl:call-template>
           </xsl:with-param>
       </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="patientMRN">
        <xsl:if test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:asEntityIdentifier[ext:code/@code='MR']/ext:id/@extension and 
            not (/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:asEntityIdentifier[ext:code/@code='MR']/ext:id/@displayable='false')">
            <xsl:value-of select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:asEntityIdentifier[ext:code/@code='MR']/ext:id/@extension"/>
        </xsl:if>
    </xsl:variable>
    <xsl:variable name="patientName">
        <xsl:call-template name="show-patient-name">
            <xsl:with-param name="name"
                select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:name[1]"/>
        </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="patientDateOfBirth">
        <xsl:call-template name="show-date">
            <xsl:with-param name="datetime"
                select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:birthTime"/>
        </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="patientDeceasedStatus">
        <xsl:choose>
            <xsl:when test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedInd and
                /cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedInd/@value and
                /cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedInd/@value='true'">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="patientAge">
        <xsl:choose>
            <xsl:when test="$patientDeceasedStatus='true'">DECEASED</xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="calculateAgeInYears">
                    <xsl:with-param name="birthDate">
                        <xsl:value-of
                            select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:birthTime/@value"/>
                    </xsl:with-param>
                    <xsl:with-param name="docDate">
                      <xsl:choose>
                        <xsl:when test="string-length(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/cda:high/@value) &gt; 0">
                          <xsl:value-of select="substring(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/cda:high/@value,1,8)" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="substring(/cda:ClinicalDocument/cda:effectiveTime/@value,1,8)" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template><xsl:text> years</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>    
    <xsl:variable name="patientSex">
        <xsl:if test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode and
                      /cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@code and
                      string-length(/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@code) &gt; 0 and
                      /cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@codeSystem='2.16.840.1.113883.13.68'">
            <xsl:choose>
                <xsl:when test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@code = 'M'">Male</xsl:when>
                <xsl:when test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@code = 'F'">Female</xsl:when>
                <xsl:when test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@code = 'I'">Intersex or Indeterminate</xsl:when>
                <xsl:when test="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode/@code = 'N'">Not Stated/Inadequately Described</xsl:when>
                <xsl:otherwise>Unknown</xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:variable>
     
    <!-- CDA Document Type -->
    <xsl:variable name="cdaDocumentType">
        <xsl:choose>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_DISCHARGE_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID]">e-Discharge Summary</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_SHARED_HEALTH_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID]">Shared Health Summary</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_E_REFERRAL_CDA_IMPLEMENTATION_GUIDE_OID]">e-Referral</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_SPECIALIST_LETTER_CDA_IMPLEMENTATION_GUIDE_OID]">Specialist Letter</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_EVENT_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID]">Event Summary</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_E_PRESCRIPTION_CDA_IMPLEMENTATION_GUIDE_OID]">e-Prescription</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_DISPENSE_RECORD_CDA_IMPLEMENTATION_GUIDE_OID]">Dispense Record</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_PRESCRIPTION_REQUEST_CDA_IMPLEMENTATION_GUIDE_OID]">Prescription Request</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_AUSTRALIAN_CHILDHOOD_IMMUNISATION_REGISTER_RECORD_CDA_IMPLEMENTATION_GUIDE_OID]">Australian Childhood Immunisation Register Record</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_AUSTRALIAN_ORGAN_DONOR_REGISTER_RECORD_CDA_IMPLEMENTATION_GUIDE_OID]">Australian Organ Donor Register Record</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_DVA_BENEFITS_REPORT_CDA_IMPLEMENTATION_GUIDE_OID]">DVA Benefits Report</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_PHARMACEUTICAL_BENEFITS_REPORT_CDA_IMPLEMENTATION_GUIDE_OID]">Pharmaceutical Benefits Report</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_ADVANCE_CARE_DIRECTIVE_CUSTODIAN_RECORD_CDA_IMPLEMENTATION_GUIDE_OID]">Advance Care Directive Custodian Record</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_CONSUMER_ENTERED_NOTES_CDA_IMPLEMENTATION_GUIDE_OID]">Consumer Entered Notes</xsl:when>
            <xsl:when test="/cda:ClinicalDocument/cda:templateId[@root=$NEHTA_CONSUMER_ENTERED_HEALTH_SUMMARY_CDA_IMPLEMENTATION_GUIDE_OID]">Consumer Entered Health Summary</xsl:when>
            
            <xsl:when test="/cda:ClinicalDocument/cda:code/@displayName and
                            string-length(/cda:ClinicalDocument/cda:code/@displayName) &gt; 0">
                <xsl:value-of select="/cda:ClinicalDocument/cda:code/@displayName"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Clinical Document</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <!-- CDA Document Title -->
    <xsl:variable name="cdaDocumentTitle">
        <xsl:choose>
            <xsl:when test="/cda:ClinicalDocument/cda:title and
                            string-length(/cda:ClinicalDocument/cda:title)  &gt;= 1">
                <xsl:value-of select="/cda:ClinicalDocument/cda:title"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$cdaDocumentType"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <!-- Document Rendering View Title -->
    <xsl:variable name="documentRenderingViewTitle">
        <xsl:call-template name="trim">
            <xsl:with-param name="string">
                <xsl:choose>
                    <xsl:when test="string-length($patientMRN) &gt; 0 and string-length($patientIHI) &gt; 0">
                        <xsl:value-of select="concat($cdaDocumentTitle, 
                                                     ' | PATIENT: ',
                                                     $patientName,
                                                     ' | SEX: ',
                                                     $patientSex,
                                                     ' | DOB: ',
                                                     $patientDateOfBirth,
                                                     ' | AGE: ', 
                                                     $patientAge,
                                                     ' | IHI: ',
                                                     $patientIHI,
                                                     ' | MRN: ',
                                                     $patientMRN)"/>
                    </xsl:when>
                    <xsl:when test="$patientMRN='' and string-length($patientIHI) &gt; 0">
                        <xsl:value-of select="concat($cdaDocumentTitle, 
                            ' | PATIENT: ',
                            $patientName,
                            ' | SEX: ',
                            $patientSex,
                            ' | DOB: ',
                            $patientDateOfBirth,
                            ' | AGE: ', 
                            $patientAge,
                            ' | IHI: ',
                            $patientIHI)"/>
                    </xsl:when>
                    <xsl:when test="string-length($patientMRN) &gt; 0 and $patientIHI=''">
                        <xsl:value-of select="concat($cdaDocumentTitle, 
                            ' | PATIENT: ',
                            $patientName,
                            ' | SEX: ',
                            $patientSex,
                            ' | DOB: ',
                            $patientDateOfBirth,
                            ' | AGE: ', 
                            $patientAge,
                            ' | MRN: ',
                            $patientMRN)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($cdaDocumentTitle, 
                                                     ' | PATIENT: ',
                                                     $patientName,
                                                     ' | SEX: ',
                                                     $patientSex,
                                                     ' | DOB: ',
                                                     $patientDateOfBirth,
                                                     ' | AGE: ', 
                                                     $patientAge)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:variable> 
        
    <!--================================================================================================================================================================================-->
    <!-- [END] GLOBAL VARIABLES -->
    
    
    
    
    <!-- ENTRY TEMPLATE -->
    <!--================================================================================================================================================================================-->
    <xsl:template match="/cda:ClinicalDocument">
        <xsl:element name="html"> 
            <xsl:attribute name="lang">en</xsl:attribute>
            <xsl:element name="head">
                <xsl:element name="meta">
                    <xsl:attribute name="http-equiv">Content-Style-Type</xsl:attribute>
                    <xsl:attribute name="content">text/css</xsl:attribute>
                </xsl:element>
                <xsl:element name="meta">
                    <xsl:attribute name="http-equiv">Content-Script-Type</xsl:attribute>
                    <xsl:attribute name="content">text/javascript</xsl:attribute>
                </xsl:element>
                <xsl:element name="meta">
                    <xsl:attribute name="name">viewport</xsl:attribute>
                    <xsl:attribute name="content">user-scalable=yes, width=<xsl:value-of select="$FULL_VIEWPORT_WIDTH"/></xsl:attribute>
                </xsl:element>
                <xsl:element name="meta">
                    <xsl:attribute name="name">format-detection</xsl:attribute>
                    <xsl:attribute name="content">telephone=no</xsl:attribute>
                </xsl:element>
                <xsl:element name="meta">
                    <xsl:attribute name="http-equiv">X-UA-Compatible</xsl:attribute>
                    <xsl:attribute name="content">IE=edge</xsl:attribute>
                </xsl:element>	
                <xsl:comment><xsl:value-of select="$DO_NOT_EDIT_NOTE"/></xsl:comment>
                <xsl:comment><xsl:value-of select="$VERSION_NOTE"/></xsl:comment>
                <xsl:call-template name="addJavaScript"/>
                <xsl:element name="title"><xsl:value-of select="$documentRenderingViewTitle"/></xsl:element>
                <xsl:call-template name="addCSS"/>
            </xsl:element> <!-- </head> -->
            <xsl:element name="body">
                <xsl:choose>
                    <xsl:when test="$isStylesheetCompatibleWithRequiredRenderingSpecificationVersion='false'">
                        <xsl:attribute name="onload">load();cdaRenderSpecificationVersionWarning();</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="onload">load();</xsl:attribute>        
                    </xsl:otherwise>
                </xsl:choose>                
                <xsl:element name="div">
                    <xsl:attribute name="style">position: absolute;</xsl:attribute>
                    <!-- Display the Banner -->
                    <xsl:element name="div">
                        <xsl:attribute name="id"><xsl:value-of select="$BANNER_DIV_ID"/></xsl:attribute>
                        <xsl:call-template name="getBanner"/>
                    </xsl:element> <!-- </div> -->
                    
                    <!-- Display the scrollable part of the document (including Incompatibility Warning. the Details and the Body) -->
                    <xsl:element name="div">
                        <xsl:attribute name="id"><xsl:value-of select="$CONTENT_DIV_ID"/></xsl:attribute>
                        

                        <!-- Display Start of Document Indicator -->
                        <xsl:call-template name="getStartOfDocumentIndicator"/>
                        
                        <!-- Display the Details -->
                        <xsl:element name="div">
                            <xsl:attribute name="id"><xsl:value-of select="$DETAILS_DIV_ID"/></xsl:attribute>
                            <xsl:call-template name="getDetailsTable"/>
                        </xsl:element>
                        
                        <!-- Display the Body -->
                        <xsl:apply-templates select="cda:component/cda:structuredBody|cda:component/cda:nonXMLBody"/>
                        
                        <!-- Apply footnote -->
                        <xsl:element name="div">
                            <xsl:attribute name="id">FOOTNOTES</xsl:attribute>
                            <xsl:call-template name="getFootnotesTable"></xsl:call-template>
                        </xsl:element>
                        
                        
                        <!-- Display End of Document -->
                        <xsl:call-template name="getEndOfDocumentIndicator"/>
                        
                        <!-- Space to allow scrolling to footnote references -->
                        <xsl:call-template name="getSpaceToScrollToFootnotesDiv"/>
                    </xsl:element> <!-- </div> (content div) -->
                </xsl:element> <!-- parent div -->
            </xsl:element> <!-- </body> -->
        </xsl:element> <!-- </html -->
    </xsl:template>
    <!--================================================================================================================================================================================-->
    <!-- [END] ENTRY TEMPLATE -->
    
    
    
    
    <!-- BANNER TEMPLATES -->
    <!--================================================================================================================================================================================-->   

    <xsl:template name="getBanner">
        <xsl:element name="h1">
            <xsl:attribute name="class">titleheading1</xsl:attribute>
            <xsl:value-of select="$cdaDocumentTitle"/>
        </xsl:element> <!-- </h1> -->
        <xsl:element name="dl">
            <xsl:attribute name="class">bannerpatientdemographicsdl</xsl:attribute>
            <xsl:element name="dt">
                <xsl:attribute name="class">bannerpatientdemographicsdt</xsl:attribute>
                PATIENT:
            </xsl:element>
            <xsl:element name="dd">
                <xsl:attribute name="class">bannerpatientdemographicsdd</xsl:attribute>
                <xsl:value-of select="$patientName"/>
            </xsl:element>
            <xsl:element name="dt">
                <xsl:attribute name="class">bannerpatientdemographicsdt</xsl:attribute>
                SEX:
            </xsl:element>
            <xsl:element name="dd">
                <xsl:attribute name="class">bannerpatientdemographicsdd</xsl:attribute>
                <xsl:value-of select="$patientSex"/>
            </xsl:element>
            <xsl:element name="dt">
                <xsl:attribute name="class">bannerpatientdemographicsdt</xsl:attribute>
                DOB:
            </xsl:element>
            <xsl:element name="dd">
                <xsl:attribute name="class">bannerpatientdemographicsdd</xsl:attribute>
                <xsl:value-of select="$patientDateOfBirth"/>
            </xsl:element>
            <xsl:element name="dt">
                <xsl:attribute name="class">bannerpatientdemographicsdt</xsl:attribute>
                AGE:
            </xsl:element>
            <xsl:element name="dd">
                <xsl:attribute name="class">bannerpatientdemographicsdd</xsl:attribute>
                <xsl:value-of select="$patientAge"/>
            </xsl:element>
        </xsl:element> <!-- </dl> -->
        <xsl:element name="table">
            <xsl:attribute name="class">pageWidth</xsl:attribute>
            <xsl:attribute name="style">border-left: 1px SOLID #000000;
                                        border-right: 1px SOLID #000000;
                                        border-bottom: 1px SOLID #000000;
                                        table-layout: fixed;
                                        word-wrap: break-word;
                                        margin-bottom: <xsl:value-of select="$TOP_MARGIN_WIDTH"/>px;</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="summary">top banner panel</xsl:attribute>
            <xsl:element name="tbody">
                <xsl:element name="tr">
                    <xsl:attribute name="class">showHideHeaderDetailsButtonTableRow</xsl:attribute>
                    <xsl:element name="td">
                        <xsl:if test="$patientIHI='' and $patientMRN=''">
                            <xsl:attribute name="colspan">2</xsl:attribute>    
                        </xsl:if>
                        <xsl:attribute name="align">left</xsl:attribute>
                        <xsl:attribute name="style">background: #EEEEEE; 
                                                    color: #000000; 
                                                    font-size: 13px; 
                                                    padding: 2px;
                                                    font-weight: bold;</xsl:attribute>
                        <xsl:element name="form">
                            <xsl:attribute name="action">/</xsl:attribute>
                            <xsl:attribute name="style">display: inline;</xsl:attribute>
                            <xsl:element name="div">
                                <xsl:attribute name="id">administrativeDetailsCheckboxDiv</xsl:attribute>
                                <xsl:attribute name="style">display: inline;</xsl:attribute>
                                <xsl:element name="input">
                                    <xsl:attribute name="type">checkbox</xsl:attribute>
                                    <xsl:attribute name="name">administrativeDetailsCheckbox</xsl:attribute>
                                    <xsl:attribute name="id">administrativeDetailsCheckboxId</xsl:attribute>
                                    <xsl:attribute name="checked">checked</xsl:attribute>
                                    <xsl:attribute name="onclick">toggleDetails('<xsl:value-of select="$DETAILS_DIV_ID"/>');</xsl:attribute>
                                </xsl:element> <!-- </input> -->
                                <xsl:element name="label">
                                    <xsl:attribute name="for">administrativeDetailsCheckboxId</xsl:attribute>
                                    Administrative Details
                                </xsl:element> <!-- </label> -->
                                <xsl:call-template name="printNBSPs"><xsl:with-param name="number">6</xsl:with-param></xsl:call-template>
                            </xsl:element> <!-- </div> -->
                            <xsl:element name="div">
                                <xsl:attribute name="id">providerIdentifiersCheckboxDiv</xsl:attribute>
                                <xsl:attribute name="style">display: inline;</xsl:attribute>
                                <xsl:element name="input">
                                    <xsl:attribute name="type">checkbox</xsl:attribute>
                                    <xsl:attribute name="name">providerIdentifiersCheckbox</xsl:attribute>
                                    <xsl:attribute name="id">providerIdentifiersCheckboxId</xsl:attribute>
                                    <xsl:attribute name="checked">checked</xsl:attribute>
                                    <xsl:attribute name="onclick">toggleProviderIdentifiers('<xsl:value-of select="$PROVIDER_INDIVIDUAL_IDENTIFIER_CSS_CLASS"/>','<xsl:value-of select="$PROVIDER_ORGANISATION_IDENTIFIER_CSS_CLASS"/>');</xsl:attribute>
                                </xsl:element> <!-- </input> -->
                                <xsl:element name="label">
                                    <xsl:attribute name="for">providerIdentifiersCheckboxId</xsl:attribute>
                                    Provider Identifiers
                                </xsl:element> <!-- </label> -->
                                <xsl:element name="input">
                                    <xsl:attribute name="id">submitButtonId</xsl:attribute>
                                    <xsl:attribute name="type">submit</xsl:attribute>
                                    <xsl:attribute name="style">display: none;</xsl:attribute>
                                    <xsl:attribute name="value">none</xsl:attribute>
                                </xsl:element> <!-- </input> -->
                            </xsl:element> <!-- </div> -->
                        </xsl:element> <!-- </form> -->                
                    </xsl:element> <!-- </td> -->
                    <xsl:if test="$patientIHI!='' or $patientMRN!=''">
                        <xsl:element name="td">
                            <xsl:attribute name="align">left</xsl:attribute>
                            <xsl:attribute name="style">background: #EEEEEE;
                                                        color: #000000;
                                                        font-size: 13px;
                                                        padding: 2px;
                                                        word-wrap: break-word;
                                                        font-weight: bold;
                                                        text-align: right;
                                                        vertical-align: top;</xsl:attribute>
                            <xsl:element name="dl">
                                <xsl:attribute name="class">bannerpatientidentifiersdl</xsl:attribute>
                                <xsl:if test="$patientIHI!=''">
                                    <xsl:element name="dt">
                                        <xsl:attribute name="class">bannerpatientihidt</xsl:attribute>
                                        IHI:</xsl:element>
                                    <xsl:element name="dd">
                                        <xsl:attribute name="class">bannerpatientihidd</xsl:attribute>
                                        <xsl:value-of select="$patientIHI"/>
                                    </xsl:element>
                                </xsl:if>
                                <xsl:if test="string-length($patientMRN) &gt; 0">
                                    <xsl:element name="dt">
                                        <xsl:attribute name="class">bannerpatientmrndt</xsl:attribute>
                                        MRN:</xsl:element>
                                    <xsl:element name="dd">
                                        <xsl:attribute name="class">bannerpatientmrndd</xsl:attribute>
                                        <xsl:value-of select="$patientMRN"/>
                                    </xsl:element>
                                </xsl:if>
                            </xsl:element> <!-- </dl> -->
                        </xsl:element> <!-- </td> -->
                    </xsl:if>
                </xsl:element> <!-- </tr> -->
                <!-- Display Incompatibility Warning (if necessary) -->
                <xsl:if test="$isStylesheetCompatibleWithRequiredRenderingSpecificationVersion='false'">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="colspan">2</xsl:attribute>
                            <xsl:attribute name="align">center</xsl:attribute>
                            <xsl:attribute name="style">background: #EEEEEE; 
                                color: #000000; 
                                border-top: 1px SOLID #000000;
                                font-size: 12px; 
                                padding: 2px;
                                font-weight: bold;</xsl:attribute>
                            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute><xsl:value-of select="$CDA_RENDERING_SPECIFICATION_INCOMPATIBILITY_WARNING"/></xsl:element>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
    </xsl:template>
 
    <!--================================================================================================================================================================================-->   
    <!-- [END] BANNER TEMPLATES -->
    


    <!-- DETAILS TEMPLATES -->
    <!--================================================================================================================================================================================-->   

    <xsl:template name="getDetailsTable">
        <xsl:element name="table">
            <xsl:attribute name="class">pageWidth</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="style">page-break-inside: avoid;</xsl:attribute>
            <xsl:attribute name="summary">document general</xsl:attribute>
            <xsl:element name="tbody">
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="valign">top</xsl:attribute>
                        <xsl:element name="table">
                            <xsl:attribute name="summary">Patient / Facility / Encompassing Encounter / Responsible Health Professsional At Time Of Discharge / Nominated Primary Healthcare Provider Organisation / details</xsl:attribute>
                            <xsl:element name="tbody">
                                <xsl:element name="tr">
                                    <xsl:element name="td">
                                        <xsl:attribute name="valign">top</xsl:attribute>
                                        <xsl:call-template name="getPatientDetailsTable"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                                <xsl:call-template name="getEncounterDetails"/>
                                <xsl:call-template name="getFacilityDetailsTableRow"/>
                                <xsl:call-template name="getResponsibleHealthProfessionalAtTimeOfDischargeRow"/>
                                <xsl:call-template name="getNominatedPrimaryHealthcareProviderOrganisationRow"/>
                                <xsl:call-template name="getRefereePersonRow"/>
                                <xsl:call-template name="getRefereeOrganisationRow"/>
                                <xsl:call-template name="getReferrerRow"/>
                            </xsl:element> <!-- </tbody> --> 
                        </xsl:element> <!-- </table> -->
                    </xsl:element> <!-- </td> -->
                    <xsl:element name="td">
                        <xsl:attribute name="valign">top</xsl:attribute>
                        <xsl:element name="table">
                            <xsl:attribute name="summary">Main Title</xsl:attribute>
                            <xsl:element name="tbody">
                                <xsl:element name="tr">
                                    <xsl:element name="td">
                                        <xsl:attribute name="valign">top</xsl:attribute>
                                        <xsl:call-template name="getMainTitle"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                                <xsl:element name="tr">
                                    <xsl:element name="td">
                                        <xsl:attribute name="valign">top</xsl:attribute>
                                        <xsl:call-template name="getDocumentMetadataTable"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                                <xsl:element name="tr">
                                    <xsl:element name="td">
                                        <xsl:attribute name="valign">top</xsl:attribute>
                                        <xsl:call-template name="getDocumentAuthorDetailsTable"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:element> <!-- </tbody> -->
                        </xsl:element> <!-- </table> -->
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->                
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
        
        <xsl:call-template name="getHorizontalSpacer"/>
        
        <xsl:if test="count(./cda:informationRecipient[@typeCode='PRCP' or not(@typeCode)]/cda:intendedRecipient) &gt; 0">
            <xsl:call-template name="getRecipientsTable">
                <xsl:with-param name="title">PRIMARY RECIPIENTS</xsl:with-param>
                <xsl:with-param name="tableId">PRIMARY_RECIPIENTS_TABLE</xsl:with-param>
                <xsl:with-param name="recipients" select="./cda:informationRecipient[@typeCode='PRCP' or not(@typeCode)]/cda:intendedRecipient" />
            </xsl:call-template>
            <xsl:call-template name="getHorizontalSpacer"/>
        </xsl:if>

        <xsl:if test="count(./cda:informationRecipient[@typeCode='TRC']/cda:intendedRecipient) &gt; 0">
            <xsl:call-template name="getRecipientsTable">
                <xsl:with-param name="title">SECONDARY RECIPIENTS</xsl:with-param>
                <xsl:with-param name="tableId">SECONDARY_RECIPIENTS_TABLE</xsl:with-param>
                <xsl:with-param name="recipients" select="./cda:informationRecipient[@typeCode='TRC']/cda:intendedRecipient" />
            </xsl:call-template>
            <xsl:call-template name="getHorizontalSpacer"/>
        </xsl:if>
                
        <xsl:if test="count(./cda:participant[@typeCode='PART' and cda:functionCode/@code!='PCP']) &gt; 0">
            <xsl:call-template name="getParticipantsTable">
                <xsl:with-param name="title">PARTICIPANTS</xsl:with-param>
                <xsl:with-param name="tableId">PARTICIPANTS_TABLE</xsl:with-param>
                <xsl:with-param name="participants" select="./cda:participant[@typeCode='PART' and cda:functionCode/@code!='PCP']" />
            </xsl:call-template>
            <xsl:call-template name="getHorizontalSpacer"/>
        </xsl:if>

        <xsl:if test="count(./cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and cda:associatedEntity/cda:associatedPerson]) &gt; 0">
            <xsl:call-template name="getParticipantsTable">
                <xsl:with-param name="title">NOMINATED PRIMARY HEALTHCARE PROVIDER PERSON</xsl:with-param>
                <xsl:with-param name="tableId">NOMINATED_PRIMARY_HEALTHCARE_PROVIDER_PARTICIPANTS_TABLE</xsl:with-param>
                <xsl:with-param name="participants" select="./cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and cda:associatedEntity/cda:associatedPerson]" />
            </xsl:call-template>
            <xsl:call-template name="getHorizontalSpacer"/>
        </xsl:if>        
    </xsl:template>

    <xsl:template name="getMainTitle">
        <xsl:variable name="facilityName">
            <xsl:choose>
                <xsl:when test="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name">
                    <xsl:value-of select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="table">
            <xsl:attribute name="class">halfPageWidth</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="summary">Main Title</xsl:attribute>
            <xsl:element name="tbody">
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="colspan">2</xsl:attribute>
                        <xsl:attribute name="align">center</xsl:attribute>
                        <xsl:element name="br"/>
                        <xsl:element name="h2">
                            <xsl:attribute name="class">maintitleheading2</xsl:attribute>
                            <xsl:value-of select="$facilityName"/>
                        </xsl:element>
                    </xsl:element> <!-- </td> --> 
                </xsl:element> <!-- </tr> -->
                <xsl:if test="/cda:ClinicalDocument/cda:component/cda:structuredBody//cda:observationMedia[@ID='LOGO']/cda:value[@mediaType='image/png']">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="colspan">2</xsl:attribute>
                            <xsl:attribute name="align">center</xsl:attribute>
                            <xsl:call-template name="renderLogo"/>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="colspan">2</xsl:attribute>
                        <xsl:element name="br"/>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
    </xsl:template>
    
    <xsl:template name="getEncounterDetails">
        <xsl:variable name="startDate">
            <xsl:if
                test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/cda:low/@value!=''">
                <xsl:call-template name="show-time">
                    <xsl:with-param name="datetime"
                        select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/cda:low"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="endDate">
            <xsl:if
                test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/cda:high/@value!=''">
                <xsl:call-template name="show-time">
                    <xsl:with-param name="datetime"
                        select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/cda:high"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>

        <xsl:variable name="encounterDate">
            <xsl:if
                test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime/@value!=''">
                <xsl:call-template name="show-time">
                    <xsl:with-param name="datetime"
                        select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="separationMode" select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:dischargeDispositionCode/@displayName"/>
        
        <xsl:if test="$startDate != '' or
                      $endDate != '' or
                      $encounterDate != '' or
                      $separationMode != ''">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        ENCOUNTER DETAILS
                    </xsl:element> <!-- </h2> -->
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">Encounter Details</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:if test="$startDate!=''">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="$cdaDocumentType='e-Discharge Summary'">Admission Date</xsl:when>
                                            <xsl:otherwise>Start Date</xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:value-of select="$startDate"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="$endDate!=''">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="$cdaDocumentType='e-Discharge Summary'">Discharge Date</xsl:when>
                                            <xsl:otherwise>End Date</xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:value-of select="$endDate"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="$encounterDate!=''">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="$cdaDocumentType='Specialist Letter'">Date/Time Subject of Care Seen</xsl:when>
                                            <xsl:otherwise>Encounter Date</xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:value-of select="$encounterDate"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>

                            <xsl:if test="$separationMode!=''">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Separation Mode
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:value-of select="$separationMode"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="$cdaDocumentType='e-Discharge Summary' and
                                /cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section/cda:entry/cda:observation[cda:code/@code='103.16028' and cda:code/@codeSystem='1.2.36.1.2001.1001.101' and cda:code/@displayName='Specialty']/cda:value[(@displayName and (string-length(@displayName) &gt; 0)) or (cda:originalText and string-length(cda:originalText) &gt; 0)]">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Specialties
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="ul">
                                            <xsl:attribute name="class">specialtiesul</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section/cda:entry/cda:observation[cda:code/@code='103.16028' and cda:code/@codeSystem='1.2.36.1.2001.1001.101' and cda:code/@displayName='Specialty']/cda:value">
                                                <xsl:element name="li">
                                                    <xsl:attribute name="class">specialtiesli</xsl:attribute>
                                                    <xsl:choose>
                                                        <xsl:when test="./@code and 
                                                                        (string-length(./@code) &gt; 0) and 
                                                                        ./@codeSystem and 
                                                                        (string-length(./@codeSystem) &gt; 0) and 
                                                                        ./@displayName and 
                                                                        (string-length(./@displayName) &gt; 0)">
                                                            <xsl:value-of select="./@displayName"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:if test="./cda:originalText and string-length(./cda:originalText) &gt; 0"><xsl:value-of select="./cda:originalText/text()"/></xsl:if>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:element>
                                            </xsl:for-each>
                                        </xsl:element>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> --> 
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getFacilityDetailsTableRow">
        <xsl:if test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name and 
                      string-length(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        FACILITY DETAILS
                    </xsl:element> <!-- </h2> -->                    
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">Facility Details</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:element name="tr">
                                <xsl:element name="th">
                                    <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                    Name
                                </xsl:element> <!-- </th> -->
                                <xsl:element name="td">
                                    <xsl:attribute name="class">sidevalue</xsl:attribute>
                                    <xsl:value-of select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderOrganisationIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element> <!-- </td> -->
                            </xsl:element> <!-- </tr> -->
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:addr) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Address
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="dl">
                                            <xsl:attribute name="class">addressdl</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:addr">
                                                <xsl:call-template name="show-address">
                                                    <xsl:with-param name="address" select="."/>
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:element> <!-- </dl> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
        
                            <xsl:if test="count(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:telecom) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Contact
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:call-template name="getContactDetails">
                                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:asOrganizationPartOf/cda:wholeOrganization"/>
                                        </xsl:call-template>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>

                            <xsl:if test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:name and
                                          string-length(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Department
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/cda:name"/>
                                        <xsl:for-each select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:location/cda:healthCareFacility/cda:serviceProviderOrganization/ext:asEntityIdentifier">
                                            <xsl:call-template name="getProviderOrganisationIdentifier">
                                                <xsl:with-param name="entityIdentifier" select="."/>
                                            </xsl:call-template>
                                        </xsl:for-each>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> -->
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element> <!-- </td> -->
            </xsl:element> <!-- </tr> -->
        </xsl:if>
    </xsl:template>

    <xsl:template name="getNominatedPrimaryHealthcareProviderOrganisationRow">
        <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name and 
            string-length(/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        NOMINATED PRIMARY HEALTHCARE PROVIDER ORGANISATION
                    </xsl:element> <!-- </h2> -->
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">NOMINATED PRIMARY HEALTHCARE PROVIDER ORGANISATION</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:element name="tr">
                                <xsl:element name="th">
                                    <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                    Name
                                </xsl:element> <!-- </th> -->
                                <xsl:element name="td">
                                    <xsl:attribute name="class">sidevalue</xsl:attribute>
                                    <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderOrganisationIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element> <!-- </td> -->
                            </xsl:element> <!-- </tr> -->
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:addr) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Address
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="dl">
                                            <xsl:attribute name="class">addressdl</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:addr">
                                                <xsl:call-template name="show-address">
                                                    <xsl:with-param name="address" select="."/>
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:element> <!-- </dl> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:telecom) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Contact
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:call-template name="getContactDetails">
                                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization"/>
                                        </xsl:call-template>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Department
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='PART' and cda:functionCode/@code='PCP' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> -->
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element> <!-- </td> -->
            </xsl:element> <!-- </tr> -->
        </xsl:if>
    </xsl:template>

    <xsl:template name="getResponsibleHealthProfessionalAtTimeOfDischargeRow">
        <xsl:if test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/cda:name and
                      string-length(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/cda:name) &gt; 0">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        RESPONSIBLE HEALTH PROFESSIONAL AT TIME OF DISCHARGE
                    </xsl:element> <!-- </h2> -->
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">RESPONSIBLE HEALTH PROFESSIONAL AT TIME OF DISCHARGE</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:element name="tr">
                                <xsl:element name="th">
                                    <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                    Name
                                </xsl:element> <!-- </th> -->
                                <xsl:element name="td">
                                    <xsl:attribute name="class">sidevalue</xsl:attribute>
                                    
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/cda:name">
                                        <xsl:if test="position() > 1">
                                            <xsl:value-of select="$AKA_STRING"/>
                                        </xsl:if>
                                        <xsl:call-template name="show-name">
                                            <xsl:with-param name="name" select="."/>
                                        </xsl:call-template>
                                        <xsl:if test="position()!=last()">
                                            <xsl:element name="br"/>
                                        </xsl:if>
                                    </xsl:for-each>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderIndividualIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element> <!-- </td> -->
                            </xsl:element> <!-- </tr> -->
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:addr) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Address
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="dl">
                                            <xsl:attribute name="class">addressdl</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:addr">
                                                <xsl:call-template name="show-address">
                                                    <xsl:with-param name="address" select="."/>
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:element> <!-- </dl> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/cda:telecom) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Contact
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:call-template name="getContactDetails">
                                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson"/>
                                        </xsl:call-template>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>

                            <xsl:if test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Organisation
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Department
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:componentOf/cda:encompassingEncounter/cda:encounterParticipant[@typeCode='DIS']/cda:assignedEntity/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> -->
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element> <!-- </td> -->
            </xsl:element> <!-- </tr> -->
        </xsl:if>
    </xsl:template>

    <xsl:template name="getRefereePersonRow">
        <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/cda:name and
            string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/cda:name) &gt; 0">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        REFEREE
                    </xsl:element> <!-- </h2> -->
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">REFEREE</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:element name="tr">
                                <xsl:element name="th">
                                    <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                    Name
                                </xsl:element> <!-- </th> -->
                                <xsl:element name="td">
                                    <xsl:attribute name="class">sidevalue</xsl:attribute>
                                    
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/cda:name">
                                        <xsl:if test="position() > 1">
                                            <xsl:value-of select="$AKA_STRING"/>
                                        </xsl:if>
                                        <xsl:call-template name="show-name">
                                            <xsl:with-param name="name" select="."/>
                                        </xsl:call-template>
                                        <xsl:if test="position()!=last()">
                                            <xsl:element name="br"/>
                                        </xsl:if>
                                    </xsl:for-each>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderIndividualIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element> <!-- </td> -->
                            </xsl:element> <!-- </tr> -->
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity[cda:associatedPerson]/cda:addr) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Address
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="dl">
                                            <xsl:attribute name="class">addressdl</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity[cda:associatedPerson]/cda:addr">
                                                <xsl:call-template name="show-address">
                                                    <xsl:with-param name="address" select="."/>
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:element> <!-- </dl> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/cda:telecom) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Contact
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:call-template name="getContactDetails">
                                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson"/>
                                        </xsl:call-template>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Organisation
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Department
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> -->
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element> <!-- </td> -->
            </xsl:element> <!-- </tr> -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getRefereeOrganisationRow">
        <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name and 
            string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        REFEREE ORGANISATION
                    </xsl:element> <!-- </h2> -->
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">REFEREE ORGANISATION</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:element name="tr">
                                <xsl:element name="th">
                                    <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                    Name
                                </xsl:element> <!-- </th> -->
                                <xsl:element name="td">
                                    <xsl:attribute name="class">sidevalue</xsl:attribute>
                                    <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderOrganisationIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element> <!-- </td> -->
                            </xsl:element> <!-- </tr> -->
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:addr) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Address
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="dl">
                                            <xsl:attribute name="class">addressdl</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:addr">
                                                <xsl:call-template name="show-address">
                                                    <xsl:with-param name="address" select="."/>
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:element> <!-- </dl> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:telecom) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Contact
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:call-template name="getContactDetails">
                                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:asOrganizationPartOf/cda:wholeOrganization"/>
                                        </xsl:call-template>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Department
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='REFT' and not(cda:associatedEntity/cda:associatedPerson)]/cda:associatedEntity/cda:scopingOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> -->
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element> <!-- </td> -->
            </xsl:element> <!-- </tr> -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getReferrerRow">
        <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/cda:name and
            string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/cda:name) &gt; 0">
            <xsl:element name="tr">
                <xsl:element name="td">
                    <xsl:attribute name="valign">top</xsl:attribute>
                    <xsl:element name="h2">
                        <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
                        REFERRER
                    </xsl:element> <!-- </h2> -->
                    <xsl:element name="table">
                        <xsl:attribute name="class">halfPageWidth</xsl:attribute>
                        <xsl:attribute name="style">page-break-inside: avoid;
                            table-layout: fixed;
                            word-wrap: break-word;</xsl:attribute>
                        <xsl:attribute name="cellspacing">0</xsl:attribute>
                        <xsl:attribute name="cellpadding">0</xsl:attribute>
                        <xsl:attribute name="summary">REFERRER</xsl:attribute>
                        <xsl:element name="tbody">
                            <xsl:element name="tr">
                                <xsl:element name="th">
                                    <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                    Name
                                </xsl:element> <!-- </th> -->
                                <xsl:element name="td">
                                    <xsl:attribute name="class">sidevalue</xsl:attribute>
                                    
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/cda:name">
                                        <xsl:if test="position() > 1">
                                            <xsl:value-of select="$AKA_STRING"/>
                                        </xsl:if>
                                        <xsl:call-template name="show-name">
                                            <xsl:with-param name="name" select="."/>
                                        </xsl:call-template>
                                        <xsl:if test="position()!=last()">
                                            <xsl:element name="br"/>
                                        </xsl:if>
                                    </xsl:for-each>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderIndividualIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element> <!-- </td> -->
                            </xsl:element> <!-- </tr> -->
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity[cda:associatedPerson]/cda:addr) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Address
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:element name="dl">
                                            <xsl:attribute name="class">addressdl</xsl:attribute>
                                            <xsl:for-each select="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity[cda:associatedPerson]/cda:addr">
                                                <xsl:call-template name="show-address">
                                                    <xsl:with-param name="address" select="."/>
                                                </xsl:call-template>
                                            </xsl:for-each>
                                        </xsl:element> <!-- </dl> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="count(/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/cda:telecom) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Contact
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                                        <xsl:call-template name="getContactDetails">
                                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson"/>
                                        </xsl:call-template>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Organisation
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                            
                            <xsl:if test="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:name and
                                string-length(/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:name) &gt; 0">
                                <xsl:element name="tr">
                                    <xsl:element name="th">
                                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                        Department
                                    </xsl:element> <!-- </th> -->
                                    <xsl:element name="td">
                                        <xsl:value-of select="/cda:ClinicalDocument/cda:participant[@typeCode='REFB']/cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:name"/>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:if>
                        </xsl:element> <!-- </tbody> -->
                    </xsl:element> <!-- </table> -->
                    <xsl:call-template name="getHalfHorizontalSpacer"/>
                </xsl:element> <!-- </td> -->
            </xsl:element> <!-- </tr> -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getPatientDetailsTable">
        <xsl:variable name="deceasedTime">
            <xsl:if test="$patientDeceasedStatus='true' and
                          /cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedTime and
                          /cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedTime/@value and
                          string-length(/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedTime/@value) &gt; 0">
                <xsl:call-template name="show-time">
                    <xsl:with-param name="datetime"
                        select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:deceasedTime"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="h2">
            <xsl:attribute name="class">halfsectionheader halfsectionheading2</xsl:attribute>
            PATIENT DETAILS
        </xsl:element> <!-- </h2> -->
        <xsl:element name="table">
            <xsl:attribute name="class">halfPageWidth</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="style">page-break-inside: avoid;
                                        table-layout: fixed;
                                        word-wrap: break-word;</xsl:attribute>
            <xsl:attribute name="summary">Patient details</xsl:attribute>
            <xsl:element name="tbody">
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                        Name
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                        <xsl:for-each select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:name">
                            <xsl:if test="position() > 1">
                                <xsl:value-of select="$AKA_STRING"/>
                            </xsl:if>
                            <xsl:call-template name="show-patient-name">
                                <xsl:with-param name="name" select="."/>
                            </xsl:call-template>
                            <xsl:if test="position()!=last()">
                                <xsl:element name="br"/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                        Sex
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                        <xsl:value-of select="$patientSex"/>
                    </xsl:element>
                </xsl:element> <!-- </tr> -->
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                        Date of Birth
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                        <xsl:value-of select="$patientDateOfBirth"/> (<xsl:value-of select="$patientAge"/>)
                    </xsl:element>
                </xsl:element> <!-- </tr> -->
                <xsl:if test="$patientDeceasedStatus='true'">
                    <xsl:element name="tr">
                        <xsl:element name="th">
                            <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                            Status
                        </xsl:element> <!-- </th> -->
                        <xsl:element name="td">
                            <xsl:attribute name="class">sidevalue</xsl:attribute>
                            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>DECEASED</xsl:element>
                        </xsl:element>
                    </xsl:element>
                    <xsl:if test="string-length($deceasedTime) &gt; 0">
                        <xsl:element name="tr">
                            <xsl:element name="th">
                                <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                Deceased Time
                            </xsl:element> <!-- </th> -->
                            <xsl:element name="td">
                                <xsl:attribute name="class">sidevalue</xsl:attribute>
                                <xsl:value-of select="$deceasedTime"/>
                            </xsl:element>
                        </xsl:element> <!-- </tr> -->
                    </xsl:if>
                </xsl:if>
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                        IHI
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$patientIHI and
                                            string-length($patientIHI) &gt; 0">
                                <xsl:value-of select="$patientIHI"/>
                            </xsl:when>
                            <xsl:otherwise>Not Provided</xsl:otherwise>
                        </xsl:choose>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                <xsl:for-each select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/ext:asEntityIdentifier[@classCode='IDENT' and ext:id[@assigningAuthorityName!='IHI']]">
                    <xsl:if test="./ext:id and
                                  ./ext:id/@root and
                                  string-length(./ext:id/@root) &gt; 0 and
                                  not(./ext:id/@displable='false') and
                                  ./ext:code and
                                  ./ext:code/@code and
                                  string-length(./ext:code/@code) &gt; 0 and
                                  ./ext:code/@codeSystem='2.16.840.1.113883.12.203'">
                        <xsl:variable name="identifier">
                            <xsl:choose>
                                <xsl:when test="./ext:id/@extension and
                                    string-length(./ext:id/@extension) &gt; 0">
                                    <xsl:value-of select="./ext:id/@extension"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="substring-after-last-occurance">
                                        <xsl:with-param name="string" select="./ext:id/@root"/>
                                        <xsl:with-param name="argument">.</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        <xsl:variable name="identifierType">
                            <xsl:call-template name="getHL7V2Table0203IdentifierCodeDescription">
                                <xsl:with-param name="code" select="./ext:code/@code"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:variable name="identifierAssigningAuthorityName">
                            <xsl:if test="./ext:id/@assigningAuthorityName and
                                string-length(./ext:id/@assigningAuthorityName) &gt; 0">
                                <xsl:value-of select="./ext:id/@assigningAuthorityName"/>
                            </xsl:if>
                        </xsl:variable>
                        <xsl:element name="tr">
                            <xsl:element name="th">
                                <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                                <xsl:choose>
                                    <xsl:when test="position()=1">
                                        <xsl:text>Local Identifiers</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise/>
                                </xsl:choose>
                            </xsl:element> <!-- </th> -->
                            <xsl:element name="td">
                                <xsl:attribute name="class">sidevalue</xsl:attribute>
                                <xsl:value-of select="$identifier"/>
                                <xsl:choose>
                                    <xsl:when test="$identifierAssigningAuthorityName and 
                                        string-length($identifierAssigningAuthorityName) &gt; 0">
                                        <xsl:text> (</xsl:text><xsl:value-of select="$identifierAssigningAuthorityName"/><xsl:text>)</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="$identifierType and 
                                        string-length($identifierType) &gt; 0">
                                        <xsl:text> (</xsl:text><xsl:value-of select="$identifierType"/><xsl:text>)</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text> (Local Identifier)</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:element> <!-- </td> -->
                        </xsl:element> <!-- </tr> -->
                    </xsl:if>
                </xsl:for-each>
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                        Address
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="count(/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr) &gt; 0">
                                <xsl:element name="dl">
                                    <xsl:attribute name="class">addressdl</xsl:attribute>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr">
                                        <xsl:call-template name="show-address">
                                            <xsl:with-param name="address" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>Not Provided</xsl:otherwise>
                        </xsl:choose>
                    </xsl:element>
                </xsl:element>
                <xsl:element name="tr">                    
                    <xsl:element name="th">
                        <xsl:attribute name="class">sidevaluenames</xsl:attribute>
                        Contact
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">sidevalue</xsl:attribute>
                        <xsl:call-template name="getContactDetails">
                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:recordTarget/cda:patientRole"/>
                        </xsl:call-template>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
        <xsl:call-template name="getHalfHorizontalSpacer"/>
    </xsl:template>

    <xsl:template name="getDocumentMetadataTable">
        <xsl:variable name="documentId">
            <xsl:call-template name="getIdentifierFromII">
                <xsl:with-param name="iiVariable" select="/cda:ClinicalDocument/cda:id"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="documentSetId">
            <xsl:call-template name="getIdentifierFromII">
                <xsl:with-param name="iiVariable" select="/cda:ClinicalDocument/cda:setId"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="documentVersion" select="cda:versionNumber/@value"/>
        
        <xsl:variable name="completionCode">
            <xsl:if test="/cda:ClinicalDocument/ext:completionCode and
                /cda:ClinicalDocument/ext:completionCode/@codeSystem and
                /cda:ClinicalDocument/ext:completionCode/@codeSystem='1.2.36.1.2001.1001.101.104.20104' and
                /cda:ClinicalDocument/ext:completionCode/@code and
                string-length(/cda:ClinicalDocument/ext:completionCode/@code) &gt; 0">
                <xsl:choose>
                    <xsl:when test="/cda:ClinicalDocument/ext:completionCode/@code='F'">Final</xsl:when>
                    <xsl:when test="/cda:ClinicalDocument/ext:completionCode/@code='I'">Interim</xsl:when>
                    <xsl:when test="/cda:ClinicalDocument/ext:completionCode/@code='W'">Withdrawn</xsl:when>
                    <xsl:otherwise/>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="creationTime">
            <xsl:call-template name="show-time">
                <xsl:with-param name="datetime" select="cda:effectiveTime"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="dateTimeAttested">
            <xsl:call-template name="show-time">
                <xsl:with-param name="datetime" select="/cda:ClinicalDocument/cda:legalAuthenticator/cda:time"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="replacementStatus">
            <xsl:if test="/cda:ClinicalDocument/cda:relatedDocument[@typeCode='RPLC'] and
                /cda:ClinicalDocument/cda:relatedDocument[@typeCode='RPLC']/cda:parentDocument/cda:id and
                /cda:ClinicalDocument/cda:relatedDocument[@typeCode='RPLC']/cda:parentDocument/cda:id/@root and
                string-length(/cda:ClinicalDocument/cda:relatedDocument[@typeCode='RPLC']/cda:parentDocument/cda:id/@root) &gt; 0">
                <xsl:text>Replaces Document ID: </xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="table">
            <xsl:attribute name="class">halfPageWidth</xsl:attribute>
            <xsl:attribute name="style">page-break-inside: avoid;
                table-layout: fixed;
                word-wrap: break-word;</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="summary">Document Metadata</xsl:attribute>
            <xsl:element name="tbody">
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Document Type
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$cdaDocumentType and
                                string-length($cdaDocumentType) &gt; 0">
                                <xsl:value-of select="$cdaDocumentType"/>
                            </xsl:when>
                            <xsl:otherwise>
                                Not Provided
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:element>
                </xsl:element> <!-- </tr> -->
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Creation Date/Time
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$creationTime and
                                string-length($creationTime) &gt; 0">
                                <xsl:value-of select="$creationTime"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>Not Provided</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Date/Time Attested
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$dateTimeAttested and
                                string-length($dateTimeAttested) &gt; 0">
                                <xsl:value-of select="$dateTimeAttested"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>Not Provided</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Document ID
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$documentId and
                                string-length($documentId) &gt; 0">
                                <xsl:value-of select="$documentId"/>
                            </xsl:when>
                            <xsl:otherwise>
                                Not Provided
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                <xsl:if test="$documentSetId and
                              string-length($documentSetId) &gt; 0">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                            <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                        </xsl:element>
                        <xsl:element name="th">
                            <xsl:attribute name="class">summarydetails</xsl:attribute>
                            Document Set ID
                        </xsl:element> <!-- </th> -->
                        <xsl:element name="td">
                            <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                                <xsl:value-of select="$documentSetId"/>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
                <xsl:if test="$documentVersion and
                    string-length($documentVersion) &gt; 0">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                            <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                        </xsl:element>
                        <xsl:element name="th">
                            <xsl:attribute name="class">summarydetails</xsl:attribute>
                            Document Version
                        </xsl:element> <!-- </th> -->
                        <xsl:element name="td">
                            <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                            <xsl:value-of select="$documentVersion"/>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
                <xsl:if test="$completionCode and
                              string-length($completionCode) &gt; 0">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                            <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                        </xsl:element>
                        <xsl:element name="th">
                            <xsl:attribute name="class">summarydetails</xsl:attribute>
                            Completion Code
                        </xsl:element> <!-- </th> -->
                        <xsl:element name="td">
                            <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                                <xsl:choose>
                                    <xsl:when test="$completionCode='Withdrawn'">
                                        <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>WITHDRAWN</xsl:element>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$completionCode"/>                                        
                                    </xsl:otherwise>
                                </xsl:choose>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
                <xsl:if test="starts-with($replacementStatus, 'Replaces Document ID')">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                            <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                        </xsl:element>
                        <xsl:element name="th">
                            <xsl:attribute name="class">summarydetails</xsl:attribute>
                            Replacement Status
                        </xsl:element> <!-- </th> -->
                        <xsl:element name="td">
                            <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                            <xsl:value-of select="$replacementStatus"/>
                            <xsl:element name="br"/><xsl:value-of select="/cda:ClinicalDocument/cda:relatedDocument[@typeCode='RPLC']/cda:parentDocument/cda:id/@root"/>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
    </xsl:template>
    
    <xsl:template name="getDocumentAuthorDetailsTable">
        <xsl:element name="table">
            <xsl:attribute name="class">halfPageWidth</xsl:attribute>
            <xsl:attribute name="style">page-break-inside: avoid;
                table-layout: fixed;
                word-wrap: break-word;</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:attribute name="summary">Document Author Details</xsl:attribute>
            <xsl:element name="tbody">
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Author
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:for-each select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/cda:name">
                            <xsl:if test="position() > 1">
                                <xsl:value-of select="$AKA_STRING"/>
                            </xsl:if>
                            <xsl:call-template name="show-name">
                                <xsl:with-param name="name" select="."/>
                            </xsl:call-template>
                            <xsl:if test="position()!=last()">
                                <xsl:element name="br"/>
                            </xsl:if>
                        </xsl:for-each>
                        <xsl:if test="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:code/@displayName and
                                      string-length(/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:code/@displayName) &gt; 0">
                            <xsl:text> (</xsl:text><xsl:value-of select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:code/@displayName"/><xsl:text>)</xsl:text>
                            <xsl:element name="br"/>
                        </xsl:if>
                        <xsl:for-each select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEntityIdentifier">
                            <xsl:call-template name="getProviderIndividualIdentifier">
                                <xsl:with-param name="entityIdentifier" select="."/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Author Contact
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:call-template name="getContactDetails">
                            <xsl:with-param name="personOrOrg" select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor"/>
                        </xsl:call-template>                        
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Author Address
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="count(/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr) &gt; 0">
                                <xsl:element name="dl">
                                    <xsl:attribute name="class">addressdl</xsl:attribute>
                                    <xsl:for-each select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:addr">
                                        <xsl:call-template name="show-address">
                                            <xsl:with-param name="address" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>Not Provided</xsl:otherwise>
                        </xsl:choose>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                
                <xsl:element name="tr">
                    <xsl:element name="td">
                        <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                        <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                    </xsl:element>
                    <xsl:element name="th">
                        <xsl:attribute name="class">summarydetails</xsl:attribute>
                        Author Organisation
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="td">
                        <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization">
                                <xsl:for-each select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization">
                                    <xsl:if test="string-length(./cda:asOrganizationPartOf/cda:wholeOrganization/cda:name) &gt; 0">
                                        <xsl:value-of select="./cda:asOrganizationPartOf/cda:wholeOrganization/cda:name"/><xsl:element name="br"/>
                                    </xsl:if>
                                    <xsl:for-each select="./cda:asOrganizationPartOf/cda:wholeOrganization/ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderOrganisationIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>Not Provided</xsl:otherwise>
                        </xsl:choose>
                    </xsl:element> <!-- </td> -->
                </xsl:element> <!-- </tr> -->
                <xsl:if test="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization and
                    string-length(/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization/cda:name) &gt; 0">
                    
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="class">summaryDetailsLeftGap</xsl:attribute>
                            <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
                        </xsl:element>
                        <xsl:element name="th">
                            <xsl:attribute name="class">summarydetails</xsl:attribute>
                            Author Department
                        </xsl:element> <!-- </th> -->
                        <xsl:element name="td">
                            <xsl:attribute name="class">documentdetailsvalues</xsl:attribute>
                                <xsl:for-each select="/cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/ext:asEmployment/ext:employerOrganization">
                                    <xsl:if test="string-length(./cda:name) &gt; 0">
                                        <xsl:value-of select="./cda:name"/><xsl:element name="br"/>
                                    </xsl:if>
                                    <xsl:for-each select="./ext:asEntityIdentifier">
                                        <xsl:call-template name="getProviderOrganisationIdentifier">
                                            <xsl:with-param name="entityIdentifier" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:for-each>
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:if>
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
    </xsl:template>
   
    <xsl:template name="getRecipientsTable">
        <xsl:param name="recipients"/>
        <xsl:param name="title"/>
        <xsl:param name="tableId"/>
        <xsl:element name="table">
            <xsl:attribute name="id"><xsl:value-of select="$tableId"/></xsl:attribute>
            <xsl:attribute name="class">RECIPIENTS_TABLE_CLASS</xsl:attribute>
            <xsl:attribute name="summary"><xsl:value-of select="$title"/></xsl:attribute>
            <xsl:attribute name="style">page-break-inside: avoid;
                table-layout: fixed;
                word-wrap: break-word;</xsl:attribute>
            <xsl:element name="colgroup">
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
            </xsl:element>
            <xsl:element name="thead">
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sectionheader</xsl:attribute>
                        <xsl:attribute name="colspan">5</xsl:attribute>
                        <xsl:value-of select="$title"/>
                    </xsl:element> <!-- </th> -->
                </xsl:element>
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Name
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Occupation/Qualifications
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Organisation
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Address
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_RIGHT_CELL_CLASS</xsl:attribute>
                        Contact
                    </xsl:element> <!-- </th> -->
                </xsl:element> <!-- </tr> -->
            </xsl:element> <!-- </thead> -->
            
            <xsl:element name="tbody">
                <xsl:for-each select="$recipients">                    
                    <xsl:call-template name="getRecipientsTableBodyRow"/>
                </xsl:for-each>
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
    </xsl:template>
    
    <xsl:template name="getRecipientsTableBodyRow">
        <xsl:variable name="recipientOccupation">
            <xsl:choose>
                <xsl:when test="./cda:informationRecipient/ext:asEmployment/ext:jobCode/@displayName and
                    string-length(./cda:informationRecipient/ext:asEmployment/ext:jobCode/@displayName) &gt; 0">
                    <xsl:value-of select="./cda:informationRecipient/ext:asEmployment/ext:jobCode/@displayName"/>
                </xsl:when>
                <xsl:when test="./cda:informationRecipient/ext:asEmployment/ext:jobCode/cda:originalText and
                    string-length(./cda:informationRecipient/ext:asEmployment/ext:jobCode/cda:originalText) &gt; 0">
                    <xsl:value-of select="./cda:informationRecipient/ext:asEmployment/ext:jobCode/cda:originalText"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="recipientQualifications">
            <xsl:choose>
                <xsl:when test="./cda:informationRecipient/ext:asQualifications/ext:code and
                    string-length(./cda:informationRecipient/ext:asQualifications/ext:code/@displayName) &gt; 0">
                    <xsl:value-of select="./cda:informationRecipient/ext:asQualifications/ext:code/@displayName"/>
                </xsl:when>
                <xsl:when test="./cda:informationRecipient/ext:asQualifications/ext:code/cda:originalText and
                    string-length(./cda:informationRecipient/ext:asQualifications/ext:code/cda:originalText) &gt; 0">
                    <xsl:value-of select="./cda:informationRecipient/ext:asQualifications/ext:code/cda:originalText"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="tr">
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:for-each select="./cda:informationRecipient/cda:name">
                    <xsl:if test="position() > 1">
                        <xsl:value-of select="$AKA_STRING"/>
                    </xsl:if>
                    <xsl:call-template name="show-name">
                        <xsl:with-param name="name" select="."/>
                    </xsl:call-template>
                    <xsl:element name="br"/>
                </xsl:for-each>
                <xsl:for-each select="./cda:informationRecipient/ext:asEntityIdentifier">
                    <xsl:call-template name="getProviderIndividualIdentifier">
                        <xsl:with-param name="entityIdentifier" select="."/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:element> <!-- </td> -->
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:choose>
                    <xsl:when test="string-length($recipientOccupation) &gt; 0 or
                                    string-length($recipientQualifications) &gt; 0">
                        <xsl:if test="string-length($recipientOccupation) &gt; 0">
                            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>Occupation:</xsl:element><xsl:element name="br"/><xsl:value-of select="$recipientOccupation"/>
                            <xsl:element name="br"/>
                        </xsl:if>
                        <xsl:if test="string-length($recipientQualifications) &gt; 0">
                            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>Qualifications:</xsl:element><xsl:element name="br"/><xsl:value-of select="$recipientQualifications"/>
                            <xsl:element name="br"/>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>Not Provided</xsl:otherwise>
                </xsl:choose>
            </xsl:element> <!-- </td> -->
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:for-each select="./cda:receivedOrganization">
                    <xsl:for-each select="./cda:name">
                        <xsl:if test="string-length(.) &gt; 0">
                            <xsl:if test="position() > 1">
                                <xsl:value-of select="$AKA_STRING"/>
                            </xsl:if>
                            <xsl:value-of select="."/><xsl:element name="br"/>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:for-each select="./ext:asEntityIdentifier">
                        <xsl:call-template name="getProviderOrganisationIdentifier">
                            <xsl:with-param name="entityIdentifier" select="."/>
                        </xsl:call-template>
                    </xsl:for-each>
                    <xsl:element name="br"/>
                </xsl:for-each>
            </xsl:element> <!-- </td> -->
            
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:if test="count(./cda:addr) &gt; 0">
                    <xsl:element name="dl">
                        <xsl:attribute name="class">addressdl</xsl:attribute>
                        <xsl:for-each select="./cda:addr">
                            <xsl:call-template name="show-address">
                                <xsl:with-param name="address" select="."/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:element> <!-- </dl> -->
                </xsl:if>
            </xsl:element> <!-- </td> -->
            
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:call-template name="getContactDetails">
                    <xsl:with-param name="personOrOrg" select="."/>
                </xsl:call-template>
            </xsl:element> <!-- </td> -->
        </xsl:element> <!-- </tr> -->
    </xsl:template>

    <xsl:template name="getParticipantsTable">
        <xsl:param name="participants"/>
        <xsl:param name="title"></xsl:param>
        <xsl:param name="tableId"></xsl:param>
        <xsl:element name="table">
            <xsl:attribute name="id"><xsl:value-of select="$tableId"/></xsl:attribute>
            <xsl:attribute name="class">RECIPIENTS_TABLE_CLASS</xsl:attribute>
            <xsl:attribute name="summary"><xsl:value-of select="$title"/></xsl:attribute>
            <xsl:attribute name="style">page-break-inside: avoid;
                table-layout: fixed;
                word-wrap: break-word;</xsl:attribute>
            <xsl:element name="colgroup">
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
                <xsl:element name="col">
                    <xsl:attribute name="style">width: <xsl:value-of select="$FIFTH_CONTENT_WIDTH"/>px;</xsl:attribute>
                </xsl:element> <!-- </col> -->
            </xsl:element>
            <xsl:element name="thead">
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">sectionheader</xsl:attribute>
                        <xsl:attribute name="colspan">5</xsl:attribute>
                        <xsl:value-of select="$title"/>
                    </xsl:element> <!-- </th> -->
                </xsl:element>
                <xsl:element name="tr">
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Name
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Occupation/Qualifications
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Organisation
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS</xsl:attribute>
                        Address
                    </xsl:element> <!-- </th> -->
                    <xsl:element name="th">
                        <xsl:attribute name="class">RECIPIENTS_TABLE_HEADER_RIGHT_CELL_CLASS</xsl:attribute>
                        Contact
                    </xsl:element> <!-- </th> -->
                </xsl:element> <!-- </tr> -->
            </xsl:element> <!-- </thead> -->
            
            <xsl:element name="tbody">
                <xsl:for-each select="$participants">                    
                    <xsl:call-template name="getParticipantsTableBodyRow"/>
                </xsl:for-each>
            </xsl:element> <!-- </tbody> -->
        </xsl:element> <!-- </table> -->
    </xsl:template>
    
    <xsl:template name="getParticipantsTableBodyRow">
        <xsl:variable name="participantOccupation">
            <xsl:choose>
                <xsl:when test="./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:jobCode/@displayName and
                    string-length(./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:jobCode/@displayName) &gt; 0">
                    <xsl:value-of select="./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:jobCode/@displayName"/>
                </xsl:when>
                <xsl:when test="./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:jobCode/cda:originalText and
                    string-length(./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:jobCode/cda:originalText) &gt; 0">
                    <xsl:value-of select="./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:jobCode/cda:originalText"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="participantQualifications">
            <xsl:choose>
                <xsl:when test="./cda:associatedEntity/cda:associatedPerson/ext:asQualifications/ext:code and
                    string-length(./cda:associatedEntity/cda:associatedPerson/ext:asQualifications/ext:code/@displayName) &gt; 0">
                    <xsl:value-of select="./cda:associatedEntity/cda:associatedPerson/ext:asQualifications/ext:code/@displayName"/>
                </xsl:when>
                <xsl:when test="./cda:associatedEntity/cda:associatedPerson/ext:asQualifications/ext:code/cda:originalText and
                    string-length(./cda:associatedEntity/cda:associatedPerson/ext:asQualifications/ext:code/cda:originalText) &gt; 0">
                    <xsl:value-of select="./cda:associatedEntity/cda:associatedPerson/ext:asQualifications/ext:code/cda:originalText"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="tr">
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:for-each select="./cda:associatedEntity/cda:associatedPerson/cda:name">
                    <xsl:if test="position() > 1">
                        <xsl:value-of select="$AKA_STRING"/>
                    </xsl:if>
                    <xsl:call-template name="show-name">
                        <xsl:with-param name="name" select="."/>
                    </xsl:call-template>
                    <xsl:element name="br"/>
                </xsl:for-each>
                <xsl:for-each select="./cda:associatedEntity/cda:associatedPerson/ext:asEntityIdentifier">
                    <xsl:call-template name="getProviderIndividualIdentifier">
                        <xsl:with-param name="entityIdentifier" select="."/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:element> <!-- </td> -->
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:choose>
                    <xsl:when test="string-length($participantOccupation) &gt; 0 or
                        string-length($participantOccupation) &gt; 0">
                        <xsl:if test="string-length($participantOccupation) &gt; 0">
                            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>Occupation:</xsl:element><xsl:element name="br"/><xsl:value-of select="$participantOccupation"/>
                            <xsl:element name="br"/>
                        </xsl:if>
                        <xsl:if test="string-length($participantQualifications) &gt; 0">
                            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>Qualifications:</xsl:element><xsl:element name="br"/><xsl:value-of select="$participantQualifications"/>
                            <xsl:element name="br"/>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>Not Provided</xsl:otherwise>
                </xsl:choose>
            </xsl:element> <!-- </td> -->
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:for-each select="./cda:associatedEntity/cda:associatedPerson/ext:asEmployment/ext:employerOrganization/cda:asOrganizationPartOf/cda:wholeOrganization">
                    <xsl:for-each select="./cda:name">
                        <xsl:if test="string-length(.) &gt; 0">
                            <xsl:if test="position() > 1">
                                <xsl:value-of select="$AKA_STRING"/>
                            </xsl:if>
                            <xsl:value-of select="."/><xsl:element name="br"/>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:for-each select="./ext:asEntityIdentifier">
                        <xsl:call-template name="getProviderOrganisationIdentifier">
                            <xsl:with-param name="entityIdentifier" select="."/>
                        </xsl:call-template>
                    </xsl:for-each>
                    <xsl:element name="br"/>
                </xsl:for-each>
            </xsl:element> <!-- </td> -->
            
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:if test="count(./cda:associatedEntity/cda:addr) &gt; 0">
                    <xsl:element name="dl">
                        <xsl:attribute name="class">addressdl</xsl:attribute>
                        <xsl:for-each select="./cda:associatedEntity/cda:addr">
                            <xsl:call-template name="show-address">
                                <xsl:with-param name="address" select="."/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:element> <!-- </dl> -->
                </xsl:if>
            </xsl:element> <!-- </td> -->
            
            <xsl:element name="td">
                <xsl:attribute name="class">RECIPIENTS_TABLE_BODY_RIGHT_CELL_CLASS</xsl:attribute>
                <xsl:call-template name="getContactDetails">
                    <xsl:with-param name="personOrOrg" select="./cda:associatedEntity"/>
                </xsl:call-template>
            </xsl:element> <!-- </td> -->
        </xsl:element> <!-- </tr> -->
    </xsl:template>

    <!--================================================================================================================================================================================-->
    <!-- [END] DETAILS TEMPLATES -->
    



    <!-- CDA BODY TEMPLATES -->
    <!--================================================================================================================================================================================-->
    
    <xsl:template match="cda:component/cda:structuredBody">
        <xsl:for-each select="cda:component/cda:section">
            <xsl:call-template name="section"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="cda:component/cda:nonXMLBody">
        <xsl:call-template name="processAttachment">
            <xsl:with-param name="element" select="."/>
        </xsl:call-template>
        <xsl:call-template name="getHorizontalSpacer"/>
    </xsl:template>
        
    <!--================================================================================================================================================================================-->
    <!-- [END] CDA BODY TEMPLATES -->




    <!-- CDA SECTION TEMPLATES -->
    <!--================================================================================================================================================================================-->

    <xsl:template name="section">
        <xsl:if test="cda:title">
            <xsl:call-template name="section-title">
                <xsl:with-param name="title" select="cda:title"/>
                <xsl:with-param name="sectionId" select="./@ID"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:call-template name="section-text"/>
        <xsl:for-each select="cda:component/cda:section">
            <xsl:call-template name="nestedSection"/>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="getSectionPath">
        <xsl:param name="section"/>
        <xsl:param name="previousSectionTitle"/>
        <xsl:choose>
            <xsl:when test="$section/../../../cda:section">
                <xsl:call-template name="getSectionPath">
                    <xsl:with-param name="section" select="$section/../../../cda:section"/>
                    <xsl:with-param name="previousSectionTitle">
                        <xsl:choose>
                            <xsl:when test="$previousSectionTitle">
                                <xsl:choose>
                                    <xsl:when test="$section/cda:title and
                                        string-length($section/cda:title) &gt; 0">
                                        <xsl:value-of select="concat($section/cda:title, $SECTION_TITLE_NAVIGATION_SEPARATOR, $previousSectionTitle)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="concat('Unlabeled Section', $SECTION_TITLE_NAVIGATION_SEPARATOR, $previousSectionTitle)"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
                                    <xsl:when test="$section/cda:title and
                                        string-length($section/cda:title) &gt; 0">
                                        <xsl:value-of select="$section/cda:title"/>                                           
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>Unlabeled Section</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$section/cda:title and
                        string-length($section/cda:title) &gt; 0">
                        <xsl:value-of select="concat($section/cda:title, $SECTION_TITLE_NAVIGATION_SEPARATOR, $previousSectionTitle)"/>                       
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat('Unlabeled Section', $SECTION_TITLE_NAVIGATION_SEPARATOR, $previousSectionTitle)"/>                       
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>    
    
    <xsl:template name="section-title">
        <xsl:param name="title"/>
        <xsl:param name="sectionId"/>
        <xsl:choose>
            <xsl:when test="contains($title, $SECTION_TITLE_NAVIGATION_SEPARATOR)">
                <xsl:variable name="actualSectionTitle">
                    <xsl:call-template name="substring-after-last-occurance">
                        <xsl:with-param name="string" select="$title"/>
                        <xsl:with-param name="argument" select="$SECTION_TITLE_NAVIGATION_SEPARATOR"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:variable name="leadIn">
                    <xsl:value-of select="concat(substring-before($title, concat($SECTION_TITLE_NAVIGATION_SEPARATOR, $actualSectionTitle)), $SECTION_TITLE_NAVIGATION_SEPARATOR)"/>
                </xsl:variable>
                    <xsl:element name="h2">
                        <xsl:if test="$sectionId and
                            string-length($sectionId) &gt; 0">
                            <xsl:attribute name="id"><xsl:value-of select="$sectionId"/></xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="class">sectiontitleheader sectiontitleheading2</xsl:attribute>
                        <xsl:value-of select="$actualSectionTitle"/><span style="font-weight: normal; font-size: 9px;"><xsl:text> (</xsl:text><xsl:value-of select="$leadIn"/><span style="font-weight: bold;"><xsl:value-of select="$actualSectionTitle"/></span><xsl:text>)</xsl:text></span>
                    </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                    <xsl:element name="h2">
                        <xsl:if test="$sectionId and
                            string-length($sectionId) &gt; 0">
                            <xsl:attribute name="id"><xsl:value-of select="$sectionId"/></xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="class">sectiontitleheader sectiontitleheading2</xsl:attribute>
                        <xsl:value-of select="$title"/>
                    </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="section-text">
        <xsl:element name="div">
            <xsl:attribute name="class">pageWidth</xsl:attribute>
            <xsl:apply-templates select="cda:text"/>
        </xsl:element>
        <xsl:if test="cda:text or cda:title">
            <xsl:call-template name="getHorizontalSpacer"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="nestedSection">
        <xsl:call-template name="section-title">
            <xsl:with-param name="title">
                <xsl:call-template name="getSectionPath">
                    <xsl:with-param name="section" select="."/>
                    <xsl:with-param name="sectionId" select="./@ID"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:apply-templates select="cda:text"/>
        <xsl:for-each select="cda:component/cda:section">
            <xsl:call-template name="nestedSection"/>
        </xsl:for-each>
    </xsl:template>
    
    <!--================================================================================================================================================================================-->
    <!-- [END] CDA SECTION TEMPLATES -->


    

    <!-- CDA NARRATIVE ELEMENT TEMPLATES -->    
    <!--================================================================================================================================================================================-->
    
    <xsl:template match="cda:footnote">
        <xsl:variable name="footnote-num">
            <xsl:number level="any" count="cda:footnote"/>
        </xsl:variable>
        <xsl:element name="sup">
            <xsl:element name="a">
                <xsl:attribute name="href">#F_footnote-<xsl:value-of select="$footnote-num"/></xsl:attribute>
                <xsl:attribute name="title">initialfootnote</xsl:attribute>
                <xsl:value-of select="$footnote-num"/>
            </xsl:element> <!-- </a> -->
        </xsl:element> <!-- </sup> -->
    </xsl:template>
    
    <xsl:template match="cda:footnote" mode="footnote">
        <xsl:variable name="footnote-num">
            <xsl:number level="any" count="cda:footnote"/>
        </xsl:variable>
        <xsl:element name="p">
            <xsl:attribute name="ID">F_footnote-<xsl:value-of select="$footnote-num"/></xsl:attribute>
            <xsl:element name="span"><xsl:attribute name="style">font-weight: bold;</xsl:attribute>
                <xsl:if test="./@ID">
                    <xsl:attribute name="ID">
                        <xsl:value-of select="./@ID"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:text>[</xsl:text><xsl:value-of select="$footnote-num"/><xsl:text>] </xsl:text>
            </xsl:element> <!-- </b> -->
            <xsl:apply-templates select="*|text()"/>
        </xsl:element> <!-- </p> -->
    </xsl:template>
    
    <xsl:template match="cda:footnoteRef">
        <xsl:variable name="theFootnote" select="//cda:footnote[@ID=current()/@IDREF]"/>
        <xsl:variable name="footnote-num">
            <xsl:for-each select="$theFootnote">
                <xsl:number level="any" count="cda:footnote"/>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="footnote-refnum">
            <xsl:for-each select=".">
                <xsl:number level="any" count="cda:footnoteRef"/>
            </xsl:for-each>
        </xsl:variable>
        <xsl:element name="sup">
            <xsl:element name="a">
                <xsl:attribute name="href">#<xsl:value-of select="@IDREF"/></xsl:attribute>
                <xsl:attribute name="title">ref#<xsl:value-of select="$footnote-refnum"/></xsl:attribute>
                <xsl:value-of select="$footnote-num"/>
            </xsl:element> <!-- </a> -->
        </xsl:element> <!-- </sup> -->
    </xsl:template>

    <xsl:template match="cda:linkHtml">
        <xsl:if test="string-length(./text()) &gt; 0 and
            string-length(./@href) &gt; 0">
            <xsl:element name="a">
                <xsl:attribute name="href"><xsl:value-of select="./@href"/></xsl:attribute>
                <xsl:value-of select="./text()"/>            
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="cda:content">
        <xsl:element name="span">
            <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
            <xsl:choose>
                <xsl:when test="@styleCode">
                    <xsl:call-template name="processStyleCode">
                        <xsl:with-param name="code" select="@styleCode"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element> <!-- </span> -->
    </xsl:template>

    <xsl:template match="cda:br">
        <xsl:element name="br">
           <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
           <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="cda:list">
      <xsl:choose>
         <xsl:when test="@styleCode">
            <xsl:choose>
               <xsl:when test="@styleCode='Disc'">
                  <xsl:element name="ul">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: disc;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                        <xsl:choose>
                           <xsl:when test="@styleCode">
                              <xsl:call-template name="processStyleCode">
                                 <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                 <xsl:with-param name="code" select="@styleCode"/>
                              </xsl:call-template>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:apply-templates/>
                           </xsl:otherwise>
                        </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:when test="@styleCode='Circle'">
                  <xsl:element name="ul">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: circle;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:when test="@styleCode='Square'">
                  <xsl:element name="ul">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: square;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:otherwise>
                  <ul>
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </ul>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:when>
         <xsl:otherwise>
            <ul>
               <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
               <xsl:for-each select="cda:item">
                  <li>
                     <xsl:apply-templates/>
                  </li>
               </xsl:for-each>
            </ul>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   
    <xsl:template match="cda:list[@listType='ordered']">
      <xsl:choose>
         <xsl:when test="@styleCode">
            <xsl:choose>
               <xsl:when test="@styleCode='LittleRoman'">
                  <xsl:element name="ol">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: lower-roman;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:when test="@styleCode='BigRoman'">
                  <xsl:element name="ol">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: upper-roman;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:when test="@styleCode='LittleAlpha'">
                  <xsl:element name="ol">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: lower-alpha;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:when test="@styleCode='BigAlpha'">
                  <xsl:element name="ol">
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:attribute name="style">list-style-type: upper-alpha;</xsl:attribute>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </xsl:element>
               </xsl:when>

               <xsl:otherwise>
                  <ol>
                     <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
                     <xsl:for-each select="cda:item">
                        <li>
                           <xsl:choose>
                              <xsl:when test="@styleCode">
                                 <xsl:call-template name="processStyleCode">
                                    <xsl:with-param name="initialCssClasses"></xsl:with-param>
                                    <xsl:with-param name="code" select="@styleCode"/>
                                 </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:apply-templates/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </li>
                     </xsl:for-each>
                  </ol>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:when>
         <xsl:otherwise>
            <ol>
               <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
               <xsl:for-each select="cda:item">
                  <li>
                     <xsl:choose>
                        <xsl:when test="@styleCode">
                           <xsl:call-template name="processStyleCode">
                              <xsl:with-param name="initialCssClasses"></xsl:with-param>
                              <xsl:with-param name="code" select="@styleCode"/>
                           </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:apply-templates/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </li>
               </xsl:for-each>
            </ol>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

    <xsl:template match="cda:caption"/>
   
    <xsl:template match="cda:table">
        <xsl:choose>
            <xsl:when test="cda:caption and
                            string-length(cda:caption) &gt; 0">
                <xsl:element name="table">
                    <xsl:attribute name="class">generictable</xsl:attribute>
                    <xsl:call-template name="addID">
                        <xsl:with-param name="element" select="."/>
                    </xsl:call-template>
                    
                    <xsl:attribute name="summary">GENERIC TABLE</xsl:attribute>
                    <xsl:element name="caption">
                        <xsl:attribute name="class">tableCaption</xsl:attribute>
                        <xsl:value-of select="cda:caption"/>
                    </xsl:element>
                    <xsl:apply-templates/>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="table">
                    <xsl:attribute name="class">generictable</xsl:attribute>
                    <xsl:attribute name="summary">no summary</xsl:attribute>
                    <xsl:apply-templates/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="getHorizontalSpacer"/>
    </xsl:template>

    <xsl:template match="cda:thead">
        <xsl:element name="thead">
            <xsl:call-template name="addID">
                <xsl:with-param name="element" select="."/>
            </xsl:call-template>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:element> <!-- </thead> -->
    </xsl:template>
   
    <xsl:template match="cda:tbody">
        <xsl:element name="tbody">
            <xsl:call-template name="addID">
                <xsl:with-param name="element" select="."/>
            </xsl:call-template>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
   
    <xsl:template match="cda:tr">
       <xsl:element name="tr">
           <xsl:call-template name="addID">
               <xsl:with-param name="element" select="."/>
           </xsl:call-template>
           <xsl:copy-of select="@*"/>
           <xsl:apply-templates/>
       </xsl:element>
    </xsl:template>

    <xsl:template match="cda:th">
        <xsl:element name="th">
            <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
            <xsl:if test="./@colspan">
                <xsl:attribute name="colspan"><xsl:value-of select="./@colspan"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="./@rowspan">
                <xsl:attribute name="rowspan"><xsl:value-of select="./@rowspan"/></xsl:attribute>
            </xsl:if>
            <xsl:variable name="colWidthStyle">
                <xsl:choose>
                    <xsl:when test="./@styleCode and contains(./@styleCode, 'xColWidthPx')">
                        <xsl:call-template name="processColWidthPx">
                            <xsl:with-param name="code" select="./@styleCode"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise/>
                </xsl:choose>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="./@styleCode">
                    <xsl:choose>
                        <xsl:when test="contains(./@styleCode, 'rule') or contains(./@styleCode, 'Rule')">
                            <xsl:variable name="tableCellRuleCssClasses">
                                <xsl:call-template name="processTableCellStyleCode">
                                    <xsl:with-param name="code" select="./@styleCode"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:call-template name="processStyleCode">
                                <xsl:with-param name="initialCssClasses"><xsl:value-of select="$tableCellRuleCssClasses"/></xsl:with-param>
                                <xsl:with-param name="code" select="@styleCode"/>
                                <xsl:with-param name="initialStyles" select="$colWidthStyle"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="processStyleCode">
                                <xsl:with-param name="code" select="@styleCode"/>
                                <xsl:with-param name="initialCssClasses">borderedcolumnheadings</xsl:with-param>
                                <xsl:with-param name="initialStyles" select="$colWidthStyle"/>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">borderedcolumnheadings</xsl:attribute>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="cda:td">
       <xsl:element name="td">
         <xsl:call-template name="addID"><xsl:with-param name="element" select="."/></xsl:call-template>
         <xsl:if test="./@colspan">
             <xsl:attribute name="colspan"><xsl:value-of select="./@colspan"/></xsl:attribute>
         </xsl:if>
          <xsl:if test="./@rowspan">
              <xsl:attribute name="rowspan"><xsl:value-of select="./@rowspan"/></xsl:attribute>
          </xsl:if>
           <xsl:variable name="colWidthStyle">
               <xsl:choose>
                   <xsl:when test="./@styleCode and contains(./@styleCode, 'xColWidthPx')">
                       <xsl:call-template name="processColWidthPx">
                           <xsl:with-param name="code" select="./@styleCode"/>
                       </xsl:call-template>
                   </xsl:when>
                   <xsl:otherwise/>
               </xsl:choose>
           </xsl:variable>
           <xsl:choose>
            <xsl:when test="./@styleCode">
                <xsl:choose>
                    <xsl:when test="contains(./@styleCode, 'rule') or contains(./@styleCode, 'Rule')">
                        <xsl:variable name="tableCellRuleCssClasses">
                            <xsl:call-template name="processTableCellStyleCode">
                                <xsl:with-param name="code" select="./@styleCode"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:call-template name="processStyleCode">
                            <xsl:with-param name="initialCssClasses"><xsl:value-of select="$tableCellRuleCssClasses"/></xsl:with-param>
                                <xsl:with-param name="code" select="@styleCode"/>
                                <xsl:with-param name="initialStyles" select="$colWidthStyle"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                       <xsl:call-template name="processStyleCode">
                           <xsl:with-param name="code" select="@styleCode"/>
                           <xsl:with-param name="initialCssClasses">borderedcolumnheadingvalues</xsl:with-param>
                           <xsl:with-param name="initialStyles" select="$colWidthStyle"/>
                       </xsl:call-template>
                    </xsl:otherwise>
                 </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="class">borderedcolumnheadingvalues</xsl:attribute>
               <xsl:apply-templates/>
            </xsl:otherwise>
         </xsl:choose>
       </xsl:element>
    </xsl:template>

    <xsl:template match="cda:renderMultiMedia">
        <xsl:call-template name="processAttachment">
            <xsl:with-param name="element" select="."/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="cda:paragraph">
        <xsl:element name="p">
            <xsl:call-template name="addID">
                <xsl:with-param name="element" select="."/>
            </xsl:call-template>
            <xsl:attribute name="class">paragraph</xsl:attribute>
            <xsl:choose>
                <xsl:when test="@styleCode">
                    <xsl:call-template name="processStyleCode">
                        <xsl:with-param name="code" select="@styleCode"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element> <!-- </p> -->
    </xsl:template>
    
    <xsl:template match="cda:sup">
        <xsl:element name="sup">
            <xsl:call-template name="addID">
                <xsl:with-param name="element" select="."/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="cda:sub">
        <xsl:element name="sub">
            <xsl:call-template name="addID">
                <xsl:with-param name="element" select="."/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
   
    <!--================================================================================================================================================================================-->
    <!-- [END] CDA NARRATIVE ELEMENT TEMPLATES -->


 
 
    <!-- STYLE CODE TEMPLATES -->    
    <!--================================================================================================================================================================================-->

    <xsl:template name="processStyleCode">
        <xsl:param name="code"/>
        <xsl:param name="initialCssClasses"/>
        <xsl:param name="initialStyles"/>
        
        <!-- Styles -->
        <xsl:variable name="colourStyles">
            <xsl:choose>
                <xsl:when test="contains($code, 'xFgColour') or
                                contains($code, 'xBgColour')">
                    <xsl:call-template name="processColourStyleCode">
                        <xsl:with-param name="code" select="$code"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="fontSizePxStyle">
            <xsl:choose>
                <xsl:when test="contains($code, 'xFontSizePx')">
                    <xsl:call-template name="processFontSizePx">
                        <xsl:with-param name="code" select="$code"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="fontSizeEmStyle">
            <xsl:choose>
                <xsl:when test="contains($code, 'xFontSizeEm')">
                    <xsl:call-template name="processFontSizeEm">
                        <xsl:with-param name="code" select="$code"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:attribute name="style">
            <xsl:call-template name="trim">
                <xsl:with-param name="string"><xsl:value-of select="concat($initialStyles, ' ', $colourStyles, ' ', $fontSizePxStyle, ' ', $fontSizeEmStyle)"/></xsl:with-param>
            </xsl:call-template>
        </xsl:attribute>
        
        <!-- Classes -->
        <xsl:variable name="boldClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Bold')">
                    <xsl:text>bold</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="italicClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Italic')">
                    <xsl:text>italic</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="underlineClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Underline')">
                    <xsl:text>underline</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="emphasisClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Emphasis')">
                    <xsl:text>emphasis</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="xFixedClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'xFixed')">
                    <xsl:text>xFixed</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:attribute name="class">
            <xsl:call-template name="trim">
                <xsl:with-param name="string"><xsl:value-of select="concat($initialCssClasses, ' ', $boldClass, ' ', $italicClass, ' ', $underlineClass, ' ', $emphasisClass, ' ', $xFixedClass)"/></xsl:with-param>
            </xsl:call-template>
        </xsl:attribute>
        
        <!-- pre element -->
        <xsl:choose>
            <xsl:when test="contains($code, 'xPre')">
                <xsl:element name="pre">
                    <xsl:apply-templates/>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="processTableCellStyleCode">
        <xsl:param name="code"/>
        <xsl:param name="initialCssClasses"/>
        
        <!-- Classes -->
        <xsl:variable name="lRuleClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Lrule')">
                    <xsl:text>Lrule</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="rRuleClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Rrule')">
                    <xsl:text>Rrule</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="topruleClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Toprule')">
                    <xsl:text>toprule</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="botruleClass">
            <xsl:choose>
                <xsl:when test="contains($code, 'Botrule')">
                    <xsl:text>botrule</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="tableCellClasses">
            <xsl:if test="$initialCssClasses and string-length($initialCssClasses) &gt; 0">
                <xsl:value-of select="$initialCssClasses"/><xsl:text> </xsl:text>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="string-length($lRuleClass) &gt; 0">
                    <xsl:value-of select="$lRuleClass"/><xsl:text> </xsl:text>
                </xsl:when>
                <xsl:otherwise>noLrule </xsl:otherwise>
            </xsl:choose>
            
            <xsl:choose>
                <xsl:when test="string-length($rRuleClass) &gt; 0">
                    <xsl:value-of select="$rRuleClass"/><xsl:text> </xsl:text>
                </xsl:when>
                <xsl:otherwise>noRrule </xsl:otherwise>
            </xsl:choose>
            
            <xsl:choose>
                <xsl:when test="string-length($topruleClass) &gt; 0">
                    <xsl:value-of select="$topruleClass"/><xsl:text> </xsl:text>
                </xsl:when>
                <xsl:otherwise>noToprule </xsl:otherwise>
            </xsl:choose>
            
            <xsl:choose>
                <xsl:when test="string-length($botruleClass) &gt; 0">
                    <xsl:value-of select="$botruleClass"/><xsl:text> </xsl:text>
                </xsl:when>
                <xsl:otherwise>noBotrule </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="trim">
            <xsl:with-param name="string"><xsl:value-of select="$tableCellClasses"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="processColourStyleCode">
        <xsl:param name="code"/>
        
        <!-- Isolate xFgColour stylecode -->
        <xsl:variable name="fgColourStyleCodeStart" select="substring-after($code, 'xFgColour')"/>
        <xsl:variable name="fgColourHexCode">
            <xsl:choose>
                <xsl:when test="contains($fgColourStyleCodeStart, ' ')">
                    <xsl:value-of select="substring-before($fgColourStyleCodeStart, ' ')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$fgColourStyleCodeStart"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- Isolate xBgColour stylecode -->
        <xsl:variable name="bgColourStyleCodeStart" select="substring-after($code, 'xBgColour')"/>
        <xsl:variable name="bgColourHexCode">
            <xsl:choose>
                <xsl:when test="contains($bgColourStyleCodeStart, ' ')">
                    <xsl:value-of select="substring-before($bgColourStyleCodeStart, ' ')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$bgColourStyleCodeStart"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- generate style value -->
        <xsl:variable name="colourStyles">
            <xsl:choose>
                <xsl:when test="$fgColourHexCode != '' and $bgColourHexCode !=''">
                    <xsl:text>background: #</xsl:text>
                    <xsl:value-of select="$bgColourHexCode"/>
                    <xsl:text>;</xsl:text>
                    <xsl:text> color: #</xsl:text>
                    <xsl:value-of select="$fgColourHexCode"/>
                    <xsl:text>;</xsl:text>
                </xsl:when>
                <xsl:when test="$fgColourHexCode = '' and $bgColourHexCode !=''">
                    <xsl:text>background: #</xsl:text>
                    <xsl:value-of select="$bgColourHexCode"/>
                    <xsl:text>;</xsl:text>
                </xsl:when>
                <xsl:when test="$fgColourHexCode != '' and $bgColourHexCode =''">
                    <xsl:text>color: #</xsl:text>
                    <xsl:value-of select="$fgColourHexCode"/>
                    <xsl:text>;</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="trim">
            <xsl:with-param name="string"><xsl:value-of select="$colourStyles"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="processFontSizePx">
        <xsl:param name="code"/>
        
        <!-- Isolate xFontSize stylecode -->
        <xsl:variable name="fontSizeStyleCodeStart" select="substring-after($code, 'xFontSizePx')"/>
        <xsl:variable name="fontSize">
            <xsl:choose>
                <xsl:when test="contains($fontSizeStyleCodeStart, ' ')">
                    <xsl:value-of select="substring-before($fontSizeStyleCodeStart, ' ')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$fontSizeStyleCodeStart"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- generate style value -->
        <xsl:variable name="fontSizePxStyle">
            <xsl:choose>
                <xsl:when test="$fontSize != ''">
                    <xsl:text>font-size: </xsl:text>
                    <xsl:value-of select="$fontSize"/>
                    <xsl:text>px;</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="trim">
            <xsl:with-param name="string"><xsl:value-of select="$fontSizePxStyle"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="processColWidthPx">
        <xsl:param name="code"/>
        
        <!-- Isolate xColWidth stylecode -->
        <xsl:variable name="colWidthStyleCodeStart" select="substring-after($code, 'xColWidthPx')"/>
        <xsl:variable name="colWidth">
            <xsl:choose>
                <xsl:when test="contains($colWidthStyleCodeStart, ' ')">
                    <xsl:value-of select="substring-before($colWidthStyleCodeStart, ' ')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$colWidthStyleCodeStart"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- generate style value -->
        <xsl:variable name="colWidthStyle">
            <xsl:choose>
                <xsl:when test="$colWidth != ''">
                    <xsl:text>width: </xsl:text>
                    <xsl:value-of select="$colWidth"/>
                    <xsl:text>px;</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="trim">
            <xsl:with-param name="string"><xsl:value-of select="$colWidthStyle"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="processFontSizeEm">
        <xsl:param name="code"/>
        
        <!-- Isolate xFontSize stylecode -->
        <xsl:variable name="fontSizeStyleCodeStart" select="substring-after($code, 'xFontSizeEm')"/>
        <xsl:variable name="fontSize">
            <xsl:choose>
                <xsl:when test="contains($fontSizeStyleCodeStart, ' ')">
                    <xsl:value-of select="substring-before($fontSizeStyleCodeStart, ' ')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$fontSizeStyleCodeStart"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- generate style value -->
        <xsl:variable name="fontSizeEmStyle">
            <xsl:choose>
                <xsl:when test="$fontSize != ''">
                    <xsl:text>font-size: </xsl:text>
                    <xsl:value-of select="$fontSize"/>
                    <xsl:text>em;</xsl:text>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="trim">
            <xsl:with-param name="string"><xsl:value-of select="$fontSizeEmStyle"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <!--================================================================================================================================================================================-->
    <!-- [END] STYLE CODE TEMPLATES -->




    <!-- ATTACHMENT TEMPLATES -->    
    <!--================================================================================================================================================================================-->
    
    <xsl:template name="processAttachment">
        <xsl:param name="element"/>
        
        <xsl:variable name="referenceObjectId" select="$element/@referencedObject"/>
        <xsl:variable name="mediaType">
            <xsl:choose>
                <xsl:when test="//cda:observationMedia[@ID=$referenceObjectId]/cda:value/@mediaType">
                    <xsl:value-of select="//cda:observationMedia[@ID=$referenceObjectId]/cda:value/@mediaType"/>
                </xsl:when>
                <xsl:otherwise>text/plain</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$mediaType='application/pdf' or
                $mediaType='text/rtf' or
                $mediaType='application/rtf' or
                $mediaType='text/plain' or
                $mediaType='text/html' or
                $mediaType='application/xhtml+xml' or
                $mediaType='application/xml' or
                $mediaType='image/tiff'">
                <xsl:if test="//cda:observationMedia[@ID=$referenceObjectId]/cda:value/cda:reference/@value and
                    string-length(//cda:observationMedia[@ID=$referenceObjectId]/cda:value/cda:reference/@value) &gt; 0">
                    <xsl:element name="a">
                        <xsl:call-template name="addID">
                            <xsl:with-param name="element" select="."/>
                        </xsl:call-template>
                        <xsl:attribute name="href">
                            <xsl:value-of select="//cda:observationMedia[@ID=$referenceObjectId]/cda:value/cda:reference/@value"/>
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="cda:caption and
                                string-length(cda:caption) &gt; 0">
                                <xsl:value-of select="cda:caption"/>  
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
                                    <xsl:when test="$mediaType='application/pdf'">PDF document</xsl:when>
                                    <xsl:when test="$mediaType='text/rtf' or $mediaType='application/rtf'">RTF document</xsl:when>
                                    <xsl:when test="$mediaType='text/plain'">Text document</xsl:when>
                                    <xsl:when test="$mediaType='text/html'">HTML document</xsl:when>
                                    <xsl:when test="$mediaType='application/xhtml+xml'">XHTML document</xsl:when>
                                    <xsl:when test="$mediaType='application/xml'">XML document</xsl:when>
                                    <xsl:when test="$mediaType='image/tiff'">TIFF document</xsl:when>
                                    <xsl:otherwise>Document with unknown type</xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:element>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$mediaType='image/gif' or $mediaType='image/jpeg' or $mediaType='image/png' or $mediaType='image/bmp'">
                    <xsl:if test="//cda:observationMedia[@ID=$referenceObjectId]/cda:value/cda:reference/@value and
                        string-length(//cda:observationMedia[@ID=$referenceObjectId]/cda:value/cda:reference/@value) &gt; 0">
                        <xsl:call-template name="getHorizontalSpacer"/>
                        <xsl:element name="table">
                            <xsl:attribute name="summary">IMAGE ATTACHMENT</xsl:attribute>
                            <xsl:call-template name="addID">
                                <xsl:with-param name="element" select="."/>
                            </xsl:call-template>
                            <xsl:element name="tbody">
                                <xsl:element name="tr">
                                    <xsl:element name="td">
                                        <xsl:attribute name="align">center</xsl:attribute>
                                        <xsl:element name="img">
                                            <xsl:attribute name="src">
                                                <xsl:value-of select="//cda:observationMedia[@ID=$referenceObjectId]/cda:value/cda:reference/@value"/>
                                            </xsl:attribute>
                                            <xsl:attribute name="style">padding-bottom:0.5em;</xsl:attribute>
                                            <xsl:attribute name="alt">
                                                <xsl:choose>
                                                    <xsl:when test="cda:caption and
                                                        string-length(cda:caption) &gt; 0">
                                                        <xsl:value-of select="cda:caption"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>Image Attachment</xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:attribute>
                                        </xsl:element> <!-- </img> -->
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                                <xsl:element name="tr">
                                    <xsl:element name="td">
                                        <xsl:attribute name="align">center</xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="cda:caption and
                                                string-length(cda:caption) &gt; 0">
                                                <xsl:value-of select="cda:caption"/>
                                            </xsl:when>
                                            <xsl:otherwise>Image Attachment</xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:element> <!-- </td> -->
                                </xsl:element> <!-- </tr> -->
                            </xsl:element> <!-- </tbody> -->
                        </xsl:element> <!-- </table> -->
                    </xsl:if>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="renderLogo">
        <xsl:if test="//cda:observationMedia[@ID='LOGO']/cda:value[@mediaType='image/png' or @mediaType='image/gif' or @mediaType='image/jpeg']/cda:reference/@value">
            <xsl:element name="div">
                <xsl:attribute name="class">halfPageWidth</xsl:attribute>       
                <xsl:attribute name="style">text-align: center;</xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="id"><xsl:value-of select="$LOGO_IMG_ID"/></xsl:attribute>
                    <xsl:attribute name="alt">logo</xsl:attribute>
                    <xsl:attribute name="src">
                        <xsl:value-of select="//cda:observationMedia[@ID='LOGO']/cda:value[@mediaType='image/png']/cda:reference/@value"/>
                    </xsl:attribute>
                </xsl:element> <!-- </img> -->
            </xsl:element> <!-- </div> -->
        </xsl:if>
    </xsl:template>
    
    <!--================================================================================================================================================================================-->
    <!-- [END] ATTACHMENT TEMPLATES -->
    
    


    <!-- STRUCTURE TEMPLATES -->    
    <!--================================================================================================================================================================================-->
 
    <xsl:template name="addCSS">
        <xsl:element name="style">
            <xsl:attribute name="type">text/css</xsl:attribute>
            <xsl:attribute name="media">all</xsl:attribute>
            <!-- CSS classes -->
            
            <!-- Table classes -->
            .RECIPIENTS_TABLE_CLASS {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                padding: 0px;
                border-spacing: 0px;
                border-collapse: collapse;
                page-break-inside: avoid;
                table-layout: fixed;
                word-wrap: break-word;
            }
            
            .RECIPIENTS_TABLE_HEADER_NON-RIGHT_CELL_CLASS {
                background: <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BACKGROUND_COLOUR"/>;
                vertical-align: top;
                text-align: left;
                border-left: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-right: 0px;
                border-top: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-bottom: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
            }

            .RECIPIENTS_TABLE_HEADER_RIGHT_CELL_CLASS {
                background: <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BACKGROUND_COLOUR"/>;
                vertical-align: top;
                text-align: left;
                border-left: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-right: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-top: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-bottom: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
            }

            .RECIPIENTS_TABLE_BODY_NON-RIGHT_CELL_CLASS {
                background: <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BACKGROUND_COLOUR"/>;
                vertical-align: top;
                text-align: left;
                border-left: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-right: 0px;
                border-top: 0px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-bottom: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
            }
            
            .RECIPIENTS_TABLE_BODY_RIGHT_CELL_CLASS {
                background: <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BACKGROUND_COLOUR"/>;
                vertical-align: top;
                text-align: left;
                border-left: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-right: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-top: 0px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
                border-bottom: 1px SOLID <xsl:value-of select="$GENERAL_TABLE_HEADER_CELL_BORDER_COLOUR"/>;
            }
            
            .nbspSpan {
                margin-left: 4px;
            }
            
            .pageWidth { 
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
            }
            .halfPageWidth { 
                width: <xsl:value-of select="$HALF_CONTENT_WIDTH"/>px; 
            }
            .quarterPageWidth { 
                width: <xsl:value-of select="$QUARTER_CONTENT_WIDTH"/>px; 
            }
            .pageHeaderItemGap { 
                margin-left: <xsl:value-of select="$PAGE_HEADER_ITEM_GAP"/>px; 
            }
            .summaryDetailsLeftGap {
                width: <xsl:value-of select="$SUMMARY_DETAILS_LEFT_GAP"/>px;
            }
            
            .generictable {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH - 2"/>px;
                border-spacing: 0px; 
                padding: 0px;
                border-spacing: 0px;
                empty-cells: show;
                page-break-inside: avoid;
                border: 1px SOLID #EEEEEE;
                table-layout: fixed;
                word-wrap: break-word;
                page-break-inside: avoid;
            }

            .xFixed {
                font-family:monospace;
            }

            .underline {
                text-decoration: underline;
            }
            
            .nounderline {
                text-decoration: none;
            }
            
            .bold {
                font-weight: bold;
            }
            
            .emphasis {
                font-variant: small-caps;
            }
            
            .italic {
                font-style: italic;
            }
            
            .Lrule {
                border-left: 1px SOLID #000000;
            }
            
            .Rrule {
                border-right: 1px SOLID #000000;
            }
            
            .botrule {
                border-bottom: 1px SOLID #000000;
            }
            .toprule {
                border-top: 1px SOLID #000000;
            }
            
            .noLrule {
            border-left: 1px SOLID #EEEEEE;
            }
            
            .noRrule {
            border-right: 1px SOLID #EEEEEE;
            }
            
            .noBotrule {
            border-bottom: 1px SOLID #EEEEEE;
            }
            
            .noToprule {
            border-top: 1px SOLID #000000;
            }
            
            .tableCaption {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                font-weight: bold;
                text-align: left;
            }

            .sectionheader {
                background-color: #EEEEEE;
                text-align: left;
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                border-left: 0px;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 0px;
                padding: 0px;
                text-decoration: none;
                font-weight: bold;
                text-decoration: none;
            }

            .halfsectionheader {
                background-color: #EEEEEE;
                text-align: left;
                width: <xsl:value-of select="$HALF_CONTENT_WIDTH"/>px;
                border-left: 0px;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 0px;
                padding: 0px;
                text-decoration: none;
            }
            
            .sectiontitleheader { 
                background-color: #DDDDDD;
                text-align: left;
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                max-width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                left: 10px;
                border-left: 0px;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 0px;
                padding: 0px;
                text-decoration: none;
                word-wrap: break-word;
                white-space: pre-wrap;
            }
            
            .paragraph {
                border-spacing: 0px; 
                padding: 0px;
                border-spacing: 0px;
                empty-cells: show;
                page-break-inside: avoid;
                border: 0px SOLID #EEEEEE;                    
                word-wrap: break-word;
                white-space: pre-wrap;            
            }
            
            .horizontalspacer {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                height: 15px;
                border-style: none;
                border-width: 1px;
                border-color: #FFFFFF;
            }

            .halfHorizontalspacer {
                width: <xsl:value-of select="$HALF_CONTENT_WIDTH"/>px;
                height: 15px;
                border-style: none;
                border-width: 1px;
                border-color: #FFFFFF;
            }
            
            .sidevaluenames {
                display: inline;
                width: 120px;
                font-weight: bold;
                text-align: left;
                vertical-align: top;
            }
            
            .sidevalue {
                width: 380px;
            }
            
            .hi {
                font-size: 9px;
            }

            .<xsl:value-of select="$PROVIDER_INDIVIDUAL_IDENTIFIER_CSS_CLASS"/> {
                font-size: 9px;
                margin-left: 20px;
            }
            
            .<xsl:value-of select="$PROVIDER_ORGANISATION_IDENTIFIER_CSS_CLASS"/> {
                font-size: 9px;
                margin-left: 20px;
            }

            .summarydetails {
                display: inline;
                width: <xsl:value-of select="$QUARTER_CONTENT_WIDTH - 100"/>px;
                font-weight: bold;
                vertical-align: top;
                text-align: left;
            }
            
            .documentdetailsvalues {
                width: <xsl:value-of select="$QUARTER_CONTENT_WIDTH + 50"/>px;
                vertical-align: top;
            }
            
            .generalcolumnheadings {
                text-align: left;
                font-weight: bold;
                vertical-align: top;
            }
            
            .generalcolumnheadingvalues {
                text-align: left;
            }

            .borderedcolumnheadings {
                text-align: left;
                background: #FFFFFF;
                padding: 0px;
                vertical-align: top;
                border-left: 1px SOLID #EEEEEE;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 1px SOLID #EEEEEE;
            }
            
            .borderedcolumnheadingvalues {
                text-align: left;
                background: #FFFFFF; 
                vertical-align: top;
                padding: 0px;
                border-left: 1px SOLID #EEEEEE;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 1px SOLID #EEEEEE;
            }
            
            .documentindicatortext {
                text-align: center;
                vertical-align: middle;
                background: #000000;
                color: #FFFFFF;
                font-style: italic;
                font-weight: bold;
            }
            
            .halfsectionheading2 {
                padding: 0px 0px 0px 0px;
                font-size: 12px; 
                font-weight: bold;
                margin: 0;
            }

            .maintitleheading2 {
                padding: 0px 0px 0px 0px;
                text-align: center;
                font-size: 16px;
                font-weight: normal;
                margin: 0;
            }
            
            .sectiontitleheading2 {
                padding: 0px 0px 0px 0px;
                font-size: 14px;
                font-weight: bold;
                margin: 0px;
            }
            
            
            .bannerpatientdemographicsdl {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH - 6"/>px;
                border-left: 1px SOLID #000000;
                border-right: 1px SOLID #000000;
                border-bottom: 1px SOLID #000000;
                word-wrap: break-word;
                background: #EEEEEE; 
                color: #000000; 
                padding: 2px;
                margin:0px;
            }
            
            .titleheading1 {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH - 2"/>;
                text-align: center;
                border-left: 1px SOLID #000000;
                border-right: 1px SOLID #000000;
                border-top: 1px SOLID #000000;
                background: #EEEEEE;
                margin-bottom: <xsl:value-of select="$TOP_MARGIN_WIDTH"/>px;
                padding: 0px 0px 0px 0px;
                font-size: 16px; 
                font-weight: bold;
                margin: 0;
            }
           
            .bannerpatientdemographicsdt {
                display: inline;
                font-size: 13px;
                word-wrap: break-word;
                font-weight: bold;
                margin: 0px;
                padding: 0px;
            }

            .bannerpatientdemographicsdd {
                display: inline;
                font-size: 13px;
                word-wrap: break-word;
                font-weight: bold;
                margin: 0px;
                padding-right: 24px;
            }

            .bannerpatientidentifiersdl {
                word-wrap: break-word;
                background: #EEEEEE; 
                color: #000000; 
                padding: 2px;
                margin:0px;
            }
            
            .bannerpatientihidt {
                display: inline;
                font-size: 13px;
                word-wrap: break-word;
                font-weight: bold;
                margin: 0px;
                padding: 0px;
                text-align: right;
            }
            
            .bannerpatientihidd {
                display: inline;
                font-size: 13px;
                word-wrap: break-word;
                font-weight: bold;
                margin: 0px;
                text-align: right;
            }

            .bannerpatientmrndt {
                display: inline;
                font-size: 13px;
                word-wrap: break-word;
                font-weight: bold;
                margin: 0px;
                padding: 0px;
                text-align: right;
                padding-left: 24px;
            }
            
            .bannerpatientmrndd {
                display: inline;
                font-size: 13px;
                word-wrap: break-word;
                font-weight: bold;
                margin: 0px;
                text-align: right;
            }

            .addressdl {
                display: inline;
                margin: 0px;
                padding: 0px;
                text-align: left;
            }
            
            .addressdt {
                margin: 0px;
                padding: 0px;
                text-align: left;
                font-weight: bold;
            }
            
            .addressdd {
                display: inline;
                margin: 0px;
                padding: 0px;
                text-align: left;
            }

            .contactdetailsul {
                list-style-type: none;
                margin: 0px;
                padding: 0px;
                padding-left: 0;
                text-align: left;
            }
            
            .contactdetailsli {
                margin: 0px;
                padding: 0px;
                text-align: left;
            }
            
            .contactdetailsdl {
                display: inline;
                margin: 0px;
                padding: 0px;
                text-align: left;
            }
            
            .contactdetailsdt {
                margin: 0px;
                padding: 0px;
                text-align: left;
                font-weight: bold;
            }
            
            .contactdetailsdd {
                display: inline;
                margin: 0px;
                padding: 0px;
                text-align: left;
            }
            
            .specialtiesul {
                list-style-type: none;
                margin: 0px;
                padding: 0px;
                padding-left: 0;
                text-align: left;
            }
            
            .specialtiesli {
                margin: 0px;
                padding: 0px;
                text-align: left;
            }

            <!-- Specific elements -->
            body { 
                font-size:12px;
                font-family:Verdana;
                width: <xsl:value-of select="$FULL_VIEWPORT_WIDTH"/>px;
                margin-left: 0px;
                margin-right: 0px;
            }
            
            table { 
                border-spacing: 0px; 
                padding: 0px;
                border-spacing: 0px;
                empty-cells: show;
            }

            td { 
                border-left: 0px;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 0px;
                padding: 0px;
            }

            th {
                border-left: 0px;
                border-right: 0px;
                border-top: 0px;
                border-bottom: 0px;
                padding: 0px;
            }
            
            pre {
                word-wrap: break-word;
                white-space: pre-wrap;            
            }
            
            p.div {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
            }
            
            a:link { 
                color: blue;
            }
            
            a:visited { 
                color: blue;
            }
            
            a:hover {
                color: red;
            }
            
            a:active {
                color: red;
            }
                      
            <!-- Elements with id attributes -->
            div#<xsl:value-of select="$LOGO_IMG_ID"/> {
                width: 400px;
                height: 100px;
                clip: rect(0px, 400px, 100px, 0px);
                overflow: hidden;
            }
            
            <!-- Elements with id attributes -->
            div#<xsl:value-of select="$BANNER_DIV_ID"/> {
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH"/>px;
                top: <xsl:value-of select="$TOP_MARGIN_WIDTH"/>px;                      
                left: <xsl:value-of select="$LEFT_MARGIN_WIDTH"/>px;                      
                right: <xsl:value-of select="$RIGHT_MARGIN_WIDTH + $CONTENT_SCROLL_BAR_WIDTH"/>px;
                overflow: auto;
                background: #FFFFFF;
            }
        </xsl:element> <!--  </style text="text/css" media="all"> -->
        
        <xsl:element name="style">
            <xsl:attribute name="type">text/css</xsl:attribute>
            <xsl:attribute name="media">screen</xsl:attribute>
            <!-- CSS classes -->
            .showHideHeaderDetailsButtonTableRow {
            }

            .spaceToScrollToFootnotesDiv { 
            }

            <!-- Elements with id attributes -->
            div#<xsl:value-of select="$BANNER_DIV_ID"/> {
                position: fixed;
            }
            
            div#<xsl:value-of select="$CONTENT_DIV_ID"/> {
                position: fixed;
                width: <xsl:value-of select="$FULL_CONTENT_WIDTH + $CONTENT_SCROLL_BAR_WIDTH"/>px;
                left: <xsl:value-of select="$LEFT_MARGIN_WIDTH"/>px;                      
                bottom: 0px; 
                overflow: auto;
                background: #FFFFFF;
                padding: 0px;
            }                                    
        </xsl:element> <!--  </style text="text/css" media="screen"> -->
        
        <xsl:element name="style">
            <xsl:attribute name="type">text/css</xsl:attribute>
            <xsl:attribute name="media">print</xsl:attribute>
            <!-- CSS classes -->
            .showHideHeaderDetailsButtonTableRow { 
                display: none;
            }
            
            .spaceToScrollToFootnotesDiv { 
                display: none;
            }
            
            <!-- Elements with id attributes -->
            div#<xsl:value-of select="$CONTENT_DIV_ID"/> {
                width: <xsl:value-of select="$FULL_VIEWPORT_WIDTH"/>px;
                left: <xsl:value-of select="$LEFT_MARGIN_WIDTH"/>px;                      
                right: <xsl:value-of select="$RIGHT_MARGIN_WIDTH"/>px;
                bottom: 0px; 
                overflow: auto;
                background: #FFFFFF;
                padding: 0px;
            }                        

            div#<xsl:value-of select="$DETAILS_DIV_ID"/> {
                display:block !important;
            }                
        </xsl:element> <!--  </style text="text/css" media="print"> -->
   </xsl:template>
 
    <xsl:template name="addJavaScript">
        <xsl:element name="script">
            <xsl:attribute name="type">text/javascript</xsl:attribute>
            <![CDATA[
            function toggleDetails(detailsDivId) {
                var administrativeDetailsCheckbox = document.getElementById('administrativeDetailsCheckboxId');
                var detailsDiv = document.getElementById(detailsDivId);
                var providerIdentifiersCheckboxDiv = document.getElementById('providerIdentifiersCheckboxDiv');
                
                if (administrativeDetailsCheckbox.checked) {
                    if (detailsDiv!=null) {
                        detailsDiv.style.display = "block";
                        providerIdentifiersCheckboxDiv.style.display = "inline";
                    }
                } else {
                    if (detailsDiv!=null) {
                        detailsDiv.style.display = "none";
                        providerIdentifiersCheckboxDiv.style.display = "none";
                    }
                }
            }

            function toggleProviderIdentifiers(providerIndividualIdentifierClass, providerOrganisationIdentifierClass) {
                var providerIdentifiersCheckbox = document.getElementById('providerIdentifiersCheckboxId');
                var providerIndividualIdentifiers = getElementsByClassName(providerIndividualIdentifierClass);
                var providerOrganisationIdentifiers = getElementsByClassName(providerOrganisationIdentifierClass);
                var identifierDiv;
                
                if (providerIdentifiersCheckbox.checked) {
                    if (providerIndividualIdentifiers!=null) {
                        for (var i=0; i<providerIndividualIdentifiers.length; i++ ) {
                            identifierDiv = providerIndividualIdentifiers[i];
                            if (identifierDiv!=null) {
                                identifierDiv.style.display = "block";
                            }
                        }                    
                    }
                    if (providerOrganisationIdentifiers!=null) {
                        for (var i=0; i<providerOrganisationIdentifiers.length; i++ ) {
                            identifierDiv = providerOrganisationIdentifiers[i];
                            if (identifierDiv!=null) {
                                identifierDiv.style.display = "block";
                            }
                        }                    
                    }
                } else {
                    if (providerIndividualIdentifiers!=null) {
                        for (var i=0; i<providerIndividualIdentifiers.length; i++ ) {
                            identifierDiv = providerIndividualIdentifiers[i];
                            if (identifierDiv!=null) {
                                identifierDiv.style.display = "none";
                            }
                        }                    
                    }
                    if (providerOrganisationIdentifiers!=null) {
                        for (var i=0; i<providerOrganisationIdentifiers.length; i++ ) {
                            identifierDiv = providerOrganisationIdentifiers[i];
                            if (identifierDiv!=null) {
                                identifierDiv.style.display = "none";
                            }
                        }                    
                    }
                }
            }
            
            function load() {
                var bannerHeight = document.getElementById('BANNER').offsetHeight;
                var contentDiv = document.getElementById('CONTENT');
                contentDiv.style.top = bannerHeight + 4 +"px";
            }
            
            function cdaRenderSpecificationVersionWarning() {
                var r=confirm("This CDA Document requires a more recent version of the CDA rendering infrastructure than your system currently supports. Please click okay to proceed, or cancel to close the page.");
                if (r==true) {
                } else {
                  var myWindow=window.open('about:blank','_self');
                  myWindow.focus();
                }
            }
            
            function getElementsByClassName(className) {
                if (document.getElementsByClassName) { 
                    return document.getElementsByClassName(className); 
                } else { 
                    var elms = document.getElementsByTagName('*');
                    var ei = new Array();
                    for (i = 0; i < elms.length; i++) {
                        if (elms[i].getAttribute('class')) {
                            ecl = elms[i].getAttribute('class').split(' ');
                            for (j = 0; j < ecl.length; j++) {
                                if (ecl[j].toLowerCase() == arguments[0].toLowerCase()) {
                                    ei.push(elms[i]);
                                }
                            }
                        } else if (elms[i].className) {
                            ecl = elms[i].className.split(' ');
                            for (j = 0; j < ecl.length;j++) {
                                if (ecl[j].toLowerCase() == arguments[0].toLowerCase()) {
                                    ei.push(elms[i]);
                                }
                            }
                        }
                    }
                    return ei;
                }
            }
            ]]>
        </xsl:element> <!-- </script> -->
    </xsl:template>
    
    <xsl:template name="getHorizontalSpacer">
        <xsl:element name="div">
            <xsl:attribute name="class">horizontalspacer</xsl:attribute>
        </xsl:element> <!-- </div> -->
    </xsl:template>

    <xsl:template name="getHalfHorizontalSpacer">
        <xsl:element name="div">
            <xsl:attribute name="class">halfHorizontalspacer</xsl:attribute>
        </xsl:element> <!-- </div> -->
    </xsl:template>
    
    <xsl:template name="getFootnotesTable">
        <xsl:if test="count(//cda:footnote) &gt; 0">
            <xsl:element name="table">
                <xsl:element name="thead">
                    <xsl:element name="tr">
                        <xsl:element name="td">
                            <xsl:attribute name="class">sectionheader</xsl:attribute>
                            FOOTNOTES
                        </xsl:element> <!-- </td> -->
                    </xsl:element> <!-- </tr> -->
                </xsl:element> <!-- </thead> -->
                <xsl:element name="tbody">
                    <xsl:element name="tr">
                        <xsl:element name="td"><xsl:apply-templates mode="footnote" select=".//cda:footnote"/></xsl:element>
                    </xsl:element> <!-- </tr> -->
                </xsl:element> <!-- </tbody> -->
            </xsl:element> <!-- </table> -->            
        </xsl:if>
    </xsl:template>

    <xsl:template name="getSpaceToScrollToFootnotesDiv">
        <xsl:if test="count(//cda:footnote) &gt; 0">
            <xsl:element name="div">
                <xsl:attribute name="class">spaceToScrollToFootnotesDiv</xsl:attribute>
                <xsl:attribute name="style">height:1500px; background:#FFFFFF; color:#FFFFFF;</xsl:attribute>
                <xsl:call-template name="printNBSPs"><xsl:with-param name="number">1</xsl:with-param></xsl:call-template>
            </xsl:element> <!-- </div> -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getStartOfDocumentIndicator">
        <xsl:call-template name="getDocumentIndicator">
            <xsl:with-param name="indicatorText">START OF DOCUMENT</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getEndOfDocumentIndicator">
        <xsl:call-template name="getHorizontalSpacer"/>
        <xsl:call-template name="getDocumentIndicator">
            <xsl:with-param name="indicatorText">END OF DOCUMENT</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="getHorizontalSpacer"/>
    </xsl:template>
    
    <xsl:template name="getDocumentIndicator">
        <xsl:param name="indicatorText"/>
        
        <xsl:if test="$indicatorText and
                      string-length($indicatorText) &gt; 0">
            <xsl:element name="div">
                <xsl:attribute name="class">pageWidth documentindicatortext</xsl:attribute>
                <xsl:attribute name="style">page-break-inside: avoid;
                                            border: 0px SOLID #000000;</xsl:attribute>
                <xsl:value-of select="$indicatorText"/>
            </xsl:element> <!-- </div> -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getContactDetails">
        <xsl:param name="personOrOrg"/>
        <xsl:choose>
            <xsl:when test="count($personOrOrg/cda:telecom[starts-with(@value, 'tel:') or starts-with(@value, 'fax:') or starts-with(@value, 'mailto:')]) &gt; 0">

                <xsl:element name="dl">
                    <xsl:attribute name="class">contactdetailsdl</xsl:attribute>
                    
                    <xsl:if test="count($personOrOrg/cda:telecom[starts-with(@value, 'tel:')]) &gt; 0">
                            <xsl:element name="dt">
                                <xsl:attribute name="class">contactdetailsdt</xsl:attribute>
                                Phone:
                            </xsl:element>
                            <xsl:element name="dd">
                                <xsl:attribute name="class">contactdetailsdd</xsl:attribute>
                                <xsl:element name="ul">
                                    <xsl:attribute name="class">contactdetailsul</xsl:attribute>                                        
                                    <xsl:for-each select="$personOrOrg/cda:telecom[starts-with(@value, 'tel:')]">                                            
                                        <xsl:call-template name="show-telecom">
                                            <xsl:with-param name="telecom" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element>
                            </xsl:element> <!-- </dd> -->
                    </xsl:if>
                    
                    <xsl:if test="count($personOrOrg/cda:telecom[starts-with(@value, 'fax:')]) &gt; 0">
                            <xsl:element name="dt">
                                <xsl:attribute name="class">contactdetailsdt</xsl:attribute>
                                Facsimile machine:
                            </xsl:element>
                            <xsl:element name="dd">
                                <xsl:attribute name="class">contactdetailsdd</xsl:attribute>
                                <xsl:element name="ul">
                                    <xsl:attribute name="class">contactdetailsul</xsl:attribute>                                        
                                    <xsl:for-each select="$personOrOrg/cda:telecom[starts-with(@value, 'fax:')]">                                            
                                        <xsl:call-template name="show-telecom">
                                            <xsl:with-param name="telecom" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element>
                            </xsl:element> <!-- </dd> -->
                    </xsl:if>
                    
                    <xsl:if test="count($personOrOrg/cda:telecom[starts-with(@value, 'mailto:')]) &gt; 0">
                            <xsl:element name="dt">
                                <xsl:attribute name="class">contactdetailsdt</xsl:attribute>
                                Email:
                            </xsl:element>
                            <xsl:element name="dd">
                                <xsl:attribute name="class">contactdetailsdd</xsl:attribute>
                                <xsl:element name="ul">
                                    <xsl:attribute name="class">contactdetailsul</xsl:attribute>                                        
                                    <xsl:for-each select="$personOrOrg/cda:telecom[starts-with(@value, 'mailto:')]">                                            
                                        <xsl:call-template name="show-telecom">
                                            <xsl:with-param name="telecom" select="."/>
                                        </xsl:call-template>
                                    </xsl:for-each>
                                </xsl:element>
                            </xsl:element> <!-- </dd> -->
                    </xsl:if>                                
                </xsl:element> <!-- </dl> -->
            </xsl:when>
            <xsl:otherwise>Not Provided</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!--================================================================================================================================================================================-->
    <!-- [END] STRUCTURE TEMPLATES -->




    <!-- UTILITY TEMPLATES -->    
    <!--================================================================================================================================================================================-->
    <xsl:template name="show-name">
        <xsl:param name="name"/>
        
        <xsl:call-template name="trim">
            <xsl:with-param name="string">
                <xsl:choose>
                    <xsl:when test="$name/cda:family">
                        <xsl:for-each select="$name/cda:prefix">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                        <xsl:for-each select="$name/cda:given">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
        
                        <xsl:for-each select="$name/cda:family">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
        
                        <xsl:for-each select="$name/cda:suffix">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$name"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
   
    <xsl:template name="show-patient-name">
        <xsl:param name="name"/>
        
        <xsl:call-template name="trim">
            <xsl:with-param name="string">
                <xsl:choose>
                    <xsl:when test="$name/cda:family">
                        <xsl:for-each select="$name/cda:prefix">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                        <xsl:for-each select="$name/cda:given">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                        
                        <xsl:for-each select="$name/cda:family">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:call-template name="toUpperCase">
                                    <xsl:with-param name="data">
                                        <xsl:value-of select="./text()"/>
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                        
                        <xsl:for-each select="$name/cda:suffix">
                            <xsl:if test="string-length(./text()) &gt; 0">
                                <xsl:value-of select="./text()"/>
                                <xsl:text> </xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$name"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
   
    <xsl:template name="show-address">
        <xsl:param name="address"/>
        
        <xsl:if test="$address">
            <xsl:choose>
                <xsl:when test="$address/@nullFlavor='NA'">
                    <xsl:element name="dt"><xsl:attribute name="class">addressdt</xsl:attribute>No Fixed Address</xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="dt"><xsl:attribute name="class">addressdt</xsl:attribute><xsl:call-template name="getAddressUseDescriptor"><xsl:with-param name="code" select="./@use"/></xsl:call-template><xsl:text>:</xsl:text><xsl:element name="br"/></xsl:element>
                    <xsl:element name="dd"><xsl:attribute name="class">addressdd</xsl:attribute>
                        <xsl:if test="$address/cda:streetAddressLine">
                            <xsl:for-each select="$address/cda:streetAddressLine[string-length(text()) &gt; 0]">
                                <xsl:if test="position() &gt; 1"><xsl:text>, </xsl:text></xsl:if>
                                <xsl:value-of select="."/>
                            </xsl:for-each>
                            <xsl:if test="($address/cda:houseNumber and
                                           string-length($address/cda:houseNumber) &gt; 0) or
                                          ($address/cda:streetName and
                                           string-length($address/cda:streetName) &gt; 0) or
                                           ($address/cda:streetNameType and
                                           string-length($address/cda:streetNameType) &gt; 0) or
                                           ($address/cda:city and
                                           string-length($address/cda:city) &gt; 0) or
                                          ($address/cda:state and
                                           string-length($address/cda:state) &gt; 0) or
                                          ($address/cda:postalCode and
                                           string-length($address/cda:postalCode) &gt; 0) or
                                          ($address/cda:country and
                                           string-length($address/cda:country) &gt; 0)">
                                <xsl:text>, </xsl:text>
                            </xsl:if>
                        </xsl:if>

                        <xsl:if test="$address/cda:houseNumber and string-length($address/cda:houseNumber) &gt; 0">
                            <xsl:value-of select="$address/cda:houseNumber"/>
                            <xsl:choose>
                                <xsl:when test="$address/cda:streetName and string-length($address/cda:streetName) &gt; 0">
                                    <xsl:text> </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:if test="($address/cda:city and
                                                   string-length($address/cda:city) &gt; 0) or
                                                  ($address/cda:state and
                                                   string-length($address/cda:state) &gt; 0) or
                                                  ($address/cda:postalCode and
                                                  string-length($address/cda:postalCode) &gt; 0) or
                                                  ($address/cda:country and
                                                   string-length($address/cda:country) &gt; 0)">
                                                   <xsl:text>, </xsl:text>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                        <xsl:if test="$address/cda:streetName and string-length($address/cda:streetName) &gt; 0">
                            <xsl:value-of select="$address/cda:streetName"/>
                            <xsl:choose>
                                <xsl:when test="$address/cda:streetNameType and string-length($address/cda:streetNameType) &gt; 0">
                                    <xsl:text> </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:if test="($address/cda:city and
                                               string-length($address/cda:city) &gt; 0) or
                                              ($address/cda:state and
                                               string-length($address/cda:state) &gt; 0) or
                                              ($address/cda:postalCode and
                                               string-length($address/cda:postalCode) &gt; 0) or
                                              ($address/cda:country and
                                               string-length($address/cda:country) &gt; 0)">
                                        <xsl:text>, </xsl:text>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="$address/cda:streetNameType and string-length($address/cda:streetNameType) &gt; 0">
                                <xsl:value-of select="$address/cda:streetNameType"/>
                                <xsl:if test="($address/cda:city and
                                               string-length($address/cda:city) &gt; 0) or
                                               ($address/cda:state and
                                               string-length($address/cda:state) &gt; 0) or
                                               ($address/cda:postalCode and
                                               string-length($address/cda:postalCode) &gt; 0) or
                                               ($address/cda:country and
                                               string-length($address/cda:country) &gt; 0)">
                                    <xsl:text>, </xsl:text>
                                </xsl:if>
                            </xsl:if>
                        </xsl:if>
                        <xsl:if test="string-length($address/cda:city)>0">
                            <xsl:value-of select="$address/cda:city"/>
                            <xsl:if test="($address/cda:state and
                                           string-length($address/cda:state) &gt; 0) or
                                          ($address/cda:postalCode and
                                           string-length($address/cda:postalCode) &gt; 0) or
                                          ($address/cda:country and
                                           string-length($address/cda:country) &gt; 0)">
                                <xsl:text>, </xsl:text>
                            </xsl:if>
                        </xsl:if>
                        <xsl:if test="string-length($address/cda:state)>0">
                            <xsl:value-of select="$address/cda:state"/>
                            <xsl:if test="($address/cda:postalCode and
                                           string-length($address/cda:postalCode) &gt; 0) or
                                          ($address/cda:country and
                                           string-length($address/cda:country) &gt; 0)">
                                <xsl:text>, </xsl:text>
                            </xsl:if>
                        </xsl:if>
                        <xsl:if test="string-length($address/cda:postalCode)>0">
                            <xsl:value-of select="$address/cda:postalCode"/>
                            <xsl:if test="($address/cda:country and
                                           string-length($address/cda:country) &gt; 0)">
                                <xsl:text>, </xsl:text>
                            </xsl:if>
                        </xsl:if>
                        <xsl:if test="string-length($address/cda:country)>0">
                            <xsl:value-of select="$address/cda:country"/>
                        </xsl:if>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="show-telecom">
        <xsl:param name="telecom"/>
        <xsl:if test="$telecom and string-length($telecom/@value) &gt; 0">
            <xsl:element name="li">
                <xsl:attribute name="class">contactdetailsli</xsl:attribute>
                <xsl:choose>
                    <xsl:when test="contains($telecom/@value, ':')">
                        <xsl:variable name="value" select="substring-after($telecom/@value, ':')"/>
                            <xsl:if test="$value">
                                <xsl:value-of select="$value"/>
                            </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$telecom/@value"/>
                    </xsl:otherwise>
                </xsl:choose>
            <xsl:text> </xsl:text>(<xsl:call-template name="getTelecomUseDescriptors"><xsl:with-param name="codes" select="./@use"/></xsl:call-template>)
            </xsl:element> <!-- </li> -->            
        </xsl:if>
    </xsl:template>
  
    <xsl:template name="getTelecomUseDescriptors">
        <xsl:param name="codes" />
        
        <xsl:variable name="newlist" select="concat(normalize-space($codes), ' ')" /> 
        <xsl:variable name="first" select="substring-before($newlist, ' ')" /> 
        <xsl:variable name="remaining" select="substring-after($newlist, ' ')" /> 
        <xsl:call-template name="getTelecomUseDescriptor">
            <xsl:with-param name="code"><xsl:value-of select="$first"/></xsl:with-param>
        </xsl:call-template> 
        <xsl:if test="$remaining">
            <xsl:text>, </xsl:text>
            <xsl:call-template name="getTelecomUseDescriptors">
                <xsl:with-param name="codes" select="$remaining" /> 
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getTelecomUseDescriptor">
        <xsl:param name="code"/>
        <xsl:choose>
            <xsl:when test="$code='H'">
                <xsl:text>Home</xsl:text>
            </xsl:when>
            <xsl:when test="$code='HP'">
                <xsl:text>Primary Home</xsl:text>
            </xsl:when>
            <xsl:when test="$code='HV'">
                <xsl:text>Vacation Home</xsl:text>
            </xsl:when>
            <xsl:when test="$code='WP'">
                <xsl:text>Workplace</xsl:text>
            </xsl:when>
            <xsl:when test="$code='AS'">
                <xsl:text>Answering Service</xsl:text>
            </xsl:when>
            <xsl:when test="$code='EC'">
                <xsl:text>Emergency Contact</xsl:text>
            </xsl:when>
            <xsl:when test="$code='MC'">
                <xsl:text>Mobile Contact</xsl:text>
            </xsl:when>
            <xsl:when test="$code='PG'">
                <xsl:text>PG Pager</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Unknown Usage</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getAddressUseDescriptor">
        <xsl:param name="code"/>
        <xsl:choose>
            <xsl:when test="$code='WP'">
                <xsl:text>Work Place</xsl:text>
            </xsl:when>
            <xsl:when test="$code='PST'">
                <xsl:text>Postal Address</xsl:text>
            </xsl:when>
            <xsl:when test="$code='TMP'">
                <xsl:text>Temporary Address</xsl:text>
            </xsl:when>
            <xsl:when test="$code='H'">
                <xsl:text>Home Address</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Other Address</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="show-date">
        <xsl:param name="datetime"/>
        
        <xsl:call-template name="trim">
            <xsl:with-param name="string">    
                <xsl:choose>
                    <xsl:when test="not($datetime)">
                        <xsl:call-template name="formatDate">
                            <xsl:with-param name="date" select="@value"/>
                        </xsl:call-template>
                        <xsl:text> </xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="formatDate">
                            <xsl:with-param name="date" select="$datetime/@value"/>
                        </xsl:call-template>
                        <xsl:text> </xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="show-time">
        <xsl:param name="datetime"/>
        
        <xsl:call-template name="trim">
            <xsl:with-param name="string">    
                <xsl:choose>
                    <xsl:when test="not($datetime)">
                        <xsl:call-template name="formatDateTime">
                            <xsl:with-param name="date" select="@value"/>
                        </xsl:call-template>
                        <xsl:text> </xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="formatDateTime">
                           <xsl:with-param name="date" select="$datetime/@value"/>
                        </xsl:call-template>
                        <xsl:text> </xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="formatDateTime">
        <xsl:param name="date"/>
        
        <!-- day -->
        <xsl:choose>
            <xsl:when test="substring ($date, 7, 1)='0'">
                <xsl:value-of select="substring ($date, 8, 1)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring ($date, 7, 2)"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text> </xsl:text>
        <!-- month -->
        <xsl:variable name="month" select="substring ($date, 5, 2)"/>
        <xsl:choose>
            <xsl:when test="$month='01'">
                <xsl:text>Jan </xsl:text>
            </xsl:when>
            <xsl:when test="$month='02'">
                <xsl:text>Feb </xsl:text>
            </xsl:when>
            <xsl:when test="$month='03'">
                <xsl:text>Mar </xsl:text>
            </xsl:when>
            <xsl:when test="$month='04'">
                <xsl:text>Apr </xsl:text>
            </xsl:when>
            <xsl:when test="$month='05'">
                <xsl:text>May </xsl:text>
            </xsl:when>
            <xsl:when test="$month='06'">
                <xsl:text>Jun </xsl:text>
            </xsl:when>
            <xsl:when test="$month='07'">
                <xsl:text>July </xsl:text>
            </xsl:when>
            <xsl:when test="$month='08'">
                <xsl:text>Aug </xsl:text>
            </xsl:when>
            <xsl:when test="$month='09'">
                <xsl:text>Sep </xsl:text>
            </xsl:when>
            <xsl:when test="$month='10'">
                <xsl:text>Oct </xsl:text>
            </xsl:when>
            <xsl:when test="$month='11'">
                <xsl:text>Nov </xsl:text>
            </xsl:when>
            <xsl:when test="$month='12'">
                <xsl:text>Dec </xsl:text>
            </xsl:when>
        </xsl:choose>
        <!-- year -->
        <xsl:value-of select="substring ($date, 1, 4)"/>
        <!-- time -->
        <xsl:if test="string-length($date) > 8">
            <xsl:text> </xsl:text>
            <xsl:variable name="time">
                <xsl:value-of select="substring($date,9,6)"/>
            </xsl:variable>
            <xsl:variable name="hh">
                <xsl:value-of select="substring($time,1,2)"/>
            </xsl:variable>
            <xsl:variable name="mm">
                <xsl:value-of select="substring($time,3,2)"/>
            </xsl:variable>
            <xsl:variable name="ss">
                <xsl:value-of select="substring($time,5,2)"/>
            </xsl:variable>
            <xsl:if test="string-length($hh)&gt;1">
                <xsl:value-of select="$hh"/>
                <xsl:if
                    test="string-length($mm)&gt;1 and not(contains($mm,'-')) and not (contains($mm,'+'))">
                    <xsl:text>:</xsl:text>
                    <xsl:value-of select="$mm"/>
                </xsl:if>
            </xsl:if>
        </xsl:if>
        <!-- time zone -->
        <xsl:if test="(contains($date,'+') and string-length(substring-after($date,'+')) = 4) or
                      (contains($date,'-') and string-length(substring-after($date,'-')) = 4)">
            <xsl:variable name="tzon">
                <xsl:choose>
                    <xsl:when test="contains($date,'+')">
                        <xsl:text>+</xsl:text>
                        <xsl:value-of select="substring-after($date, '+')"/>
                    </xsl:when>
                    <xsl:when test="contains($date,'-')">
                        <xsl:text>-</xsl:text>
                        <xsl:value-of select="substring-after($date, '-')"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:variable>
            <xsl:if test="string-length($tzon) &gt; 0">
                <xsl:value-of select="$tzon"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="formatDate">
        <xsl:param name="date"/>
        
        <!-- day -->
        <xsl:choose>
            <xsl:when test="substring ($date, 7, 1)='0'">
                <xsl:value-of select="substring ($date, 8, 1)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring ($date, 7, 2)"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text> </xsl:text>
        <!-- month -->
        <xsl:variable name="month" select="substring ($date, 5, 2)"/>
        <xsl:choose>
            <xsl:when test="$month='01'">
                <xsl:text>Jan </xsl:text>
            </xsl:when>
            <xsl:when test="$month='02'">
                <xsl:text>Feb </xsl:text>
            </xsl:when>
            <xsl:when test="$month='03'">
                <xsl:text>Mar </xsl:text>
            </xsl:when>
            <xsl:when test="$month='04'">
                <xsl:text>Apr </xsl:text>
            </xsl:when>
            <xsl:when test="$month='05'">
                <xsl:text>May </xsl:text>
            </xsl:when>
            <xsl:when test="$month='06'">
                <xsl:text>Jun </xsl:text>
            </xsl:when>
            <xsl:when test="$month='07'">
                <xsl:text>July </xsl:text>
            </xsl:when>
            <xsl:when test="$month='08'">
                <xsl:text>Aug </xsl:text>
            </xsl:when>
            <xsl:when test="$month='09'">
                <xsl:text>Sep </xsl:text>
            </xsl:when>
            <xsl:when test="$month='10'">
                <xsl:text>Oct </xsl:text>
            </xsl:when>
            <xsl:when test="$month='11'">
                <xsl:text>Nov </xsl:text>
            </xsl:when>
            <xsl:when test="$month='12'">
                <xsl:text>Dec </xsl:text>
            </xsl:when>
        </xsl:choose>
        <!-- year -->
        <xsl:value-of select="substring ($date, 1, 4)"/>
    </xsl:template>
    
    <xsl:template name="getProviderIndividualIdentifier">
        <xsl:param name="entityIdentifier"/>
        <xsl:if test="$entityIdentifier and
                      $entityIdentifier/@classCode and
                      $entityIdentifier/@classCode='IDENT' and
                      $entityIdentifier/ext:id and
                      not($entityIdentifier/ext:id/@displayble='false') and
                      $entityIdentifier/ext:id/@root and
                      string-length($entityIdentifier/ext:id/@root) &gt; 0">
            <xsl:choose>
                <!-- HI Service: HPI-I -->
                <xsl:when test="starts-with($entityIdentifier/ext:id/@root, '1.2.36.1.2001.1003.0.') and
                                $entityIdentifier/ext:id/@assigningAuthorityName='HPI-I' and
                                $entityIdentifier/ext:assigningGeographicArea/@classCode='PLC' and
                                $entityIdentifier/ext:assigningGeographicArea/ext:name='National Identifier'">
                    <xsl:variable name="identifier">
                        <xsl:value-of select="substring-after($entityIdentifier/ext:id/@root, '1.2.36.1.2001.1003.0.')"/>
                    </xsl:variable>
                    <xsl:element name="div">
                        <xsl:attribute name="class"><xsl:value-of select="$PROVIDER_INDIVIDUAL_IDENTIFIER_CSS_CLASS"/></xsl:attribute>
                        <xsl:text>[HPI-I: </xsl:text><xsl:call-template name="formatHI"><xsl:with-param name="hiValue"><xsl:value-of select="$identifier"/></xsl:with-param></xsl:call-template><xsl:text>]</xsl:text>
                    </xsl:element>
                </xsl:when>
                <!-- Identifiers Other than HI Service e.g. MRN, Medicare Provider Number, etc. -->
                <xsl:otherwise>
                    <xsl:call-template name="getNonHIServiceProviderIdentifierDiv">
                        <xsl:with-param name="entityIdentifier" select="$entityIdentifier"/>
                        <xsl:with-param name="providerIdentifierType"><xsl:value-of select="$PROVIDER_INDIVIDUAL_IDENTIFIER_CSS_CLASS"/></xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getProviderOrganisationIdentifier">
        <xsl:param name="entityIdentifier"/>
        
        <xsl:if test="$entityIdentifier and
                      $entityIdentifier/@classCode and
                      $entityIdentifier/@classCode='IDENT' and
                      $entityIdentifier/ext:id and
                      not($entityIdentifier/ext:id/@displayble='false') and
                      $entityIdentifier/ext:id/@root and
                      string-length($entityIdentifier/ext:id/@root) &gt; 0">
            <xsl:choose>
                <!-- HI Service: HPI-O -->
                <xsl:when test="starts-with($entityIdentifier/ext:id/@root, '1.2.36.1.2001.1003.0.') and
                    $entityIdentifier/ext:id/@assigningAuthorityName='HPI-O' and
                    $entityIdentifier/ext:assigningGeographicArea/@classCode='PLC' and
                    $entityIdentifier/ext:assigningGeographicArea/ext:name='National Identifier'">
                    <xsl:variable name="identifier">
                        <xsl:value-of select="substring-after($entityIdentifier/ext:id/@root, '1.2.36.1.2001.1003.0.')"/>
                    </xsl:variable>
                    <xsl:element name="div">
                        <xsl:attribute name="class"><xsl:value-of select="$PROVIDER_ORGANISATION_IDENTIFIER_CSS_CLASS"/></xsl:attribute>
                        <xsl:text>[HPI-O: </xsl:text><xsl:call-template name="formatHI"><xsl:with-param name="hiValue"><xsl:value-of select="$identifier"/></xsl:with-param></xsl:call-template><xsl:text>]</xsl:text>
                    </xsl:element>
                </xsl:when>
                <!-- Identifiers Other than HI Service e.g. Facility Identifier etc. -->
                <xsl:otherwise>
                    <xsl:call-template name="getNonHIServiceProviderIdentifierDiv">
                        <xsl:with-param name="entityIdentifier" select="$entityIdentifier"/>
                        <xsl:with-param name="providerIdentifierType"><xsl:value-of select="$PROVIDER_ORGANISATION_IDENTIFIER_CSS_CLASS"/></xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getNonHIServiceProviderIdentifierDiv">
        <xsl:param name="entityIdentifier"/>
        <xsl:param name="providerIdentifierType"/>
        
        <xsl:if test="$entityIdentifier/ext:code and
            $entityIdentifier/ext:code/@code and
            string-length($entityIdentifier/ext:code/@code) &gt; 0 and
            $entityIdentifier/ext:code/@codeSystem and
            $entityIdentifier/ext:code/@codeSystem='2.16.840.1.113883.12.203'">
            <xsl:variable name="identifier">
                <xsl:choose>
                    <xsl:when test="$entityIdentifier/ext:id/@extension and
                        string-length($entityIdentifier/ext:id/@extension) &gt; 0">
                        <xsl:value-of select="$entityIdentifier/ext:id/@extension"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="substring-after-last-occurance">
                            <xsl:with-param name="string" select="$entityIdentifier/ext:id/@root"/>
                            <xsl:with-param name="argument">.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="identifierType">
                <xsl:call-template name="getHL7V2Table0203IdentifierCodeDescription">
                    <xsl:with-param name="code" select="$entityIdentifier/ext:code/@code"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="identifierAssigningAuthorityName">
                <xsl:if test="$entityIdentifier/ext:id/@assigningAuthorityName and
                    string-length($entityIdentifier/ext:id/@assigningAuthorityName) &gt; 0">
                    <xsl:value-of select="$entityIdentifier/ext:id/@assigningAuthorityName"/>
                </xsl:if>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="$identifierAssigningAuthorityName and 
                    string-length($identifierAssigningAuthorityName) &gt; 0">
                    <xsl:element name="div">
                        <xsl:attribute name="class"><xsl:value-of select="$providerIdentifierType"/></xsl:attribute>
                        <xsl:text>[</xsl:text><xsl:value-of select="$identifierAssigningAuthorityName"/><xsl:text>: </xsl:text>    
                        <xsl:value-of select="$identifier"/>
                        <xsl:text>]</xsl:text>
                    </xsl:element> <!-- </div> -->
                    
                </xsl:when>
                <xsl:when test="$identifierType and 
                    string-length($identifierType) &gt; 0">
                    <xsl:element name="div">
                        <xsl:attribute name="class"><xsl:value-of select="$providerIdentifierType"/></xsl:attribute>
                        <xsl:text>[</xsl:text><xsl:value-of select="$identifierType"/><xsl:text>: </xsl:text>
                        <xsl:value-of select="$identifier"/>
                        <xsl:text>]</xsl:text>
                    </xsl:element> <!-- </div> -->
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="div">
                        <xsl:attribute name="class"><xsl:value-of select="$providerIdentifierType"/></xsl:attribute>
                        <xsl:text>[Local Identifier: </xsl:text>
                        <xsl:value-of select="$identifier"/>
                        <xsl:text>]</xsl:text>
                    </xsl:element> <!-- </div> -->
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="substring-after-last-occurance">
        <xsl:param name="string"/>
        <xsl:param name="argument"/>
        
        <xsl:if test="$string and
                      string-length($string) &gt; 0 and
                      $argument and
                      string-length($argument) &gt; 0">
            <xsl:choose>
                <xsl:when test="contains($string, $argument)">
                    <xsl:call-template name="substring-after-last-occurance">
                        <xsl:with-param name="string" select="substring-after($string, $argument)"/>
                        <xsl:with-param name="argument" select="$argument"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$string"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="getHL7V2Table0203IdentifierCodeDescription">
        <xsl:param name="code"/>
        
        <xsl:choose>
            <xsl:when test="$code='MR'">
                <xsl:text>MRN/URN</xsl:text>
            </xsl:when>
            <xsl:when test="$code='FI'">
                <xsl:text>Facility Identifier</xsl:text>
            </xsl:when>
            <xsl:when test="$code='SR'">
                <xsl:text>State Identifier</xsl:text>
            </xsl:when>
            <xsl:when test="$code='LR'">
                <xsl:text>Local Identifier</xsl:text>
            </xsl:when>
            <xsl:when test="$code='PRN'">
                <xsl:text>Provider Number</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
   
    <xsl:template name="toUpperCase">
        <xsl:param name="data"/>
        
        <xsl:if test="$data">
            <xsl:value-of select="translate($data,'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
        </xsl:if>
    </xsl:template>
   
    <xsl:template name="calculateAgeInYears">
        <xsl:param name="birthDate"/>
        <xsl:param name="docDate"/>
    
        <xsl:variable name="birthYear" select="substring($birthDate,1,4)"/>
        <xsl:variable name="birthMonth" select="substring($birthDate,5,2)"/>
        <xsl:variable name="birthDay" select="substring($birthDate,7,2)"/>
    
        <xsl:variable name="currentYear" select="substring($docDate,1,4)"/>
        <xsl:variable name="currentMonth" select="substring($docDate,5,2)"/>
        <xsl:variable name="currentDay" select="substring($docDate,7,2)"/>
    
        <xsl:variable name="startAge" select="$currentYear - $birthYear"/>
        <xsl:choose>
            <xsl:when test="$currentMonth &lt; $birthMonth">
                <xsl:variable name="age" select="$startAge - 1"/>
                <xsl:value-of select="$age"/>
            </xsl:when>
            <xsl:when test="$currentMonth = $birthMonth">
                <xsl:choose>
                    <xsl:when test="$currentDay &lt; $birthDay">
                        <xsl:variable name="age" select="$startAge - 1"/>
                        <xsl:value-of select="$age"/>
                    </xsl:when>
    			    <xsl:otherwise>
                        <xsl:variable name="age" select="$startAge"/>
                        <xsl:value-of select="$age"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="age" select="$startAge"/>
                <xsl:value-of select="$age"/>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	   
    <xsl:template name="formatHI">
        <xsl:param name="hiValue"/>
        <xsl:if test="$hiValue">
            <xsl:variable name="identifier">
                <xsl:call-template name="trim">
                    <xsl:with-param name="string">
                        <xsl:choose>
                            <xsl:when test="string-length($hiValue) &gt; 16">
                                <xsl:value-of select="substring($hiValue, string-length($hiValue)-15, string-length($hiValue))"/>
                            </xsl:when>
                            <xsl:when test="string-length($hiValue) = 16">
                                <xsl:value-of select="$hiValue"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:if test="string-length($identifier)=16">
                <xsl:value-of select="substring($identifier,1,4)"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="substring($identifier,5,4)"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="substring($identifier,9,4)"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="substring($identifier,13,4)"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="printNBSPs">
        <xsl:param name="number"/>
        
        <xsl:if test="$number &gt; 0">
            <xsl:element name="span">
                <xsl:attribute name="class">nbspSpan</xsl:attribute>
            </xsl:element>
            <xsl:call-template name="printNBSPs">
                <xsl:with-param name="number" select="$number - 1"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="lTrim">
      <xsl:param name="string"/>
      <xsl:choose>
         <xsl:when test="substring($string, 1, 1) = ''">
            <xsl:value-of select="$string"/>
         </xsl:when>
         <xsl:when test="normalize-space(substring($string, 1, 1)) = ''">
            <xsl:call-template name="lTrim">
               <xsl:with-param name="string" select="substring($string, 2)"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$string"/>
         </xsl:otherwise>
      </xsl:choose>
    </xsl:template>
   
    <xsl:template name="rTrim">
      <xsl:param name="string"/>
      <xsl:choose>
         <xsl:when test="substring($string, 1, 1) = ''">
            <xsl:value-of select="$string"/>
         </xsl:when>
         <xsl:when test="normalize-space(substring($string, string-length($string))) = ''">
            <xsl:call-template name="rTrim">
               <xsl:with-param name="string" select="substring($string, 1, string-length($string) - 1)"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$string"/>
         </xsl:otherwise>
      </xsl:choose>
    </xsl:template>
      
    <xsl:template name="trim">
      <xsl:param name="string"/>
      <xsl:call-template name="rTrim">
         <xsl:with-param name="string">
            <xsl:call-template name="lTrim">
               <xsl:with-param name="string" select="$string"/>
            </xsl:call-template>
         </xsl:with-param>
      </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="lastIndexOf">
        <xsl:param name="string" />
        <xsl:param name="char" />
        <xsl:choose>
            <!-- if the string contains the character... -->
            <xsl:when test="contains($string, $char)">
                <!-- call the template recursively... -->
                <xsl:call-template name="lastIndexOf">
                    <!-- with the string being the string after the character
                    -->
                    <xsl:with-param name="string"
                        select="substring-after($string, $char)" />
                    <!-- and the character being the same as before -->
                    <xsl:with-param name="char" select="$char" />
                </xsl:call-template>
            </xsl:when>
            <!-- otherwise, return the value of the string -->
            <xsl:otherwise><xsl:value-of select="$string" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getIdentifierFromII">
       <xsl:param name="iiVariable"/>
       <xsl:choose>
           <xsl:when test="string-length($iiVariable/@root)>0 and string-length($iiVariable/@extension)>0">
               <xsl:value-of select="$iiVariable/@extension"/>
           </xsl:when>
           <xsl:when test="string-length($iiVariable/@root)>0">
               <xsl:call-template name="lastIndexOf"><xsl:with-param name="string" select="$iiVariable/@root"/><xsl:with-param name="char" select="'.'"/></xsl:call-template>
           </xsl:when>
       </xsl:choose>
    </xsl:template>

    <xsl:template name="addID">
        <xsl:param name="element"/>
        <xsl:if test="$element/@ID and
                      string-length($element/@ID) &gt; 0">
            <xsl:attribute name="id"><xsl:value-of select="$element/@ID"/></xsl:attribute>
        </xsl:if>
    </xsl:template>

    <!--================================================================================================================================================================================-->
    <!-- [END] UTILITY TEMPLATES -->
</xsl:stylesheet>
