/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.datatypes;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class XPN {
    private static final int XPN_COMPONENT_COUNT = 5;
    private final String familyName;
    private final String givenName;
    private final String middleInitialOrName;
    private final String suffix;
    private final String prefix;

    private XPN(Builder builder) {
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.middleInitialOrName = builder.middleInitialOrName;
        this.suffix = builder.suffix;
        this.prefix = builder.prefix;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMiddleInitialOrName() {
        return this.middleInitialOrName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.familyName);
        sb.append("^");
        sb.append(this.givenName);
        sb.append("^");
        sb.append(this.middleInitialOrName);
        sb.append("^");
        sb.append(this.suffix);
        sb.append("^");
        sb.append(this.prefix);
        return sb.toString().replaceAll(String.format("\\%s*$", "^"), "");
    }

    public static XPN parse(String value) {
        ArgumentUtils.checkNotNull((Object)value, (String)"value");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(value.split("\\^")));
        while (values.size() < 5) {
            values.add("");
        }
        if (values.size() == 5) {
            try {
                return new Builder().familyName((String)values.get(0)).givenName((String)values.get(1)).middleInitialOrName((String)values.get(2)).suffix((String)values.get(3)).prefix((String)values.get(4)).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse XPN", e);
            }
        }
        throw new IllegalArgumentException("Unable to parse XPN - Invalid number of value components:\n\tActual: " + values.size() + "\n\tExpected: " + 5);
    }

    public static final class Builder {
        private String familyName = "";
        private String givenName = "";
        private String middleInitialOrName = "";
        private String suffix = "";
        private String prefix = "";

        public Builder familyName(String value) {
            this.familyName = value;
            return this;
        }

        public Builder givenName(String value) {
            this.givenName = value;
            return this;
        }

        public Builder middleInitialOrName(String value) {
            this.middleInitialOrName = value;
            return this;
        }

        public Builder suffix(String value) {
            this.suffix = value;
            return this;
        }

        public Builder prefix(String value) {
            this.prefix = value;
            return this;
        }

        public XPN build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("familyName", this.familyName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("givenName", this.givenName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("middleInitialOrName", this.middleInitialOrName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("suffix", this.suffix, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("prefix", this.prefix, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid XPN", failedVariables);
            }
            return new XPN(this);
        }
    }
}

