/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.segments;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.datatypes.CX;
import au.gov.nehta.vendorlibrary.mdm.datatypes.XAD;
import au.gov.nehta.vendorlibrary.mdm.datatypes.XPN;
import au.gov.nehta.vendorlibrary.mdm.enums.Sex;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class PID {
    private static final String PID_SEGMENT_NAME = "PID";
    private static final int PID_FIELD_COUNT = 12;
    private static final String PID_DATE_OF_BIRTH_PATTERN = "yyyyMMdd";
    private static final int SET_ID = 1;
    private final List<CX> patientIdentifiers;
    private final XPN patientName;
    private final Date dateTimeOfBirth;
    private final Sex sex;
    private final XAD patientAddress;

    private PID(Builder builder) {
        this.patientIdentifiers = builder.patientIdentifiers;
        this.patientName = builder.patientName;
        this.dateTimeOfBirth = builder.dateTimeOfBirth;
        this.sex = builder.sex;
        this.patientAddress = builder.patientAddress;
    }

    public int getSetId() {
        return 1;
    }

    public List<CX> getPatientIdentifiers() {
        return this.patientIdentifiers;
    }

    public XPN getPatientName() {
        return this.patientName;
    }

    public Date getDateTimeOfBirth() {
        return this.dateTimeOfBirth;
    }

    public Sex getSex() {
        return this.sex;
    }

    public XAD getPatientAddress() {
        return this.patientAddress;
    }

    public static PID parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        List<String> fields = Arrays.asList(parseValue.split("\\|"));
        if (fields.size() >= 12) {
            if (fields.get(0).compareTo(PID_SEGMENT_NAME) != 0) {
                throw new IllegalArgumentException(String.format("Unable to parse PID - Segment name is incorrect: \n\tActual Value: %s\n\tExpected Value: %s", fields.get(0), PID_SEGMENT_NAME));
            }
            try {
                return new Builder().patientIdentifiers(CX.parseMultiple(fields.get(3), "~")).patientName(XPN.parse(fields.get(5))).dateTimeOfBirth(new SimpleDateFormat(PID_DATE_OF_BIRTH_PATTERN).parse(fields.get(7))).sex(Sex.valueOf(fields.get(8))).patientAddress(XAD.parse(fields.get(11))).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse PID", e);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse PID - Invalid date/time pattern supplied:\n\tActual Value: %s\n\tExpected Format: %s", fields.get(7), PID_DATE_OF_BIRTH_PATTERN));
            }
        }
        throw new IllegalArgumentException("Unable to parse PID - Invalid number of fields:\n\tActual: " + fields.size() + "\n\tExpected: " + 12);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PID_SEGMENT_NAME);
        sb.append("|");
        sb.append(1);
        sb.append("|");
        sb.append("|");
        for (CX identifier : this.patientIdentifiers) {
            sb.append(identifier.toString());
            sb.append("~");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("|");
        sb.append("|");
        sb.append(this.patientName.toString());
        sb.append("|");
        sb.append("|");
        sb.append(new SimpleDateFormat(PID_DATE_OF_BIRTH_PATTERN).format(this.dateTimeOfBirth));
        sb.append("|");
        sb.append((Object)this.sex);
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append(this.patientAddress.toString());
        sb.append("\r");
        return sb.toString();
    }

    public static final class Builder {
        private List<CX> patientIdentifiers;
        private XPN patientName;
        private Date dateTimeOfBirth;
        private Sex sex;
        private XAD patientAddress;

        public Builder patientIdentifiers(List<CX> values) {
            this.patientIdentifiers = values;
            return this;
        }

        public Builder patientName(XPN value) {
            this.patientName = value;
            return this;
        }

        public Builder dateTimeOfBirth(Date value) {
            this.dateTimeOfBirth = value;
            return this;
        }

        public Builder patientAddress(XAD value) {
            this.patientAddress = value;
            return this;
        }

        public Builder sex(Sex value) {
            this.sex = value;
            return this;
        }

        public PID build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            if (!MDMValidation.isNullOrEmpty(this.patientIdentifiers)) {
                for (CX patientIdentifier : this.patientIdentifiers) {
                    MDMValidation.confirmNotNull("patientIdentifiers - patientIdentifier", patientIdentifier, true);
                }
            } else {
                failedVariables.putAll(MDMValidation.confirmNotNullNorEmpty("patientIdentifiers", this.patientIdentifiers, true));
            }
            failedVariables.putAll(MDMValidation.confirmNotNull("patientName", this.patientName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("dateTimeOfBirth", this.dateTimeOfBirth, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("sex", (Object)this.sex, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("patientAddress", this.patientAddress, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid PID segment", failedVariables);
            }
            return new PID(this);
        }
    }
}

