/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.segments;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.datatypes.XCN;
import au.gov.nehta.vendorlibrary.mdm.enums.PatientClass;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class PV1 {
    private static final String PV1_SEGMENT_NAME = "PV1";
    private static final int PV1_FIELD_COUNT = 10;
    private static final int SET_ID = 1;
    private final PatientClass patientClass;
    private final XCN consultingDoctor;

    private PV1(Builder builder) {
        this.patientClass = builder.patientClass;
        this.consultingDoctor = builder.consultingDoctor;
    }

    public int getSetId() {
        return 1;
    }

    public PatientClass getPatientClass() {
        return this.patientClass;
    }

    public XCN getConsultingDoctor() {
        return this.consultingDoctor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PV1_SEGMENT_NAME);
        sb.append("|");
        sb.append(1);
        sb.append("|");
        sb.append((Object)this.patientClass);
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append(this.consultingDoctor);
        sb.append("\r");
        return sb.toString();
    }

    public static PV1 parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(parseValue.split("\\|")));
        if (fields.size() >= 10) {
            if (((String)fields.get(0)).compareTo(PV1_SEGMENT_NAME) != 0) {
                throw new IllegalArgumentException(String.format("Unable to parse PV1 - Segment name is incorrect: \n\tActual Value: %s\n\tExpected Value: %s", fields.get(0), PV1_SEGMENT_NAME));
            }
            try {
                return new Builder().patientClass(PatientClass.valueOf((String)fields.get(2))).consultingDoctor(XCN.parse((String)fields.get(9))).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse PV1", e);
            }
        }
        throw new IllegalArgumentException("Unable to parse PV1 - Invalid number of value components:\n\tActual: " + fields.size() + "\n\tExpected: " + 10);
    }

    public static final class Builder {
        private PatientClass patientClass;
        private XCN consultingDoctor;

        public Builder patientClass(PatientClass value) {
            this.patientClass = value;
            return this;
        }

        public Builder consultingDoctor(XCN value) {
            this.consultingDoctor = value;
            return this;
        }

        public PV1 build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("patientClass", (Object)this.patientClass, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("consultingDoctor", this.consultingDoctor, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid PV1 segment", failedVariables);
            }
            return new PV1(this);
        }
    }
}

