/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MDMValidation {
    private MDMValidation() {
    }

    public static Map<String, List<String>> confirmNotNullNorBlank(String name, String value, boolean required) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (MDMValidation.isNullOrBlank(value) && required) {
            messages.add(name + " cannot be null nor blank");
            result.put(name, messages);
        } else if (MDMValidation.isNullOrBlank(value) && !required) {
            result.clear();
        }
        if (messages.size() > 0) {
            result.put(name, messages);
        }
        return result;
    }

    public static Map<String, List<String>> confirmNotNull(String name, Object value, boolean required) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (MDMValidation.isNull(value) && required) {
            messages.add(name + " cannot be null");
            result.put(name, messages);
        } else if (MDMValidation.isNull(value) && !required) {
            result.clear();
        }
        if (messages.size() > 0) {
            result.put(name, messages);
        }
        return result;
    }

    public static Map<String, List<String>> confirmNotNullNorEmpty(String name, Collection collection, boolean required) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> messages = new ArrayList<String>();
        if (MDMValidation.isNullOrEmpty(collection) && required) {
            messages.add(name + " collection cannot be null nor empty");
            result.put(name, messages);
        } else if (MDMValidation.isNotNull(collection) && !required) {
            result.clear();
        }
        if (messages.size() > 0) {
            result.put(name, messages);
        }
        return result;
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    private static boolean isNullOrBlank(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    private static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNotNull(Object value) {
        return value != null;
    }
}

