/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.datatypes;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class XAD {
    private static final int XAD_COMPONENT_COUNT = 6;
    private final String firstLine;
    private final String secondLine;
    private final String city;
    private final String state;
    private final int postCode;
    private final String country;

    private XAD(Builder builder) {
        this.firstLine = builder.firstLine;
        this.secondLine = builder.secondLine;
        this.city = builder.city;
        this.state = builder.state;
        this.postCode = builder.postCode;
        this.country = builder.country;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public String getSecondLine() {
        return this.secondLine;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public int getPostCode() {
        return this.postCode;
    }

    public String getCountry() {
        return this.country;
    }

    public static XAD parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(parseValue.split("\\^")));
        while (values.size() < 6) {
            values.add("");
        }
        if (values.size() == 6) {
            try {
                return new Builder().firstLine((String)values.get(0)).secondLine((String)values.get(1)).city((String)values.get(2)).state((String)values.get(3)).postCode(Integer.parseInt((String)values.get(4))).country((String)values.get(5)).build();
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse XAD - post code value is not a valid integer", e);
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse XAD", e);
            }
        }
        throw new IllegalArgumentException("Unable to parse XAD - Invalid number of value components:\n\tActual: " + values.size() + "\n\tExpected: " + 6);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.firstLine);
        sb.append("^");
        sb.append(this.secondLine);
        sb.append("^");
        sb.append(this.city);
        sb.append("^");
        sb.append(this.state);
        sb.append("^");
        sb.append(this.postCode);
        sb.append("^");
        sb.append(this.country);
        return sb.toString().replaceAll(String.format("\\%s*$", "^"), "");
    }

    public static final class Builder {
        private String firstLine = "";
        private String secondLine = "";
        private String city = "";
        private String state = "";
        private int postCode;
        private String country = "";

        public Builder firstLine(String value) {
            this.firstLine = value;
            return this;
        }

        public Builder secondLine(String value) {
            this.secondLine = value;
            return this;
        }

        public Builder city(String value) {
            this.city = value;
            return this;
        }

        public Builder state(String value) {
            this.state = value;
            return this;
        }

        public Builder postCode(int value) {
            this.postCode = value;
            return this;
        }

        public Builder country(String value) {
            this.country = value;
            return this;
        }

        public XAD build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("firstLine", this.firstLine, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("secondLine", this.secondLine, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("city", this.city, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("state", this.state, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("postCode", this.postCode, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("country", this.country, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid XAD", failedVariables);
            }
            return new XAD(this);
        }
    }
}

