/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.segments;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.datatypes.CE;
import au.gov.nehta.vendorlibrary.mdm.enums.DataType;
import au.gov.nehta.vendorlibrary.mdm.enums.Result;
import au.gov.nehta.vendorlibrary.mdm.enums.ValueType;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class OBX {
    private static final int OBX_FIELD_COUNT = 12;
    private static final String OBX_SEGMENT_NAME = "OBX";
    private static final int SET_ID = 1;
    private static final ValueType VALUE_TYPE = ValueType.ED;
    private final CE observationIdentifier;
    private static final String SOURCE_APPLICATION = "";
    private final DataType DATA_TYPE = DataType.ZIP;
    private static final String DATA_ENCODING = "base64";
    private final String encodedData;
    private static final Result OBSERVATION_RESULT = Result.F;

    private OBX(Builder builder) {
        ArgumentUtils.checkNotNull((Object)builder, (String)"builder");
        this.observationIdentifier = builder.observationIdentifier;
        this.encodedData = builder.encodedData;
    }

    public int getSetId() {
        return 1;
    }

    public ValueType getValueType() {
        return VALUE_TYPE;
    }

    public CE getObservationIdentifier() {
        return this.observationIdentifier;
    }

    public String getSourceApplication() {
        return SOURCE_APPLICATION;
    }

    public DataType getDataType() {
        return this.DATA_TYPE;
    }

    public String getDataEncoding() {
        return DATA_ENCODING;
    }

    public String getEncodedData() {
        return this.encodedData;
    }

    public Result getObservationResult() {
        return OBSERVATION_RESULT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OBX_SEGMENT_NAME);
        sb.append("|");
        sb.append(1);
        sb.append("|");
        sb.append((Object)VALUE_TYPE);
        sb.append("|");
        sb.append(this.observationIdentifier.toString());
        sb.append("|");
        sb.append("|");
        sb.append(SOURCE_APPLICATION);
        sb.append("^");
        sb.append(this.DATA_TYPE.getDataType());
        sb.append("^");
        sb.append(this.DATA_TYPE.getDataSubType());
        sb.append("^");
        sb.append(DATA_ENCODING);
        sb.append("^");
        sb.append(this.encodedData);
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append((Object)OBSERVATION_RESULT);
        sb.append("\r");
        return sb.toString();
    }

    public static OBX parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        List<String> fields = Arrays.asList(parseValue.split("\\|"));
        if (fields.size() >= 12) {
            if (fields.get(0).compareTo(OBX_SEGMENT_NAME) != 0) {
                throw new IllegalArgumentException(String.format("Unable to parse OBX - Segment name is incorrect: \n\tActual Value: %s\n\tExpected Value: %s", fields.get(0), OBX_SEGMENT_NAME));
            }
            Builder builder = new Builder().observationIdentifier(CE.parse(fields.get(3)));
            List<String> observationValue = Arrays.asList(fields.get(5).split("\\^"));
            builder.encodedData(observationValue.get(4));
            try {
                return builder.build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse OBX", e);
            }
        }
        throw new IllegalArgumentException(String.format("Unable to parse OBX - Invalid number of fields:\n\tActual: %d\n\tExpected: %d", fields.size(), 12));
    }

    public static final class Builder {
        private CE observationIdentifier;
        private String encodedData = "";

        public Builder observationIdentifier(CE value) {
            this.observationIdentifier = value;
            return this;
        }

        public Builder encodedData(String value) {
            this.encodedData = value;
            return this;
        }

        public OBX build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            if (MDMValidation.isNotNull(this.observationIdentifier)) {
                failedVariables.putAll(MDMValidation.confirmNotNull("observationIdentifier - identifier", this.observationIdentifier.getIdentifier(), true));
                failedVariables.putAll(MDMValidation.confirmNotNull("observationIdentifier - text", this.observationIdentifier.getText(), true));
                failedVariables.putAll(MDMValidation.confirmNotNull("observationIdentifier - codingSystem", (Object)this.observationIdentifier.getCodingSystem(), true));
            } else {
                failedVariables.putAll(MDMValidation.confirmNotNull("observationIdentifier", this.observationIdentifier, true));
            }
            failedVariables.putAll(MDMValidation.confirmNotNullNorBlank("Observation Value - encodedData", this.encodedData, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid OBX segment", failedVariables);
            }
            return new OBX(this);
        }
    }
}

