/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.segments;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.enums.DocumentCompletionStatus;
import au.gov.nehta.vendorlibrary.mdm.enums.DocumentContentPresentation;
import au.gov.nehta.vendorlibrary.mdm.enums.DocumentType;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public final class TXA {
    private static final String TXA_SEGMENT_NAME = "TXA";
    private static final int TXA_FIELD_COUNT = 18;
    private static final String TXA_DATE_TIME_PATTERN = "yyyyMMddHHmmss";
    private static final int SET_ID = 1;
    private static final DocumentType DOCUMENT_TYPE = DocumentType.NEHTA;
    private static final DocumentContentPresentation DOCUMENT_CONTENT_PRESENTATION = DocumentContentPresentation.AP;
    private final Date activityDateTime;
    private final UUID uniqueDocumentNumber;
    private final String uniqueDocumentFileName;
    private static final DocumentCompletionStatus DOCUMENT_COMPLETION_STATUS = DocumentCompletionStatus.LA;

    private TXA(Builder builder) {
        this.activityDateTime = builder.activityDateTime;
        this.uniqueDocumentNumber = builder.uniqueDocumentNumber;
        this.uniqueDocumentFileName = builder.uniqueDocumentFileName;
    }

    public int getSetId() {
        return 1;
    }

    public DocumentType getDocumentType() {
        return DOCUMENT_TYPE;
    }

    public DocumentContentPresentation getDocumentContentPresentation() {
        return DOCUMENT_CONTENT_PRESENTATION;
    }

    public Date getActivityDateTime() {
        return this.activityDateTime;
    }

    public UUID getUniqueDocumentNumber() {
        return this.uniqueDocumentNumber;
    }

    public String getUniqueDocumentFileName() {
        return this.uniqueDocumentFileName;
    }

    public DocumentCompletionStatus getDocumentCompletionStatus() {
        return DOCUMENT_COMPLETION_STATUS;
    }

    public static TXA parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        List<String> fields = Arrays.asList(parseValue.split("\\|"));
        if (fields.size() >= 18) {
            if (fields.get(0).compareTo(TXA_SEGMENT_NAME) != 0) {
                throw new IllegalArgumentException(String.format("Unable to parse TXA - Segment name is incorrect: \n\tActual Value: %s\n\tExpected Value: %s", fields.get(0), TXA_SEGMENT_NAME));
            }
            try {
                return new Builder().activityDateTime(new SimpleDateFormat(TXA_DATE_TIME_PATTERN).parse(fields.get(4))).uniqueDocumentNumber(UUID.fromString(fields.get(12))).uniqueDocumentFileName(fields.get(16)).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse TXA", e);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse TXA - Invalid date/time pattern supplied:\n\tActual Value: %s\n\tExpected Format: %s", fields.get(4), TXA_DATE_TIME_PATTERN));
            }
        }
        throw new IllegalArgumentException("Unable to parse TXA - Invalid number of fields:\n\tActual: " + fields.size() + "\n\tExpected: " + 18);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TXA_SEGMENT_NAME);
        sb.append("|");
        sb.append(1);
        sb.append("|");
        sb.append((Object)DOCUMENT_TYPE);
        sb.append("|");
        sb.append((Object)DOCUMENT_CONTENT_PRESENTATION);
        sb.append("|");
        sb.append(new SimpleDateFormat(TXA_DATE_TIME_PATTERN).format(this.activityDateTime));
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append(this.uniqueDocumentNumber);
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append(this.uniqueDocumentFileName);
        sb.append("|");
        sb.append((Object)DOCUMENT_COMPLETION_STATUS);
        sb.append("\r");
        return sb.toString();
    }

    public static final class Builder {
        private UUID uniqueDocumentNumber;
        private Date activityDateTime;
        private String uniqueDocumentFileName = "";

        public Builder uniqueDocumentNumber(UUID value) {
            this.uniqueDocumentNumber = value;
            return this;
        }

        public Builder activityDateTime(Date value) {
            this.activityDateTime = value;
            return this;
        }

        public Builder uniqueDocumentFileName(String value) {
            this.uniqueDocumentFileName = value;
            return this;
        }

        public TXA build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("activityDateTime", this.activityDateTime, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("uniqueDocumentNumber", this.uniqueDocumentNumber, true));
            failedVariables.putAll(MDMValidation.confirmNotNullNorBlank("uniqueDocumentFileName", this.uniqueDocumentFileName, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid TXA segment", failedVariables);
            }
            return new TXA(this);
        }
    }
}

