/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.common.utils.IOUtils;
import au.gov.nehta.common.utils.SimpleXsdResourceResolver;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class XsdUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsdUtils.class);

    public static void validate(File dataFile, File schemaFile) throws SAXException, IOException, ParserConfigurationException {
        assert (dataFile != null) : "'dataFile' is null.";
        assert (schemaFile != null) : "'schemaFile' is null.";
        Document dataNode = DomUtils.parse(dataFile);
        Document schemaNode = DomUtils.parse(schemaFile);
        XsdUtils xsdUtils = new XsdUtils();
        xsdUtils.getClass();
        XsdUtils.validate(dataNode, schemaNode, xsdUtils.new FileXsdResourceResolver(schemaFile.getParentFile()));
    }

    public static void validate(Node dataNode, Node schemaNode) throws SAXException, IOException {
        XsdUtils.validate(dataNode, schemaNode, null);
    }

    public static void validate(Node dataNode, Node schemaNode, LSResourceResolver xsdResourceResolver) throws SAXException, IOException {
        assert (dataNode != null) : "'dataNode' is null.";
        assert (schemaNode != null) : "'schemaNode' is null.";
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (xsdResourceResolver != null) {
            schemaFactory.setResourceResolver(xsdResourceResolver);
        }
        DOMSource xsdSource = new DOMSource(schemaNode);
        Schema schema = schemaFactory.newSchema(xsdSource);
        Validator validator = schema.newValidator();
        DOMSource dataSource = new DOMSource(dataNode);
        validator.validate(dataSource);
    }

    private XsdUtils() {
    }

    private class FileXsdResourceResolver
    extends SimpleXsdResourceResolver {
        private File baseDir;

        public FileXsdResourceResolver(File baseDir) {
            this.baseDir = baseDir;
        }

        @Override
        protected String resolve(String namespaceURI, String systemId) {
            File refXsdFile = new File(this.baseDir, systemId);
            try {
                return IOUtils.read(refXsdFile);
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't load file: " + refXsdFile + ".", (Throwable)e);
                return null;
            }
        }
    }
}

