/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.core;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.segments.EVN;
import au.gov.nehta.vendorlibrary.mdm.segments.MSH;
import au.gov.nehta.vendorlibrary.mdm.segments.OBX;
import au.gov.nehta.vendorlibrary.mdm.segments.PID;
import au.gov.nehta.vendorlibrary.mdm.segments.PV1;
import au.gov.nehta.vendorlibrary.mdm.segments.TXA;
import java.util.ArrayList;
import java.util.Arrays;

public class Message {
    private static final int SEGMENT_COUNT = 6;
    private static final int MSH_INDEX = 0;
    private static final int EVN_INDEX = 1;
    private static final int PID_INDEX = 2;
    private static final int PV1_INDEX = 3;
    private static final int TXA_INDEX = 4;
    private static final int OBX_INDEX = 5;
    private final MSH mshSegment;
    private final EVN evnSegment;
    private final PID pidSegment;
    private final PV1 pv1Segment;
    private final TXA txaSegment;
    private final OBX obxSegment;

    public Message(MSH mshSegment, EVN evnSegment, PID pidSegment, PV1 pv1Segment, TXA txaSegment, OBX obxSegment) {
        ArgumentUtils.checkNotNull((Object)mshSegment, (String)"mshSegment");
        ArgumentUtils.checkNotNull((Object)evnSegment, (String)"evnSegment");
        ArgumentUtils.checkNotNull((Object)pidSegment, (String)"pidSegment");
        ArgumentUtils.checkNotNull((Object)pv1Segment, (String)"pv1Segment");
        ArgumentUtils.checkNotNull((Object)txaSegment, (String)"txaSegment");
        ArgumentUtils.checkNotNull((Object)obxSegment, (String)"obxSegment");
        this.mshSegment = mshSegment;
        this.evnSegment = evnSegment;
        this.pidSegment = pidSegment;
        this.pv1Segment = pv1Segment;
        this.txaSegment = txaSegment;
        this.obxSegment = obxSegment;
    }

    public final MSH getMshSegment() {
        return this.mshSegment;
    }

    public final EVN getEvnSegment() {
        return this.evnSegment;
    }

    public final PID getPidSegment() {
        return this.pidSegment;
    }

    public final PV1 getPv1Segment() {
        return this.pv1Segment;
    }

    public final TXA getTxaSegment() {
        return this.txaSegment;
    }

    public final OBX getObxSegment() {
        return this.obxSegment;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mshSegment.toString());
        sb.append(this.evnSegment.toString());
        sb.append(this.pidSegment.toString());
        sb.append(this.pv1Segment.toString());
        sb.append(this.txaSegment.toString());
        sb.append(this.obxSegment.toString());
        return sb.toString();
    }

    public static Message parse(String parseValue) {
        ArgumentUtils.checkNotNullNorBlank((String)parseValue, (String)"parseValue");
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(parseValue.split("\r")));
        if (segments.size() == 6) {
            return new Message(MSH.parse((String)segments.get(0)), EVN.parse((String)segments.get(1)), PID.parse((String)segments.get(2)), PV1.parse((String)segments.get(3)), TXA.parse((String)segments.get(4)), OBX.parse((String)segments.get(5)));
        }
        throw new IllegalArgumentException("Unable to parse message - Invalid number of segments:\n\tActual: " + segments.size() + "\n\tExpected: " + 6);
    }
}

