/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.datatypes;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class HD {
    private static final int HD_COMPONENT_COUNT = 3;
    private final String namespace;
    private final String identifier;
    private final String identifierType;

    private HD(Builder builder) {
        this.namespace = builder.namespace;
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public static HD parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(parseValue.split("\\^")));
        while (values.size() < 3) {
            values.add("");
        }
        if (values.size() == 3) {
            try {
                return new Builder().namespace((String)values.get(0)).identifier((String)values.get(1)).identifierType((String)values.get(2)).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse HD", e);
            }
        }
        throw new IllegalArgumentException("Unable to parse HD - Invalid number of value components:\n\tActual: " + values.size() + "\n\tExpected: " + 3);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.namespace);
        sb.append("^");
        sb.append(this.identifier);
        sb.append("^");
        sb.append(this.identifierType);
        return sb.toString().replaceAll(String.format("\\%s*$", "^"), "");
    }

    public static final class Builder {
        private String namespace = "";
        private String identifier = "";
        private String identifierType = "";

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder identifier(String value) {
            this.identifier = value;
            return this;
        }

        public Builder identifierType(String value) {
            this.identifierType = value;
            return this;
        }

        public HD build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("identifier", this.identifier, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("identifierType", this.identifierType, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("namespace", this.namespace, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid HD", failedVariables);
            }
            return new HD(this);
        }
    }
}

