/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class KeystoreUtil {
    private static final Logger LOG = Logger.getLogger(KeystoreUtil.class.getName());

    private KeystoreUtil() {
    }

    public static KeyStore loadKeyStore(String keystoreType, String keystorePassword, String keystorePathname) throws GeneralSecurityException {
        KeyStore keystore = null;
        InputStream in = null;
        ArgumentUtils.checkNotNullNorBlank((String)keystoreType, (String)"keystoreType");
        ArgumentUtils.checkNotNullNorBlank((String)keystorePassword, (String)"keystorePassword");
        ArgumentUtils.checkNotNullNorBlank((String)keystorePathname, (String)"keystorePathname");
        try {
            keystore = KeyStore.getInstance(keystoreType);
            File store = new File(keystorePathname);
            in = store.exists() ? new FileInputStream(keystorePathname) : null;
            keystore.load(in, keystorePassword.toCharArray());
            if (in == null) {
                throw new FileNotFoundException("File not found " + keystorePathname);
            }
            in.close();
            in = null;
            LOG.info("Keystore " + keystorePathname + " loaded");
        }
        catch (KeyStoreException e) {
            throw new GeneralSecurityException("getInstance(" + keystoreType + ") error", e);
        }
        catch (FileNotFoundException ex) {
            throw new GeneralSecurityException("Couldn't find truststore " + keystorePathname, ex);
        }
        catch (IOException ex) {
            throw new GeneralSecurityException(ex.getMessage(), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new GeneralSecurityException(ex.getMessage(), ex);
        }
        catch (CertificateException ex) {
            throw new GeneralSecurityException("Certificate error", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new GeneralSecurityException(ex.getMessage(), ex);
            }
        }
        return keystore;
    }

    public static X509Certificate getSigningCertificate(String keystoreType, String keystorePassword, String keystorePathname, String certificateAlias) throws GeneralSecurityException {
        KeyStore localKeystore = KeystoreUtil.loadKeyStore(keystoreType, keystorePassword, keystorePathname);
        return KeystoreUtil.getSigningCertificate(localKeystore, certificateAlias);
    }

    public static X509Certificate getSigningCertificate(KeyStore keystore, String certificateAlias) throws GeneralSecurityException {
        ArgumentUtils.checkNotNull((Object)keystore, (String)"keystore");
        ArgumentUtils.checkNotNullNorBlank((String)certificateAlias, (String)"certificateAlias");
        try {
            Certificate certificate = keystore.getCertificate(certificateAlias);
            return certificate != null ? (X509Certificate)certificate : null;
        }
        catch (KeyStoreException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static PrivateKey getSigningPrivateKey(String keystoreType, String keystorePassword, String keystorePathname, String privateKeyAlias) throws GeneralSecurityException {
        KeyStore localKeystore = KeystoreUtil.loadKeyStore(keystoreType, keystorePassword, keystorePathname);
        return KeystoreUtil.getSigningPrivateKey(localKeystore, keystorePassword, privateKeyAlias);
    }

    public static PrivateKey getSigningPrivateKey(KeyStore keystore, String keystorePassword, String privateKeyAlias) throws GeneralSecurityException {
        ArgumentUtils.checkNotNull((Object)keystore, (String)"keystore");
        ArgumentUtils.checkNotNullNorBlank((String)privateKeyAlias, (String)"privateKeyAlias");
        ArgumentUtils.checkNotNullNorBlank((String)keystorePassword, (String)"keystorePassword");
        ArgumentUtils.checkNotNull((Object)keystore.containsAlias(privateKeyAlias), (String)"keystore.containsAlias(privateKeyAlias)");
        try {
            Key key = keystore.getKey(privateKeyAlias, keystorePassword.toCharArray());
            return key != null ? (PrivateKey)key : null;
        }
        catch (KeyStoreException e) {
            throw new GeneralSecurityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(String privateKeyStoreType, String privateKeyStoreFile, String privateKeyStorePassword, String privateKeyPassword, String privateKeyAlias, String trustStoreType, String trustStoreFile, String trustStorePassword) throws GeneralSecurityException, IOException {
        KeyStore privateKeyStore = KeystoreUtil.loadKeyStore(privateKeyStoreType, privateKeyStorePassword, privateKeyStoreFile);
        KeyStore trustStore = KeystoreUtil.loadKeyStore(trustStoreType, trustStorePassword, trustStoreFile);
        KeystoreUtil.checkPrivateKey(privateKeyStore, privateKeyPassword.toCharArray(), privateKeyAlias);
        KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmFactory.init(privateKeyStore, privateKeyPassword.toCharArray());
        KeyManager[] keyManagers = kmFactory.getKeyManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            keyManagers[i] = new AliasForcingX509KeyManager((X509KeyManager)keyManagers[i], privateKeyAlias);
        }
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(trustStore);
        TrustManager[] trustManagers = tmFactory.getTrustManagers();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, trustManagers, null);
        return context.getSocketFactory();
    }

    private static void checkPrivateKey(KeyStore keyStore, char[] keyPassword, String keyAlias) throws GeneralSecurityException {
        if (!keyStore.containsAlias(keyAlias)) {
            String errorMsg = "The SSLSocketFactory keystore doesn't have key alias '" + keyAlias + "'.";
            throw new GeneralSecurityException(errorMsg);
        }
        if (!keyStore.isKeyEntry(keyAlias)) {
            String errorMsg = "The SSLSocketFactory keystore doesn't have a private key for alias '" + keyAlias + "'.";
            throw new GeneralSecurityException(errorMsg);
        }
        try {
            keyStore.getKey(keyAlias, keyPassword);
        }
        catch (UnrecoverableKeyException e) {
            String errorMsg = "Couldn't recover the private key in the SSLSocketFactory keystore. The most likely reason is that the key password is wrong.";
            throw new GeneralSecurityException("Couldn't recover the private key in the SSLSocketFactory keystore. The most likely reason is that the key password is wrong.", e);
        }
    }

    private static class AliasForcingX509KeyManager
    implements X509KeyManager {
        private final X509KeyManager baseKM;
        private final String keyAlias;

        public AliasForcingX509KeyManager(X509KeyManager keyManager, String keyAlias) {
            this.baseKM = keyManager;
            this.keyAlias = keyAlias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyAlias;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.baseKM.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.baseKM.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.baseKM.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.baseKM.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.baseKM.getServerAliases(keyType, issuers);
        }
    }
}

