/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.util;

import au.gov.nehta.vendorlibrary.mdm.enums.FormatTypes;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import java.util.List;
import java.util.Map;

public final class MDMValidationException
extends Exception {
    private final Map<String, List<String>> failMessages;

    public MDMValidationException(String message, Map<String, List<String>> failMessages) {
        super(message);
        this.failMessages = failMessages;
    }

    public int size() {
        return this.failMessages.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(FormatTypes.ERROR_HEADER.getStructure(), MDMValidation.class.getName(), super.getMessage()));
        for (Map.Entry<String, List<String>> entry : this.failMessages.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":\n");
            List<String> messages = entry.getValue();
            if (messages.isEmpty()) continue;
            for (String message : messages) {
                sb.append("\t");
                sb.append(message);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

