


-- Add rows to [hips].[Hospital]
SET IDENTITY_INSERT [hips].[Hospital] ON
INSERT INTO [hips].[Hospital] ([HospitalId], [Description], [Name], [HealthProviderOrganisationId], [AuthorisedEmployeeName], [AuthorisedEmployeeUserId], [UploadDocumentMinimumAge], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'eHISC', 'eHealth Sample Hospital', 1, 'Name of Authorised Employee', 'ID of Authorised Employee', 18, '2012-03-28 09:57:59.343', 'HIPS', '2012-07-25 12:58:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[Hospital] OFF

-- Adds in Logo - set as eHISC Health Logo
EXEC(N'UPDATE [hips].[Hospital] SET [Logo]=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 WHERE [HospitalId]=1')
EXEC(N'UPDATE [hips].[Hospital] SET [Logo].WRITE(0x5a51dbd0884cca5905423187b4a8a8886fc75e197cda5098419a2167a1702ef7b0ac9f56bb5c46fb15d728d52134812fa5f5225acfc0651e373f3f5ff3a97e7a7d79fd4bec4c0fa5b099559b6f8575a4dd026e9f0ec29b97e10f6eb3f8a8a8fff6988588b6657c5046428f1e3afe9eaa39cb9d3599c0650347b44fac1028f2460d6d0c2e491c1ef6b838742d2e10cc4c0cda5f2cb85abdfffefb48494dc3260707d89ae9237297331262f6f10118e514fe3652eeaa2d5ca95a3b50df3188868e7e3429d5e0b2d098e5bd4d4a567d26d09967ee1aa4f0f9221fecd1d1da82caaa2a1eda3210d9f43d56ad66afa3c02593109052f2b4d905a51c6009f3b8b43c8342693684915593c5e499d93291488cd4b434fe648d9c07ec07c018bc1e9210f5635eee00ef58e01eecd2c1d2e81778b8ac1e80310fd21306687d334573f4ef1703f787cec71d9e483f06b8a3ba83e8fd4870dfbefa1edeb97a655c305fffe63a56257ad27166f22765540ea886bd2a13ab402f0d5fcfd7b3cfb2267107def9e8bd490b2dd38f06ee4889282c9d3fef45786fdf8a13432751dbcbba8a8e434190328fdb4cde95f5e9d628d5a3ae18b8cab6c3a86c1f449daa8d2f6b6e6e81a2a59387ce756d3db41f85cce5e5a3c06580df022e83549685c28643b4ef7175716a78bd1a60796e31720b4b298c96514e2c425186009646bad4f08ccf13dd4fb11bd043c472dedb87cd3783cb2ca55f1701754bc8633fc3c729ff9be373f02ddd4a471cfb66658f831134e521fb709566c90f0777d4133038b8a327afa7b796e077ce0be8fa6720a34d5d10d3aaea48332c63b7f289017fbbc383e2d97864f6d89ac75c5ee2d7a9bb6fe3983fe972e8d5014cf7564f1364c686421e3e7744b3766cb14256fdf13684570a7858fd20e99e80cbc47e596fe3065b0c1e3b862af2ae8d5dc778714a3d31416b6a6899b51eea46c3c04514b5b02e2275118b55a81b2944ae27c019f037833b96c76539aeaca01c75bd67d1786800d9b9f96a98695d3abde61495a3aaeb34aa5bbab9f7cd4e3d0869901b4c16cf254f2dd55cfd832596afed9052d8bc6aec82d558e032afcb725a4b36ec914de1a35cf7b776cfc168ff261476d5e2e4dfcee1f89b67517944852de941f8bdeb225ec4918e00e8c706f7a37f5ce31e349af2d1a5fbd7f36744b147c9b0e3b3f78bc3ed105923e6a3a4d8b3a3b4d3f1d83a7b912f6f58d873a8585f2d9bc994d890c98742fed681220b7e8dcbd17abaf7b65e9a559b67f99bf386826dcf1e126793e081c4c62c3e71ffd5775e47f3a91efe39030ae3f0cade75f8ade30bd0d93b891f163711b15f3970747484cb86d538d3cb3c6813aa946d7c823c0b959bc9f83cde61805bd044392debd765452b156dcfb6615d448ae6363e7161dce04ac490e516a1a8ae0d79e455b561b23ac795a2a4be154d475f4365430b72b2b311e6b7138b17ccc5662717fe989b07559f7ff905dc24e4795791e7bd09deb1c065c62613b0629475aa117e6d4df08ed8672c7b72a71e9fc0ae150377e4531e73bbaa356bc62706ee8bbb6d68ffe99aa73c5ec375f2629b52bcd4b93bb3354f51a342d7a6f94ceb68dd7bd73ee08f59d58e331e692cdc65e08d1c35c5e07f31d006cd43ddfcf877d29137866075d01d8f3acd1b75dc87e93b64afdae36b97b3e75db16bfa4580fbc5175f604f70300c5e9e8b820301e8aace4797aa1eed94bf1e6ea8405b6d39544a25e5b504e530c094df92a7ad6e5451084ca1726b1b14878ea0b6f3046a95ad6386cab7cb713332d4de554c10b34117dae5ac3895575e87c2ba1614e6e5a12e4f0afb95e6fcf953172e3cf80f0e63a19bab30906ef6d19ef7b6e0f6eba1ed6f497cdf1e82883d0982f5736af763f61f5be6e1e5d03588a812e232e59423c56e56d550171c4481082c8e47ef0427b3b3df424a6bce871f79af9aa3adf8eafa573ce4acec53604f7e1c420be31156148fe0c2830829884100bd2fe96be4b37ad8b98f5d3a8bc82a112c625df96358ff63f33c0ed6c3eb9ee5ef6778196375d20ec8da4b879ffc385e350d1d86537a30e6065ae189cdcfe35fec9ec1afe8fbf8d74d7fc51fdd97f0a2da26913fbf9eaf281c7fd074cf42e5372e5d828bab1bf4962dc6eecdab71b43c1da7ebf331549c86a38569e8aac841735d0daf34b30af20d0fccc267b6ac15aa4e3634f23caa5afb28c4568d1b5c09eb1e62337b2a6a91955730ec7525e919c8a2f0b8582e4459ca3ea4f83a427f9efa273ebff966723ce59f8591eed2104db5590def58e026f6e8a260883ed7b7373c058386dde02c073c77f975feca461969fb3cc7d28350c061d7c7bcf53b57dfe3f92e33f69ecdfe6185a9bb151b45c57e8df1b3afbfd41cf76d3e59818db3668dc7ed1ef3fa20e89e81ab556b7b071effd39f10b5c309674a85b8589381b315620c950870a458848eaa02a81aeac9c3de1a3eb350b9bab5874f091cafc7e59066e6a2a2ed0814dda778114a249270680be45254a7274016ea09371b1d18ebebc073a737ff6ddfc9a44f3fff079c527d095eb5e77d88bc90165cf5ec1f5d285e8fa2ed1ecccfa5ed86b95713377e09bae7e032c5c5c5c24077395cd798a3343e18e7aa327081003e532ac2c96201fa4ad2d156530295a2419dff6ae1a5dc96750f2928ac1e778e2b1222b3a01cb5046d75733732b2f3909d2141b55cc0a7fbf9ad3385e9b24558bfc901758d13fb498d0749ac60e5924661331b61b57ec630b80729a755be7e00848666cb29fd1c755fc065aaab6f80dd860db036364090d35a28c591b8582bc379829879e2932542749765a2b5ba947705318015ad9da86f3e04a566e0c6cde08ed51dc41e3b23cd2e405679031f5051c1c2e2e47d88dcba1ab686afc06ac50a3e88e3bbef26ff8dfdf1679f607bc65e82f7492c089d03f1513d82365ab3764a3f67dd3770b5cacace86999905ac0d7510efe38cdebc64bc5e97897365220ccaa3a190c5f36756f1e254e751d4749f45b5b2833f6d632c706f1e392592a6f39155c57231aac43148f377c2469325d0238f1f16be9fffaac1cf499f50d81c5a1883f5523df4be930ef6dbb953faf9ebbe83cbf4c5175f617f6434cc4d4db0d1ca1892a06dc8dae3817d5b57a15276103d873b39bcca8e1ed4759f4615e5ab6315a754142a6bc19510b06296c766a6a3469e8ccc7dbbe0b9ca00a6ba4be0eee989439d9d9ab34f694a935f3f09b85a7df4d155ecd8e50d237d5d182e5d8c050be62270ab1d7a2b73d0dfaa503f494375983ceea151c529b1448abca262febb430504ae402441962c1dd599429424ecc19ecd36b05cbe0876eb37a0a46c627348a734a5c9a09f145cadd82484bc8202a4094530d4d3c1260b5d644505e0487d117a5a1450b1ee210a9dcbca2b787e2acf48477d491eda550a949496a238230d35e268c46edf80153a0b78bf6c7c720a9ffc3fa529fd1cf540803b52ac28e5e2ea0e630a7177ac354395f0008e3657a3abbd85ff4c2683b4222d02b951fe68ca11a0a3580ae16e573898bc02537d1df807efc1b58f3fd61c6d4a53fa79ea810357ab9cdc3cd8addb004bdd5710eab2164db969385422438abf0b36992e81d1d297b0de5407ae96cb6069b004ceeeeea86b68d4ec3da529fdbcf5c082cbc41e1f1313170f0b3353d81a2d85abb52e4c755e81fbb6ed104bd3e1e71f80750477ba4c3ea9a7684d694a13d5030dae5647068f224d24425272324aca2af0e187ea71a96c52c0bbefddf8c98c294de99721e0ff032d3e53d0c952d57f0000000049454e44ae426082,NULL,NULL) WHERE [HospitalId]=1')


-- Add rows to [hips].[Address]
SET IDENTITY_INSERT [hips].[Address] ON
INSERT INTO [hips].[Address] ([AddressId], [AddressLine1], [AddressLine2], [PlaceName], [AustralianStateId], [InternationalStateCode], [Postcode], [CountryId], [AddressTypeId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, '1 Medical Road', NULL, 'Place Name', 1, NULL, '5000', 71, 4, '2012-12-12 00:00:00.000', 'HIPS', '2012-12-12 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[Address] OFF

-- Add rows to [hips].[Contact]
SET IDENTITY_INSERT [hips].[Contact] ON
--BOTH Main Phone and Fax are required
--main phone number
INSERT INTO [hips].[Contact] ([ContactId], [Detail], [ContactMethodId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, '(08) 8888 6666', 6, '2012-10-17 09:21:18.677', 'HIPS', '2012-10-17 09:21:18.677', 'HIPS')
--fax number
INSERT INTO [hips].[Contact] ([ContactId], [Detail], [ContactMethodId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, '(08) 8888 7777', 7, '2012-10-17 09:21:18.677', 'HIPS', '2012-10-17 09:21:18.677', 'HIPS')
SET IDENTITY_INSERT [hips].[Contact] OFF

-- Add rows to [hips].[HospitalAddress]
INSERT INTO [hips].[HospitalAddress] ([HospitalId], [AddressId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 1, '2012-10-17 09:17:10.360', 'HIPS', '2012-10-17 09:17:10.360', 'HIPS')

-- Add rows to [hips].[HospitalContact]
INSERT INTO [hips].[HospitalContact] ([HospitalId], [ContactId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 1, '2012-10-17 09:23:27.583', 'HIPS', '2012-10-17 09:23:27.583', 'HIPS')
INSERT INTO [hips].[HospitalContact] ([HospitalId], [ContactId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 2, '2012-10-17 09:23:27.583', 'HIPS', '2012-10-17 09:23:27.583', 'HIPS')


-- Add rows to [hips].[HospitalCode]
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 1, '8003624900000594', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 2, 'RHH', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 5, '1.2.36.1.2001.1005.14.1078.55', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 6, '1.2.36.1.2001.1005.14.660.55', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 7, '0055', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 107, 'Users', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
