﻿using System;
using System.Reflection;
using System.Runtime.Serialization;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.Base.Schemas
{
    /// <summary>
    /// Base schema
    /// </summary>
    [KnownType(typeof(BaseSchema))]
    [Serializable]
    [DataContract]
    public class BaseSchema : HipsObservableObject
    {
        #region Private members

        private DateTime dateCreated;
        private DateTime dateModified;
        private int? id;
        private string userCreated;
        private string userModified;

        #endregion Private members

        #region Properties

        /// <summary>
        /// Gets or sets the Date and Time that this record was created.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public DateTime DateCreated
        {
            get
            {
                return dateCreated;
            }
            set
            {
                dateCreated = value;
            }
        }

        /// <summary>
        /// Gets or sets the Date and Time that this record was last modified.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.UpdateData)]
        [DataMember]
        public DateTime DateModified
        {
            get
            {
                return dateModified;
            }
            set
            {
                dateModified = value;
            }
        }

        /// <summary>
        /// Gets or sets the primary key of this record.
        /// </summary>
        [DataMember]
        public int? Id
        {
            get
            {
                return id;
            }
            set
            {
                id = value;
            }
        }

        /// <summary>
        /// Gets or sets the user who created this record.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public string UserCreated
        {
            get
            {
                return userCreated;
            }
            set
            {
                userCreated = value;
            }
        }

        /// <summary>
        /// Gets or sets the user who last modified this record
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        [DataMember]
        public virtual string UserModified
        {
            get
            {
                return userModified;
            }
            set
            {
                userModified = value;
            }
        }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Updates the properties of this object based on the source item.
        /// </summary>
        /// <typeparam name="T">Concrete type of the source item.</typeparam>
        /// <param name="sourceItem">The source item.</param>
        public void Update<T>(T sourceItem)
        {
            PropertyInfo[] fromFields = typeof(T).GetProperties();
            for (int count = 0; count < fromFields.Length; count++)
            {
                PropertyInfo fromField = (PropertyInfo)fromFields[count];
                if (fromField.CanWrite)
                {
                    //PropertyInfo toField = (PropertyInfo)toFields[count];
                    object value = fromField.GetValue(sourceItem, null);
                    fromField.SetValue(this, value, null);
                }
            }
        }

        #endregion Methods
    }
}