﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;


namespace HIPS.Base.Schemas
{
    /// <summary>
    /// This class represents a country
    /// </summary>
    [Serializable]
    public class SystemErrorLog : BaseSchema
    {
        #region Private Members
        private int systemErrorLogId;
        private string message;
        private string exceptionMessage;

        #endregion

        /// <summary>
        /// Gets or sets the error id.
        /// </summary>
        /// <value>
        /// The error id.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int SystemErrorLogId
        {
            get
            {
                return this.systemErrorLogId;
            }
            set
            {
                this.systemErrorLogId = value;
            }
        }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public string Message
        {
            get
            {
                return this.message;
            }
            set
            {
                this.message = value;
            }
        }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        /// <value>
        /// The exception message.
        /// </value>
         [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string ExceptionMessage
        {
            get
            {
                return this.exceptionMessage;
            }
            set
            {
                this.exceptionMessage = value;
            }
        }
    }
}
