﻿using System.Collections.Generic;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Common CDA constants.
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// Map of filename extensions to attachment types.
        /// </summary>
        public readonly static IDictionary<string, AttachmentType> FilenameExtensionMap = new Dictionary<string, AttachmentType>
        {
            {"png", AttachmentType.AttachedImagePng},
            {"jpg", AttachmentType.AttachedImageJpeg},
            {"jpeg", AttachmentType.AttachedImageJpeg},
            {"tif", AttachmentType.AttachedImageTiff},
            {"tiff", AttachmentType.AttachedImageTiff},
            {"gif", AttachmentType.AttachedImageGif},
            {"pdf", AttachmentType.AttachedDocumentPdf},
        };

        /// <summary>
        /// Set of captions for attachments.
        /// </summary>
        public class AttachmentCaption
        {
            /// <summary>
            /// Caption for the link to the PDF file containing the main clinical content of the Level 1A CDA document.
            /// </summary>
            public const string DISCHARGE_SUMMARY_UNSTRUCTURED_BODY = "Discharge Summary";

            /// <summary>
            /// Caption for the organisational logo.
            /// </summary>
            public const string ORGANISATIONAL_LOGO = "Organisation Logo";
        }

        /// <summary>
        /// Set of reserved file names for attachments.
        /// </summary>
        public class AttachmentFileName
        {
            /// <summary>
            /// Name of the PNG file containing the organisational logo displayed in the header of the Level 1A CDA document.
            /// </summary>
            public const string ORGANISATIONAL_LOGO = "logo.png";

            /// <summary>
            /// Name of the PDF file containing the main clinical content of the Level 1A CDA document.
            /// </summary>
            public const string UNSTRUCTURED_BODY = "content.pdf";
        }

        /// <summary>
        /// Set of country names with special meaning.
        /// </summary>
        public class CountryName
        {
            /// <summary>
            /// Country name that causes mapping to Australian Address instead of International Address.
            /// </summary>
            public const string AUSTRALIA = "Australia";
        }

        /// <summary>
        /// Set of known document format codes (template package IDs) for uploading to PCEHR.
        /// </summary>
        public class DocumentFormatCode
        {
            /// <summary>
            /// PCEHR R4 - Discharge Summary - Conformance 1A - HPI-I enforced
            /// </summary>
            public const string DISCHARGE_SUMMARY_1A_ENFORCED = "1.2.36.1.2001.1006.1.20000.23";

            /// <summary>
            /// PCEHR R4 - Discharge Summary - Conformance 1A - HPI-I relaxed
            /// </summary>
            public const string DISCHARGE_SUMMARY_1A_RELAXED = "1.2.36.1.2001.1006.1.20000.18";
        }

        /// <summary>
        /// Set of format strings for generating OIDs.
        /// </summary>
        public class Oid
        {
            /// <summary>
            /// HIPS registered OID for Document ID.
            /// The HPI-O and the numeric Document ID must be appended to this OID.
            /// </summary>
            public const string DOCUMENT_ID = "1.2.36.1.2001.1005.49.1";

            /// <summary>
            /// HIPS registered OID for Document Set ID.
            /// The HPI-O must be appended to this OID.
            /// </summary>
            public const string DOCUMENT_SET_ID = "1.2.36.1.2001.1005.49.2";

            /// <summary>
            /// HIPS registered OID for a patient's Medical Record Number (MRN).
            /// The HPI-O and the numeric Hospital ID must be appended to this OID.
            /// </summary>
            public const string MRN = "1.2.36.1.2001.1005.49.3";
        }
    }
}